/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.folderauth;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.SidACL;
import io.jenkins.plugins.folderauth.FolderAuthorizationStrategyManagementLink;
import io.jenkins.plugins.folderauth.Messages;
import io.jenkins.plugins.folderauth.acls.GenericAclImpl;
import io.jenkins.plugins.folderauth.acls.GlobalAclImpl;
import io.jenkins.plugins.folderauth.misc.PermissionWrapper;
import io.jenkins.plugins.folderauth.roles.AbstractRole;
import io.jenkins.plugins.folderauth.roles.AgentRole;
import io.jenkins.plugins.folderauth.roles.FolderRole;
import io.jenkins.plugins.folderauth.roles.GlobalRole;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

@ParametersAreNonnullByDefault
public class FolderBasedAuthorizationStrategy
extends AuthorizationStrategy {
    private static final Logger LOGGER = Logger.getLogger(FolderBasedAuthorizationStrategy.class.getName());
    private static final String ADMIN_ROLE_NAME = "admin";
    private static final String FOLDER_SEPARATOR = "/";
    private final Set<AgentRole> agentRoles;
    private final Set<GlobalRole> globalRoles;
    private final Set<FolderRole> folderRoles;
    private transient GlobalAclImpl globalAcl;
    private transient ConcurrentHashMap<String, GenericAclImpl> jobAcls = new ConcurrentHashMap();
    private transient ConcurrentHashMap<String, GenericAclImpl> agentAcls = new ConcurrentHashMap();
    private transient Cache<String, SidACL> jobAclCache;

    @DataBoundConstructor
    public FolderBasedAuthorizationStrategy(Set<GlobalRole> globalRoles, Set<FolderRole> folderRoles, Set<AgentRole> agentRoles) {
        this.agentRoles = ConcurrentHashMap.newKeySet();
        this.globalRoles = ConcurrentHashMap.newKeySet();
        this.folderRoles = ConcurrentHashMap.newKeySet();
        this.globalRoles.addAll(globalRoles);
        this.folderRoles.addAll(folderRoles);
        this.agentRoles.addAll(agentRoles);
        this.initCache();
        this.generateNewGlobalAcl();
        this.updateJobAcls(true);
        this.updateAgentAcls();
    }

    private synchronized void updateJobAcls(boolean doClear) {
        if (doClear) {
            this.jobAcls.clear();
        }
        for (FolderRole role : this.folderRoles) {
            this.updateAclForFolderRole(role);
        }
    }

    private synchronized void updateAgentAcls() {
        this.agentAcls.clear();
        for (AgentRole role : this.agentRoles) {
            this.updateAclForAgentRole(role);
        }
    }

    @Nonnull
    public GlobalAclImpl getRootACL() {
        return this.globalAcl;
    }

    @Nonnull
    protected Object readResolve() {
        this.jobAcls = new ConcurrentHashMap();
        this.agentAcls = new ConcurrentHashMap();
        this.initCache();
        this.generateNewGlobalAcl();
        this.updateJobAcls(true);
        return this;
    }

    @Nonnull
    public SidACL getACL(@Nonnull Job<?, ?> project) {
        return this.getACL((AbstractItem)project);
    }

    @Nonnull
    public SidACL getACL(@Nonnull AbstractItem item) {
        String fullName = item.getFullName();
        SidACL acl = (SidACL)this.jobAclCache.getIfPresent((Object)fullName);
        if (acl != null) {
            return acl;
        }
        String[] splits = fullName.split(FOLDER_SEPARATOR);
        StringBuilder sb = new StringBuilder(fullName.length());
        acl = this.globalAcl;
        for (String str : splits) {
            sb.append(str);
            SidACL newAcl = this.jobAcls.get(sb.toString());
            if (newAcl != null) {
                acl = acl.newInheritingACL(newAcl);
            }
            sb.append(FOLDER_SEPARATOR);
        }
        this.jobAclCache.put((Object)fullName, (Object)acl);
        return acl;
    }

    @Nonnull
    public SidACL getACL(@Nonnull Computer computer) {
        String name = computer.getName();
        SidACL acl = this.agentAcls.get(name);
        if (acl == null) {
            return this.globalAcl;
        }
        return this.globalAcl.newInheritingACL(acl);
    }

    @Nonnull
    public Collection<String> getGroups() {
        ConcurrentHashMap.KeySetView groups = ConcurrentHashMap.newKeySet();
        ((Stream)this.globalRoles.stream().parallel()).map(AbstractRole::getSids).forEach(groups::addAll);
        ((Stream)this.folderRoles.stream().parallel()).map(AbstractRole::getSids).forEach(groups::addAll);
        ((Stream)this.agentRoles.stream().parallel()).map(AbstractRole::getSids).forEach(groups::addAll);
        return Collections.unmodifiableCollection(groups);
    }

    private synchronized void generateNewGlobalAcl() {
        this.globalAcl = new GlobalAclImpl(this.globalRoles);
    }

    public void addGlobalRole(@Nonnull GlobalRole globalRole) throws IOException {
        this.globalRoles.add(globalRole);
        try {
            Jenkins.get().save();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unable to save config file, not adding global role", e);
            this.globalRoles.remove(globalRole);
            throw e;
        }
        finally {
            this.generateNewGlobalAcl();
            this.jobAclCache.invalidateAll();
        }
    }

    @Nonnull
    public Set<GlobalRole> getGlobalRoles() {
        return Collections.unmodifiableSet(this.globalRoles);
    }

    @Nonnull
    public Set<AgentRole> getAgentRoles() {
        return Collections.unmodifiableSet(this.agentRoles);
    }

    public void assignSidToGlobalRole(String roleName, String sid) throws IOException {
        GlobalRole role = this.globalRoles.stream().filter(r -> r.getName().equals(roleName)).findAny().orElseThrow(() -> new NoSuchElementException("No GlobalRole with the name " + roleName + "exists."));
        role.assignSids(sid);
        try {
            Jenkins.get().save();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unable to save config file, not assigning the sids.", e);
            role.unassignSids(sid);
            throw e;
        }
        finally {
            this.generateNewGlobalAcl();
            this.jobAclCache.invalidateAll();
        }
    }

    @Nonnull
    public Set<FolderRole> getFolderRoles() {
        return Collections.unmodifiableSet(this.folderRoles);
    }

    public void addFolderRole(@Nonnull FolderRole folderRole) throws IOException {
        this.folderRoles.add(folderRole);
        try {
            Jenkins.get().save();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unable to save configuration when adding folder role.", e);
            this.folderRoles.remove(folderRole);
            throw e;
        }
        finally {
            this.jobAclCache.invalidateAll();
            this.updateAclForFolderRole(folderRole);
        }
    }

    public void addFolderRole(@Nonnull AgentRole agentRole) throws IOException {
        this.agentRoles.add(agentRole);
        try {
            Jenkins.get().save();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unable to save configuration when adding agent role.", e);
            this.agentRoles.remove(agentRole);
            throw e;
        }
        finally {
            this.updateAclForAgentRole(agentRole);
        }
    }

    public void assignSidToFolderRole(String roleName, String sid) throws IOException {
        FolderRole role = this.folderRoles.stream().filter(r -> r.getName().equals(roleName)).findAny().orElseThrow(() -> new NoSuchElementException("No FolderRole with the name " + roleName + " exists."));
        role.assignSids(sid);
        try {
            Jenkins.get().save();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unable to save config file, not assigning the sids.", e);
            role.unassignSids(sid);
            throw e;
        }
        finally {
            this.updateAclForFolderRole(role);
        }
    }

    public void assignSidToAgentRole(String roleName, String sid) throws IOException {
        AgentRole role = this.agentRoles.stream().filter(r -> r.getName().equals(roleName)).findAny().orElseThrow(() -> new NoSuchElementException("No AgentRole with the name " + roleName + " exists."));
        role.assignSids(sid);
        try {
            Jenkins.get().save();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unable to save config file, not assigning the sids.", e);
            role.unassignSids(sid);
            throw e;
        }
        finally {
            this.updateAclForAgentRole(role);
        }
    }

    private void updateAclForFolderRole(@Nonnull FolderRole role) {
        for (String name : role.getFolderNames()) {
            this.updateGenericAcl(name, this.jobAcls, role);
        }
    }

    private void updateAclForAgentRole(@Nonnull AgentRole role) {
        for (String agent : role.getAgents()) {
            this.updateGenericAcl(agent, this.agentAcls, role);
        }
    }

    private void updateGenericAcl(String fullName, ConcurrentHashMap<String, GenericAclImpl> acls, AbstractRole role) {
        GenericAclImpl acl = acls.get(fullName);
        if (acl == null) {
            acl = new GenericAclImpl();
        }
        acl.assignPermissions(role.getSids(), role.getPermissions().stream().map(PermissionWrapper::getPermission).collect(Collectors.toSet()));
        acls.put(fullName, acl);
    }

    public void deleteGlobalRole(String roleName) throws IOException {
        if (roleName.equals(ADMIN_ROLE_NAME)) {
            throw new IllegalArgumentException("The admin role cannot be deleted.");
        }
        GlobalRole role = this.globalRoles.stream().filter(r -> r.getName().equals(roleName)).findAny().orElseThrow(() -> new NoSuchElementException("No GlobalRole with the name " + roleName + " exists."));
        this.globalRoles.remove(role);
        try {
            Jenkins.get().save();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unable to save the config when deleting global role. The role was not deleted.", e);
            this.globalRoles.add(role);
            throw e;
        }
        finally {
            this.generateNewGlobalAcl();
        }
    }

    public void deleteFolderRole(String roleName) throws IOException {
        FolderRole role = this.folderRoles.stream().filter(r -> r.getName().equals(roleName)).findAny().orElseThrow(() -> new NoSuchElementException("No FolderRole with the name " + roleName + " exists."));
        this.folderRoles.remove(role);
        try {
            Jenkins.get().save();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unable to save the config when deleting folder role. The role was not deleted.", e);
            this.folderRoles.add(role);
            throw e;
        }
        finally {
            this.updateJobAcls(true);
            this.jobAclCache.invalidateAll();
        }
    }

    public void deleteAgentRole(String roleName) throws IOException {
        AgentRole role = this.agentRoles.stream().filter(r -> r.getName().equals(roleName)).findAny().orElseThrow(() -> new NoSuchElementException("No AgentRole with the name " + roleName + " exists."));
        this.agentRoles.remove(role);
        try {
            Jenkins.get().save();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unable to save the config when deleting agent role. The role was not deleted.", e);
            this.agentRoles.add(role);
            throw e;
        }
        finally {
            this.updateJobAcls(true);
            this.jobAclCache.invalidateAll();
        }
    }

    private void initCache() {
        this.jobAclCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(2048L).build();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AuthorizationStrategy> {
        @Nonnull
        public String getDisplayName() {
            return Messages.FolderBasedAuthorizationStrategy_DisplayName();
        }

        @Nonnull
        public FolderBasedAuthorizationStrategy newInstance(@Nullable StaplerRequest req, @Nonnull JSONObject formData) {
            AuthorizationStrategy strategy = Jenkins.get().getAuthorizationStrategy();
            if (strategy instanceof FolderBasedAuthorizationStrategy) {
                return (FolderBasedAuthorizationStrategy)strategy;
            }
            HashSet<PermissionGroup> groups = new HashSet<PermissionGroup>(PermissionGroup.getAll());
            groups.remove(PermissionGroup.get(Permission.class));
            Set<PermissionWrapper> adminPermissions = PermissionWrapper.wrapPermissions(FolderAuthorizationStrategyManagementLink.getSafePermissions(groups));
            GlobalRole adminRole = new GlobalRole(FolderBasedAuthorizationStrategy.ADMIN_ROLE_NAME, adminPermissions);
            adminRole.assignSids(new PrincipalSid(Jenkins.getAuthentication()).getPrincipal());
            return new FolderBasedAuthorizationStrategy(Collections.singleton(adminRole), Collections.emptySet(), Collections.emptySet());
        }
    }
}

