/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.finitestate;

import hudson.model.Action;
import hudson.model.Run;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.RunAction2;

public class FiniteStateConsolidatedResultsAction
implements RunAction2,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Run build;
    private List<AnalysisResult> results = new ArrayList<AnalysisResult>();

    public void addResult(String analysisType, String projectName, String consoleOutput, String status, String scanUrl) {
        this.results.add(new AnalysisResult(analysisType, projectName, consoleOutput, status, scanUrl));
    }

    public List<AnalysisResult> getResults() {
        return this.results;
    }

    public boolean hasResults() {
        return !this.results.isEmpty();
    }

    public static FiniteStateConsolidatedResultsAction getOrCreate(Run<?, ?> build) {
        FiniteStateConsolidatedResultsAction action = (FiniteStateConsolidatedResultsAction)build.getAction(FiniteStateConsolidatedResultsAction.class);
        if (action == null) {
            action = new FiniteStateConsolidatedResultsAction();
            build.addAction((Action)action);
        }
        return action;
    }

    public String getIconFileName() {
        return "clipboard.png";
    }

    public String getDisplayName() {
        return "Finite State Results";
    }

    public String getUrlName() {
        return "finite_state_results";
    }

    public void onAttached(Run<?, ?> build) {
        this.build = build;
    }

    public void onLoad(Run<?, ?> build) {
        this.build = build;
    }

    public Run getRun() {
        return this.build;
    }

    public static class AnalysisResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String analysisType;
        private String projectName;
        private String consoleOutput;
        private String status;
        private String scanUrl;

        public AnalysisResult(String analysisType, String projectName, String consoleOutput, String status, String scanUrl) {
            this.analysisType = analysisType;
            this.projectName = projectName;
            this.consoleOutput = consoleOutput;
            this.status = status;
            this.scanUrl = scanUrl;
        }

        public String getAnalysisType() {
            return this.analysisType;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getConsoleOutput() {
            return this.consoleOutput;
        }

        public String getStatus() {
            return this.status;
        }

        public String getScanUrl() {
            return this.scanUrl;
        }
    }
}

