/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.extratoolinstallers.installers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

class WrongVersionException
extends IOException {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String executableName;
    @NonNull
    private final String whereFound;
    @NonNull
    private final String detectedVersion;
    @CheckForNull
    private final String minVersion;
    @CheckForNull
    private final String maxVersion;

    @Restricted(value={NoExternalUse.class})
    WrongVersionException(@NonNull String executableName, @NonNull String whereFound, @NonNull String detectedVersion, @Nullable String minVersion, @Nullable String maxVersion, @Nullable Throwable cause) {
        super("Executable '" + executableName + "' at " + whereFound + " is version \"" + detectedVersion + "\" but we require" + (String)(minVersion != null ? " >= \"" + minVersion + "\"" : "") + (minVersion != null && maxVersion != null ? " and " : "") + (String)(maxVersion != null ? " <= \"" + maxVersion + "\"" : ""), cause);
        this.executableName = executableName;
        this.whereFound = whereFound;
        this.detectedVersion = detectedVersion;
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
    }

    @Restricted(value={NoExternalUse.class})
    WrongVersionException(@NonNull String executableName, @NonNull String whereFound, @NonNull String detectedVersion, @Nullable String minVersion, @Nullable String maxVersion) {
        this(executableName, whereFound, detectedVersion, minVersion, maxVersion, null);
    }

    public String getExecutableName() {
        return this.executableName;
    }

    public String getWhereFound() {
        return this.whereFound;
    }

    public String getDetectedVersion() {
        return this.detectedVersion;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }
}

