/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import dev.langchain4j.model.output.structured.Description;
import java.util.List;

public record JenkinsLogAnalysis(@Description(value={"Error summary"}) String errorSummary, @Description(value={"Resolution steps"}) List<String> resolutionSteps, @Description(value={"Best practices"}) List<String> bestPractices, @Description(value={"Error snippet"}) String errorSignature) {
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(4096);
        sb.append("Summary: ").append(this.errorSummary).append("\n");
        if (this.errorSignature != null) {
            sb.append("\n").append("Failed Snippet: ");
            sb.append(this.errorSignature).append("\n");
        }
        if (this.resolutionSteps != null && !this.resolutionSteps.isEmpty()) {
            sb.append("\n").append("Resolution Steps:\n");
            for (String step : this.resolutionSteps) {
                sb.append("- ").append(step).append("\n");
            }
        }
        if (this.bestPractices != null && !this.bestPractices.isEmpty()) {
            sb.append("\n").append("Best Practices:\n");
            for (String step : this.bestPractices) {
                sb.append("- ").append(step).append("\n");
            }
        }
        return sb.toString();
    }
}

