/*
 * Decompiled with CFR 0.152.
 */
package io.superstudios.plugins.diversion;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.model.Item;
import hudson.util.ListBoxModel;
import io.superstudios.plugins.diversion.DiversionApiClient;
import io.superstudios.plugins.diversion.DiversionBranch;
import io.superstudios.plugins.diversion.DiversionRepository;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class DiversionUIHelper {
    public static ListBoxModel fillCredentialsIdItems(Item context, String credentialsId) {
        StandardListBoxModel items = new StandardListBoxModel();
        if (context == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !context.hasPermission(CredentialsProvider.USE_ITEM)) {
            return items;
        }
        items.add("- Select credentials -", "");
        List credentials = CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)context, null, Collections.emptyList());
        for (StringCredentials cred : credentials) {
            String id = cred.getId();
            String description = cred.getDescription();
            String displayName = description != null && !description.isEmpty() ? id + " (" + description + ")" : id;
            items.add(displayName, id);
        }
        return items;
    }

    public static ListBoxModel fillRepositoryIdItems(String credentialsId, String errorPrefix) {
        ListBoxModel items = new ListBoxModel();
        if (credentialsId == null || credentialsId.isEmpty()) {
            items.add("- Select credentials first -", "");
            return items;
        }
        try {
            DiversionApiClient client = new DiversionApiClient(credentialsId);
            List<DiversionRepository> repos = client.listRepositories();
            Collections.sort(repos, (a, b) -> a.getName().compareToIgnoreCase(b.getName()));
            items.add("- Select repository -", "");
            for (DiversionRepository repo : repos) {
                items.add(repo.getName() + " (" + repo.getId() + ")", repo.getId());
            }
        }
        catch (Exception e) {
            String errorMsg = (errorPrefix != null ? errorPrefix : "Error") + ": " + e.getMessage();
            items.add(errorMsg, "");
        }
        return items;
    }

    public static ListBoxModel fillBranchItems(String credentialsId, String repositoryId, String errorPrefix) {
        ListBoxModel items = new ListBoxModel();
        if (credentialsId == null || credentialsId.isEmpty() || repositoryId == null || repositoryId.isEmpty()) {
            items.add("- Select repository first -", "");
            return items;
        }
        try {
            DiversionApiClient client = new DiversionApiClient(credentialsId);
            List<DiversionBranch> branches = client.listBranches(repositoryId);
            Collections.sort(branches, (a, b) -> a.getName().compareToIgnoreCase(b.getName()));
            items.add("- Select branch -", "");
            for (DiversionBranch branch : branches) {
                items.add(branch.getName() + " (" + branch.getId() + ")", branch.getId());
            }
        }
        catch (Exception e) {
            String errorMsg = (errorPrefix != null ? errorPrefix : "Error") + ": " + e.getMessage();
            items.add(errorMsg, "");
        }
        return items;
    }
}

