/*
 * Decompiled with CFR 0.152.
 */
package io.superstudios.plugins.diversion;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.superstudios.plugins.diversion.DiversionApiClient;
import io.superstudios.plugins.diversion.DiversionBranch;
import io.superstudios.plugins.diversion.DiversionCommit;
import io.superstudios.plugins.diversion.DiversionFile;
import io.superstudios.plugins.diversion.DiversionSCMFile;
import java.io.IOException;
import java.util.List;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMRevision;

public class DiversionSCMFileSystem
extends SCMFileSystem {
    private final String repositoryId;
    private final String branchId;
    private final String credentialsId;
    private final String libraryPath;
    private final DiversionApiClient apiClient;
    private Long cachedLastModified;
    private String jobName;
    private String configuredScriptPath;

    public DiversionSCMFileSystem(String repositoryId, String branchId, String credentialsId, String libraryPath, SCMRevision revision) throws IOException, InterruptedException {
        super(revision);
        this.repositoryId = repositoryId;
        this.branchId = branchId;
        this.credentialsId = credentialsId;
        this.libraryPath = libraryPath;
        this.apiClient = new DiversionApiClient(credentialsId);
        this.cachedLastModified = null;
    }

    @NonNull
    public SCMFile getRoot() {
        String rootPath = this.libraryPath == null || this.libraryPath.isEmpty() ? "" : this.libraryPath;
        return new DiversionSCMFile(this, rootPath, this.apiClient, this.repositoryId, this.branchId);
    }

    public long lastModified() throws IOException, InterruptedException {
        if (this.cachedLastModified == null) {
            try {
                DiversionBranch branch = this.apiClient.getBranchDetails(this.repositoryId, this.branchId);
                String commitId = branch.getCommitId();
                if (commitId != null && !commitId.isEmpty()) {
                    DiversionCommit commit = this.apiClient.getCommitDetails(this.repositoryId, commitId);
                    this.cachedLastModified = commit.getCreatedTs() * 1000L;
                } else {
                    this.cachedLastModified = System.currentTimeMillis();
                }
            }
            catch (IOException | InterruptedException e) {
                this.cachedLastModified = System.currentTimeMillis();
            }
        }
        return this.cachedLastModified;
    }

    public void invalidateCache() {
        this.cachedLastModified = null;
    }

    public void close() throws IOException {
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getBranchId() {
        return this.branchId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public DiversionApiClient getApiClient() {
        return this.apiClient;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setConfiguredScriptPath(String configuredScriptPath) {
        this.configuredScriptPath = configuredScriptPath;
    }

    public String getConfiguredScriptPath() {
        return this.configuredScriptPath;
    }

    public String resolveScriptPath(String requestedPath) {
        if (this.configuredScriptPath != null && !this.configuredScriptPath.isEmpty() && (requestedPath.equals("Jenkinsfile") || requestedPath.equals("jenkinsfile"))) {
            return this.configuredScriptPath;
        }
        if (this.jobName != null && !this.jobName.isEmpty() && (requestedPath.equals("Jenkinsfile") || requestedPath.equals("jenkinsfile"))) {
            String[] expectedFileNames = new String[]{this.jobName + ".groovy", this.jobName, "Jenkinsfile"};
            try {
                List<DiversionFile> files = this.apiClient.getFileTree(this.repositoryId, this.branchId);
                for (String expectedFileName : expectedFileNames) {
                    for (DiversionFile file : files) {
                        String path = file.getPath();
                        if (path == null || !path.endsWith("/" + expectedFileName) && !path.equals(expectedFileName)) continue;
                        return path;
                    }
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        return null;
    }
}

