/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.customizable_header.logo;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import io.jenkins.plugins.customizable_header.logo.Logo;
import io.jenkins.plugins.customizable_header.logo.LogoDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.filters.StringInputStream;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SvgLogo
extends Logo {
    private static final Logger LOGGER = Logger.getLogger(SvgLogo.class.getName());
    private String logoPath;
    private boolean forceFile;
    private static final transient Cache<String, String> cache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    @DataBoundConstructor
    public SvgLogo(String logoPath) {
        this.logoPath = logoPath;
    }

    public SvgLogo(String logoPath, boolean forceFile) {
        this.logoPath = logoPath;
        this.forceFile = forceFile;
    }

    public String getContent() {
        return (String)cache.get((Object)this.logoPath, key -> this.getSymbol(this.logoPath));
    }

    public String getLogoPath() {
        return this.logoPath;
    }

    @CheckForNull
    private static String getFileLogoContent(String logoPath) {
        File file = new File(logoPath);
        if (!file.isAbsolute()) {
            file = new File(Jenkins.get().getRootDir(), logoPath);
        }
        if (!file.isFile()) {
            File finalFile = file;
            LOGGER.log(Level.FINE, () -> "No svg found at " + String.valueOf(finalFile));
            return null;
        }
        try {
            return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, ioe, () -> "Failed to read logo file");
            return null;
        }
    }

    @CheckForNull
    private String getSymbolContent(String logoPath) {
        String symbol = SvgLogo.getFileLogoContent(logoPath);
        if (symbol != null || this.forceFile) {
            return symbol;
        }
        return this.getUrlLogoContent(logoPath);
    }

    @CheckForNull
    private String getUrlLogoContent(String logoPath) {
        URI uri = URI.create(logoPath);
        if (!uri.isAbsolute()) {
            uri = URI.create(Jenkins.get().getRootUrl() + logoPath);
        }
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(5L)).build();
        HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().timeout(Duration.ofSeconds(5L)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                return response.body();
            }
            LOGGER.log(Level.FINE, "Failed to load logo from url " + String.valueOf(uri));
            return null;
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.WARNING, "Failed to read url with logo: " + String.valueOf(uri));
            return null;
        }
    }

    @CheckForNull
    private String getSymbol(String logoFilePath) {
        LOGGER.log(Level.FINER, "logo url {0}", logoFilePath);
        if (Util.fixEmptyAndTrim((String)logoFilePath) == null) {
            return null;
        }
        String content = this.getSymbolContent(logoFilePath);
        if (content == null) {
            return null;
        }
        if (!SvgLogo.validate(content)) {
            LOGGER.log(Level.FINE, () -> "Failed to validate logo from " + logoFilePath);
            return null;
        }
        content = content.replaceAll("(<title>)[^&]*(</title>)", "").replaceAll("(tooltip=\")[^&]*?(\")", "").replaceAll("(data-html-tooltip=\").*?(\")", "").replaceAll("<svg", "<svg aria-hidden=\"true\"").replaceAll("<svg", "<svg class=\"custom-header__svg\"").replaceAll("<svg", "<svg alt=\"[Jenkins]\"").replace("stroke:#000", "stroke:currentColor");
        LOGGER.log(Level.FINEST, "Logo {0}", content);
        return content;
    }

    private static boolean validate(String src) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse((InputStream)new StringInputStream(src));
            if (!"svg".equals(doc.getDocumentElement().getNodeName())) {
                LOGGER.log(Level.WARNING, "The given src for the svg doesn't seem to have 'svg' as it's root element");
                return false;
            }
            return true;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.log(Level.WARNING, e, () -> "The given src for the svg is not a valid xml document");
            return false;
        }
    }

    @Extension
    @Symbol(value={"svg"})
    public static class DescriptorImpl
    extends LogoDescriptor {
        @NonNull
        public String getDisplayName() {
            return "SVG Logo";
        }
    }
}

