/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.csp;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.InvisibleAction;
import hudson.model.RootAction;
import hudson.model.User;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.HttpResponses;
import io.jenkins.plugins.csp.ContentSecurityPolicyReceiver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Restricted(value={NoExternalUse.class})
@Symbol(value={"contentSecurityPolicyRootAction"})
public class ContentSecurityPolicyRootAction
extends InvisibleAction
implements RootAction {
    public static final String URL = "content-security-policy-reporting-endpoint";
    public static final Logger LOGGER = Logger.getLogger(ContentSecurityPolicyRootAction.class.getName());

    public String getUrlName() {
        return URL;
    }

    public HttpResponse doDynamic(StaplerRequest req) {
        User current = User.current();
        String restOfPath = StringUtils.removeStart((String)req.getRestOfPath(), (String)"/");
        int splitIdx = restOfPath.indexOf(58);
        if (splitIdx == -1) {
            LOGGER.log(Level.FINE, "Unexpected rest of path: " + restOfPath);
            return HttpResponses.ok();
        }
        ContentSecurityPolicyReceiver.Context context = new ContentSecurityPolicyReceiver.Context(restOfPath.substring(0, splitIdx), restOfPath.substring(splitIdx + 1));
        try (BufferedReader reader = req.getReader();){
            String report = IOUtils.toString((Reader)reader);
            LOGGER.log(Level.FINE, () -> context + " " + report);
            JSONObject jsonObject = JSONObject.fromObject((Object)report);
            for (ContentSecurityPolicyReceiver receiver : ExtensionList.lookup(ContentSecurityPolicyReceiver.class)) {
                try {
                    receiver.report(context, current, jsonObject);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex, () -> "Error reporting CSP to " + receiver);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e, () -> "Failed to read request body for /content-security-policy-reporting-endpoint/" + restOfPath);
        }
        return HttpResponses.ok();
    }

    @Extension
    public static class CrumbExclusionImpl
    extends CrumbExclusion {
        public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
            String pathInfo = request.getPathInfo();
            if (pathInfo != null && pathInfo.startsWith("/content-security-policy-reporting-endpoint/")) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return true;
            }
            return false;
        }
    }
}

