/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.csp;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.PageDecorator;
import io.jenkins.plugins.csp.ContentSecurityPolicyConfiguration;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;

@Extension
@Restricted(value={NoExternalUse.class})
@Symbol(value={"contentSecurityPolicyDecorator"})
public class ContentSecurityPolicyDecorator
extends PageDecorator {
    private static String getConfiguredRules() {
        String rule = ((ContentSecurityPolicyConfiguration)((Object)ExtensionList.lookupSingleton(ContentSecurityPolicyConfiguration.class))).getRule();
        if (rule == null) {
            return null;
        }
        return StringUtils.removeEnd((String)rule.trim(), (String)";");
    }

    public String getHeader() {
        boolean reportOnly = ((ContentSecurityPolicyConfiguration)((Object)ExtensionList.lookupSingleton(ContentSecurityPolicyConfiguration.class))).isReportOnly();
        return reportOnly ? "Content-Security-Policy-Report-Only" : "Content-Security-Policy";
    }

    public String getValue(String rootURL) {
        return ContentSecurityPolicyDecorator.getConfiguredRules() + "; report-uri " + rootURL + "/" + "content-security-policy-reporting-endpoint" + "/" + ContentSecurityPolicyDecorator.getContext();
    }

    private static String getContext() {
        List ancestors = Stapler.getCurrentRequest().getAncestors();
        if (ancestors.isEmpty()) {
            return "";
        }
        Ancestor nearest = (Ancestor)ancestors.get(ancestors.size() - 1);
        String nearestObjectName = nearest.getObject().getClass().getName();
        String restOfUrl = nearest.getRestOfUrl();
        return nearestObjectName + ":" + restOfUrl;
    }
}

