/*
 * Decompiled with CFR 0.152.
 */
package com.crowdstrike.plugins.crwds;

import com.crowdstrike.plugins.crwds.FalconContext;
import com.crowdstrike.plugins.crwds.freemarker.AssessmentData;
import com.crowdstrike.plugins.crwds.freemarker.CSFreeMarker;
import com.crowdstrike.plugins.crwds.freemarker.PolicyData;
import com.crowdstrike.plugins.crwds.freemarker.Reports;
import com.crowdstrike.plugins.crwds.utils.FileUtils;
import com.crowdstrike.plugins.crwds.utils.ProcessCodes;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;

public class ReportsGenerator {
    private final Integer BUILD_STATUS;

    public ReportsGenerator(Integer buildStatus) {
        this.BUILD_STATUS = buildStatus;
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Other Exceptions could happen that we need to handle here.")
    public String generateReport(FalconContext falconContext, AssessmentData assessmentData, PolicyData policyData, Boolean neverFail, String uniqueId, String artifactName) {
        falconContext.getLogger().println("[CRWDS::DEBUG] Build Status = " + this.BUILD_STATUS);
        if (this.BUILD_STATUS.intValue() != ProcessCodes.BUILD_SUCCESS.getCode() && this.BUILD_STATUS.intValue() != ProcessCodes.PREVENT_BUILD_DUE_TO_POLICY.getCode()) {
            return this.generateFailureReport();
        }
        String htmlString = "";
        try {
            Reports reports = Reports.getInstance();
            reports.checkAndResetForNewRunIfNecessary(falconContext.getRun());
            CSFreeMarker csFreeMarker = CSFreeMarker.getInstance();
            htmlString = csFreeMarker.processAssessmentTemplate(assessmentData, policyData, neverFail, uniqueId);
            reports.addToUniqueReportsList(falconContext.getRun(), new Reports.ReportData(htmlString, uniqueId, neverFail));
            htmlString = csFreeMarker.processPaginatedTemplate(reports.getReport(falconContext.getRun()));
        }
        catch (Exception e) {
            falconContext.getLogger().println("[CRWDS::DEBUG] " + ProcessCodes.HTML_GENERATION_FAILURE.getDescription() + "\n" + e.getMessage());
        }
        return htmlString;
    }

    public String generateFailureReport() {
        String failureTemplateName = "failure.html";
        File failureTemplateFile = new File(this.getClass().getResource("/reports/" + failureTemplateName).getFile());
        return FileUtils.fileRead(failureTemplateFile.getAbsolutePath());
    }
}

