/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.util.Generated;
import hudson.model.Api;
import hudson.model.Run;
import io.jenkins.plugins.coverage.metrics.model.ElementFormatter;
import io.jenkins.plugins.coverage.metrics.steps.CoverageViewModel;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;

@Generated(value={"assertj-assertions-generator"})
public class CoverageViewModelAssert
extends AbstractObjectAssert<CoverageViewModelAssert, CoverageViewModel> {
    public CoverageViewModelAssert(CoverageViewModel actual) {
        super((Object)actual, CoverageViewModelAssert.class);
    }

    @CheckReturnValue
    public static CoverageViewModelAssert assertThat(CoverageViewModel actual) {
        return new CoverageViewModelAssert(actual);
    }

    public CoverageViewModelAssert hasApi(Api api) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting api of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Api actualApi = ((CoverageViewModel)this.actual).getApi();
        if (!Objects.deepEquals(actualApi, api)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, api, actualApi});
        }
        return this;
    }

    public CoverageViewModelAssert hasCoverage() {
        this.isNotNull();
        if (!((CoverageViewModel)this.actual).hasCoverage()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel has coverage but does not have.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert doesNotHaveCoverage() {
        this.isNotNull();
        if (((CoverageViewModel)this.actual).hasCoverage()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel does not have coverage but has.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert hasCoverageMetrics(Metric ... coverageMetrics) {
        this.isNotNull();
        if (coverageMetrics == null) {
            this.failWithMessage("Expecting coverageMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getCoverageMetrics(), (Object[])coverageMetrics);
        return this;
    }

    public CoverageViewModelAssert hasCoverageMetrics(Collection<? extends Metric> coverageMetrics) {
        this.isNotNull();
        if (coverageMetrics == null) {
            this.failWithMessage("Expecting coverageMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getCoverageMetrics(), coverageMetrics.toArray());
        return this;
    }

    public CoverageViewModelAssert hasOnlyCoverageMetrics(Metric ... coverageMetrics) {
        this.isNotNull();
        if (coverageMetrics == null) {
            this.failWithMessage("Expecting coverageMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getCoverageMetrics(), (Object[])coverageMetrics);
        return this;
    }

    public CoverageViewModelAssert hasOnlyCoverageMetrics(Collection<? extends Metric> coverageMetrics) {
        this.isNotNull();
        if (coverageMetrics == null) {
            this.failWithMessage("Expecting coverageMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getCoverageMetrics(), coverageMetrics.toArray());
        return this;
    }

    public CoverageViewModelAssert doesNotHaveCoverageMetrics(Metric ... coverageMetrics) {
        this.isNotNull();
        if (coverageMetrics == null) {
            this.failWithMessage("Expecting coverageMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getCoverageMetrics(), (Object[])coverageMetrics);
        return this;
    }

    public CoverageViewModelAssert doesNotHaveCoverageMetrics(Collection<? extends Metric> coverageMetrics) {
        this.isNotNull();
        if (coverageMetrics == null) {
            this.failWithMessage("Expecting coverageMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getCoverageMetrics(), coverageMetrics.toArray());
        return this;
    }

    public CoverageViewModelAssert hasNoCoverageMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have coverageMetrics but had :\n  <%s>";
        if (((CoverageViewModel)this.actual).getCoverageMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageViewModel)this.actual).getCoverageMetrics()});
        }
        return this;
    }

    public CoverageViewModelAssert hasDisplayName(String displayName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting displayName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDisplayName = ((CoverageViewModel)this.actual).getDisplayName();
        if (!Objects.deepEquals(actualDisplayName, displayName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, displayName, actualDisplayName});
        }
        return this;
    }

    public CoverageViewModelAssert hasFormatter(ElementFormatter formatter) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting formatter of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ElementFormatter actualFormatter = ((CoverageViewModel)this.actual).getFormatter();
        if (!Objects.deepEquals(actualFormatter, formatter)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, formatter, actualFormatter});
        }
        return this;
    }

    public CoverageViewModelAssert hasId(String id) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualId = ((CoverageViewModel)this.actual).getId();
        if (!Objects.deepEquals(actualId, id)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, id, actualId});
        }
        return this;
    }

    public CoverageViewModelAssert hasIndirectCoverageChanges() {
        this.isNotNull();
        if (!((CoverageViewModel)this.actual).hasIndirectCoverageChanges()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel has indirect coverage changes but does not have.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert doesNotHaveIndirectCoverageChanges() {
        this.isNotNull();
        if (((CoverageViewModel)this.actual).hasIndirectCoverageChanges()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel does not have indirect coverage changes but has.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert hasJenkinsColorIDs(String ... jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getJenkinsColorIDs(), (Object[])jenkinsColorIDs);
        return this;
    }

    public CoverageViewModelAssert hasJenkinsColorIDs(Collection<? extends String> jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getJenkinsColorIDs(), jenkinsColorIDs.toArray());
        return this;
    }

    public CoverageViewModelAssert hasOnlyJenkinsColorIDs(String ... jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getJenkinsColorIDs(), (Object[])jenkinsColorIDs);
        return this;
    }

    public CoverageViewModelAssert hasOnlyJenkinsColorIDs(Collection<? extends String> jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getJenkinsColorIDs(), jenkinsColorIDs.toArray());
        return this;
    }

    public CoverageViewModelAssert doesNotHaveJenkinsColorIDs(String ... jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getJenkinsColorIDs(), (Object[])jenkinsColorIDs);
        return this;
    }

    public CoverageViewModelAssert doesNotHaveJenkinsColorIDs(Collection<? extends String> jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getJenkinsColorIDs(), jenkinsColorIDs.toArray());
        return this;
    }

    public CoverageViewModelAssert hasNoJenkinsColorIDs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have jenkinsColorIDs but had :\n  <%s>";
        if (((CoverageViewModel)this.actual).getJenkinsColorIDs().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageViewModel)this.actual).getJenkinsColorIDs()});
        }
        return this;
    }

    public CoverageViewModelAssert hasMetrics() {
        this.isNotNull();
        if (!((CoverageViewModel)this.actual).hasMetrics()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel has metrics but does not have.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert doesNotHaveMetrics() {
        this.isNotNull();
        if (((CoverageViewModel)this.actual).hasMetrics()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel does not have metrics but has.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert hasModifiedLinesCoverage() {
        this.isNotNull();
        if (!((CoverageViewModel)this.actual).hasModifiedLinesCoverage()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel has modified lines coverage but does not have.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert doesNotHaveModifiedLinesCoverage() {
        this.isNotNull();
        if (((CoverageViewModel)this.actual).hasModifiedLinesCoverage()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel does not have modified lines coverage but has.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert hasNode(Node node) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting node of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Node actualNode = ((CoverageViewModel)this.actual).getNode();
        if (!Objects.deepEquals(actualNode, node)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, node, actualNode});
        }
        return this;
    }

    public CoverageViewModelAssert hasOverview(CoverageViewModel.CoverageOverview overview) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting overview of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageViewModel.CoverageOverview actualOverview = ((CoverageViewModel)this.actual).getOverview();
        if (!Objects.deepEquals(actualOverview, overview)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, overview, actualOverview});
        }
        return this;
    }

    public CoverageViewModelAssert hasOwner(Run owner) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting owner of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Run actualOwner = ((CoverageViewModel)this.actual).getOwner();
        if (!Objects.deepEquals(actualOwner, owner)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, owner, actualOwner});
        }
        return this;
    }

    public CoverageViewModelAssert hasSoftwareMetrics(Metric ... softwareMetrics) {
        this.isNotNull();
        if (softwareMetrics == null) {
            this.failWithMessage("Expecting softwareMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getSoftwareMetrics(), (Object[])softwareMetrics);
        return this;
    }

    public CoverageViewModelAssert hasSoftwareMetrics(Collection<? extends Metric> softwareMetrics) {
        this.isNotNull();
        if (softwareMetrics == null) {
            this.failWithMessage("Expecting softwareMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getSoftwareMetrics(), softwareMetrics.toArray());
        return this;
    }

    public CoverageViewModelAssert hasOnlySoftwareMetrics(Metric ... softwareMetrics) {
        this.isNotNull();
        if (softwareMetrics == null) {
            this.failWithMessage("Expecting softwareMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getSoftwareMetrics(), (Object[])softwareMetrics);
        return this;
    }

    public CoverageViewModelAssert hasOnlySoftwareMetrics(Collection<? extends Metric> softwareMetrics) {
        this.isNotNull();
        if (softwareMetrics == null) {
            this.failWithMessage("Expecting softwareMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getSoftwareMetrics(), softwareMetrics.toArray());
        return this;
    }

    public CoverageViewModelAssert doesNotHaveSoftwareMetrics(Metric ... softwareMetrics) {
        this.isNotNull();
        if (softwareMetrics == null) {
            this.failWithMessage("Expecting softwareMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getSoftwareMetrics(), (Object[])softwareMetrics);
        return this;
    }

    public CoverageViewModelAssert doesNotHaveSoftwareMetrics(Collection<? extends Metric> softwareMetrics) {
        this.isNotNull();
        if (softwareMetrics == null) {
            this.failWithMessage("Expecting softwareMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getSoftwareMetrics(), softwareMetrics.toArray());
        return this;
    }

    public CoverageViewModelAssert hasNoSoftwareMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have softwareMetrics but had :\n  <%s>";
        if (((CoverageViewModel)this.actual).getSoftwareMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageViewModel)this.actual).getSoftwareMetrics()});
        }
        return this;
    }

    public CoverageViewModelAssert hasSourceCode() {
        this.isNotNull();
        if (!((CoverageViewModel)this.actual).hasSourceCode()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel has source code but does not have.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert doesNotHaveSourceCode() {
        this.isNotNull();
        if (((CoverageViewModel)this.actual).hasSourceCode()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel does not have source code but has.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert hasTreeMetrics(Metric ... treeMetrics) {
        this.isNotNull();
        if (treeMetrics == null) {
            this.failWithMessage("Expecting treeMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getTreeMetrics(), (Object[])treeMetrics);
        return this;
    }

    public CoverageViewModelAssert hasTreeMetrics(Collection<? extends Metric> treeMetrics) {
        this.isNotNull();
        if (treeMetrics == null) {
            this.failWithMessage("Expecting treeMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getTreeMetrics(), treeMetrics.toArray());
        return this;
    }

    public CoverageViewModelAssert hasOnlyTreeMetrics(Metric ... treeMetrics) {
        this.isNotNull();
        if (treeMetrics == null) {
            this.failWithMessage("Expecting treeMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getTreeMetrics(), (Object[])treeMetrics);
        return this;
    }

    public CoverageViewModelAssert hasOnlyTreeMetrics(Collection<? extends Metric> treeMetrics) {
        this.isNotNull();
        if (treeMetrics == null) {
            this.failWithMessage("Expecting treeMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getTreeMetrics(), treeMetrics.toArray());
        return this;
    }

    public CoverageViewModelAssert doesNotHaveTreeMetrics(Metric ... treeMetrics) {
        this.isNotNull();
        if (treeMetrics == null) {
            this.failWithMessage("Expecting treeMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getTreeMetrics(), (Object[])treeMetrics);
        return this;
    }

    public CoverageViewModelAssert doesNotHaveTreeMetrics(Collection<? extends Metric> treeMetrics) {
        this.isNotNull();
        if (treeMetrics == null) {
            this.failWithMessage("Expecting treeMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getTreeMetrics(), treeMetrics.toArray());
        return this;
    }

    public CoverageViewModelAssert hasNoTreeMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have treeMetrics but had :\n  <%s>";
        if (((CoverageViewModel)this.actual).getTreeMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageViewModel)this.actual).getTreeMetrics()});
        }
        return this;
    }
}

