/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.view.calendar.util;

import hudson.model.Descriptor;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;

@Restricted(value={NoExternalUse.class})
public final class ValidationUtil {
    private ValidationUtil() {
    }

    public static void validateEnum(StaplerRequest2 req, String formField, Class<? extends Enum> enumClass) throws Descriptor.FormException {
        Enum[] enumConstants;
        for (Enum enumConstant : enumConstants = enumClass.getEnumConstants()) {
            if (!enumConstant.name().equals(req.getParameter(formField))) continue;
            return;
        }
        throw new Descriptor.FormException(formField + " must be one of " + String.valueOf(Arrays.asList(enumConstants)), formField);
    }

    public static void validateInList(StaplerRequest2 req, String formField, List<String> possibleValues) throws Descriptor.FormException {
        if (!possibleValues.contains(req.getParameter(formField))) {
            throw new Descriptor.FormException(formField + " must be one of " + String.valueOf(possibleValues), formField);
        }
    }

    public static void validatePattern(StaplerRequest2 req, String formField, Pattern pattern) throws Descriptor.FormException {
        String value = req.getParameter(formField);
        if (value == null || !pattern.matcher(value).matches()) {
            throw new Descriptor.FormException(formField + " must match " + String.valueOf(pattern), formField);
        }
    }

    public static void validateRange(StaplerRequest2 req, String formField, int min, int max) throws Descriptor.FormException {
        int value = Integer.parseInt(req.getParameter("weekSettingsFirstDay"));
        if (value < min || value > max) {
            throw new Descriptor.FormException(formField + " must be: " + min + " <= " + formField + " <= " + max, formField);
        }
    }
}

