// CHECKSTYLE:OFF

package com.ca.devtest.jenkins.plugin;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code DevTestPlugin.responseStatus}: {@code Status code is
     * {0}
     * Response body from DevTest is: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Status code is {0}
     *     Response body from DevTest is: {1}}
     */
    public static String DevTestPlugin_responseStatus(Object arg0, Object arg1) {
        return holder.format("DevTestPlugin.responseStatus", arg0, arg1);
    }

    /**
     * Key {@code DevTestPlugin.responseStatus}: {@code Status code is
     * {0}
     * Response body from DevTest is: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Status code is {0}
     *     Response body from DevTest is: {1}}
     */
    public static Localizable _DevTestPlugin_responseStatus(Object arg0, Object arg1) {
        return new Localizable(holder, "DevTestPlugin.responseStatus", arg0, arg1);
    }

    /**
     * Key {@code DevTestDeployTest.status}: {@code Test/Suite run finished
     * with status: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test/Suite run finished with status: {0}}
     */
    public static String DevTestDeployTest_status(Object arg0) {
        return holder.format("DevTestDeployTest.status", arg0);
    }

    /**
     * Key {@code DevTestDeployTest.status}: {@code Test/Suite run finished
     * with status: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test/Suite run finished with status: {0}}
     */
    public static Localizable _DevTestDeployTest_status(Object arg0) {
        return new Localizable(holder, "DevTestDeployTest.status", arg0);
    }

    /**
     * Key {@code DevTestStopVs.stopping}: {@code Stopping virtual service:
     * {0} on VSE: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stopping virtual service: {0} on VSE: {1}}
     */
    public static String DevTestStopVs_stopping(Object arg0, Object arg1) {
        return holder.format("DevTestStopVs.stopping", arg0, arg1);
    }

    /**
     * Key {@code DevTestStopVs.stopping}: {@code Stopping virtual service:
     * {0} on VSE: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stopping virtual service: {0} on VSE: {1}}
     */
    public static Localizable _DevTestStopVs_stopping(Object arg0, Object arg1) {
        return new Localizable(holder, "DevTestStopVs.stopping", arg0, arg1);
    }

    /**
     * Key {@code Utils.NoFilesForWildcard}: {@code There are no files
     * matching wildcard: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code There are no files matching wildcard: {0}}
     */
    public static String Utils_NoFilesForWildcard(Object arg0) {
        return holder.format("Utils.NoFilesForWildcard", arg0);
    }

    /**
     * Key {@code Utils.NoFilesForWildcard}: {@code There are no files
     * matching wildcard: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code There are no files matching wildcard: {0}}
     */
    public static Localizable _Utils_NoFilesForWildcard(Object arg0) {
        return new Localizable(holder, "Utils.NoFilesForWildcard", arg0);
    }

    /**
     * Key {@code DevTestStopVs.error}: {@code Stopping of the virtual
     * service {0} failed!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stopping of the virtual service {0} failed!}
     */
    public static String DevTestStopVs_error(Object arg0) {
        return holder.format("DevTestStopVs.error", arg0);
    }

    /**
     * Key {@code DevTestStopVs.error}: {@code Stopping of the virtual
     * service {0} failed!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stopping of the virtual service {0} failed!}
     */
    public static Localizable _DevTestStopVs_error(Object arg0) {
        return new Localizable(holder, "DevTestStopVs.error", arg0);
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.DescriptorImpl.DisplayName}:
     * {@code CA Service Virtualization - Create And Deploy Virtual Service}.
     * 
     * @return
     *     {@code CA Service Virtualization - Create And Deploy Virtual Service}
     */
    public static String DevTestCreateAndDeployVs_DescriptorImpl_DisplayName() {
        return holder.format("DevTestCreateAndDeployVs.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.DescriptorImpl.DisplayName}:
     * {@code CA Service Virtualization - Create And Deploy Virtual Service}.
     * 
     * @return
     *     {@code CA Service Virtualization - Create And Deploy Virtual Service}
     */
    public static Localizable _DevTestCreateAndDeployVs_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "DevTestCreateAndDeployVs.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestReport.Duration}: {@code Duration}.
     * 
     * @return
     *     {@code Duration}
     */
    public static String DevTestReport_Duration() {
        return holder.format("DevTestReport.Duration");
    }

    /**
     * Key {@code DevTestReport.Duration}: {@code Duration}.
     * 
     * @return
     *     {@code Duration}
     */
    public static Localizable _DevTestReport_Duration() {
        return new Localizable(holder, "DevTestReport.Duration");
    }

    /**
     * Key {@code DevTestReport.SuiteName}: {@code Suite name}.
     * 
     * @return
     *     {@code Suite name}
     */
    public static String DevTestReport_SuiteName() {
        return holder.format("DevTestReport.SuiteName");
    }

    /**
     * Key {@code DevTestReport.SuiteName}: {@code Suite name}.
     * 
     * @return
     *     {@code Suite name}
     */
    public static Localizable _DevTestReport_SuiteName() {
        return new Localizable(holder, "DevTestReport.SuiteName");
    }

    /**
     * Key {@code DevTestTestPublisher.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization Report Publisher}.
     * 
     * @return
     *     {@code CA Service Virtualization Report Publisher}
     */
    public static String DevTestTestPublisher_DescriptorImpl_DisplayName() {
        return holder.format("DevTestTestPublisher.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestTestPublisher.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization Report Publisher}.
     * 
     * @return
     *     {@code CA Service Virtualization Report Publisher}
     */
    public static Localizable _DevTestTestPublisher_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "DevTestTestPublisher.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code Utils.NullWildcardOrDir}: {@code Cannot process workspace
     * {0} with wildcard {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot process workspace {0} with wildcard {1}}
     */
    public static String Utils_NullWildcardOrDir(Object arg0, Object arg1) {
        return holder.format("Utils.NullWildcardOrDir", arg0, arg1);
    }

    /**
     * Key {@code Utils.NullWildcardOrDir}: {@code Cannot process workspace
     * {0} with wildcard {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot process workspace {0} with wildcard {1}}
     */
    public static Localizable _Utils_NullWildcardOrDir(Object arg0, Object arg1) {
        return new Localizable(holder, "Utils.NullWildcardOrDir", arg0, arg1);
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.createSuccess}: {@code Virtual
     * Service has been created successfully}.
     * 
     * @return
     *     {@code Virtual Service has been created successfully}
     */
    public static String DevTestCreateAndDeployVs_createSuccess() {
        return holder.format("DevTestCreateAndDeployVs.createSuccess");
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.createSuccess}: {@code Virtual
     * Service has been created successfully}.
     * 
     * @return
     *     {@code Virtual Service has been created successfully}
     */
    public static Localizable _DevTestCreateAndDeployVs_createSuccess() {
        return new Localizable(holder, "DevTestCreateAndDeployVs.createSuccess");
    }

    /**
     * Key {@code DevTestParser.StartSuite}: {@code Parsing suites}.
     * 
     * @return
     *     {@code Parsing suites}
     */
    public static String DevTestParser_StartSuite() {
        return holder.format("DevTestParser.StartSuite");
    }

    /**
     * Key {@code DevTestParser.StartSuite}: {@code Parsing suites}.
     * 
     * @return
     *     {@code Parsing suites}
     */
    public static Localizable _DevTestParser_StartSuite() {
        return new Localizable(holder, "DevTestParser.StartSuite");
    }

    /**
     * Key {@code DevTestDeployTest.error}: {@code Deployment of the
     * test/testsuite failed!}.
     * 
     * @return
     *     {@code Deployment of the test/testsuite failed!}
     */
    public static String DevTestDeployTest_error() {
        return holder.format("DevTestDeployTest.error");
    }

    /**
     * Key {@code DevTestDeployTest.error}: {@code Deployment of the
     * test/testsuite failed!}.
     * 
     * @return
     *     {@code Deployment of the test/testsuite failed!}
     */
    public static Localizable _DevTestDeployTest_error() {
        return new Localizable(holder, "DevTestDeployTest.error");
    }

    /**
     * Key {@code DevTestStartVs.error}: {@code Starting of the virtual
     * service {0} failed!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Starting of the virtual service {0} failed!}
     */
    public static String DevTestStartVs_error(Object arg0) {
        return holder.format("DevTestStartVs.error", arg0);
    }

    /**
     * Key {@code DevTestStartVs.error}: {@code Starting of the virtual
     * service {0} failed!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Starting of the virtual service {0} failed!}
     */
    public static Localizable _DevTestStartVs_error(Object arg0) {
        return new Localizable(holder, "DevTestStartVs.error", arg0);
    }

    /**
     * Key {@code DevTestDeployTest.Suite}: {@code Suite}.
     * 
     * @return
     *     {@code Suite}
     */
    public static String DevTestDeployTest_Suite() {
        return holder.format("DevTestDeployTest.Suite");
    }

    /**
     * Key {@code DevTestDeployTest.Suite}: {@code Suite}.
     * 
     * @return
     *     {@code Suite}
     */
    public static Localizable _DevTestDeployTest_Suite() {
        return new Localizable(holder, "DevTestDeployTest.Suite");
    }

    /**
     * Key {@code DevTestReport.PassedCycles}: {@code Passed cycles}.
     * 
     * @return
     *     {@code Passed cycles}
     */
    public static String DevTestReport_PassedCycles() {
        return holder.format("DevTestReport.PassedCycles");
    }

    /**
     * Key {@code DevTestReport.PassedCycles}: {@code Passed cycles}.
     * 
     * @return
     *     {@code Passed cycles}
     */
    public static Localizable _DevTestReport_PassedCycles() {
        return new Localizable(holder, "DevTestReport.PassedCycles");
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.createAndDeployError}: {@code
     * Creation and deployment of virtual service failed!}.
     * 
     * @return
     *     {@code Creation and deployment of virtual service failed!}
     */
    public static String DevTestCreateAndDeployVs_createAndDeployError() {
        return holder.format("DevTestCreateAndDeployVs.createAndDeployError");
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.createAndDeployError}: {@code
     * Creation and deployment of virtual service failed!}.
     * 
     * @return
     *     {@code Creation and deployment of virtual service failed!}
     */
    public static Localizable _DevTestCreateAndDeployVs_createAndDeployError() {
        return new Localizable(holder, "DevTestCreateAndDeployVs.createAndDeployError");
    }

    /**
     * Key {@code DevTestDeployVs.deploying}: {@code Deploying MAR file:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deploying MAR file: {0}}
     */
    public static String DevTestDeployVs_deploying(Object arg0) {
        return holder.format("DevTestDeployVs.deploying", arg0);
    }

    /**
     * Key {@code DevTestDeployVs.deploying}: {@code Deploying MAR file:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deploying MAR file: {0}}
     */
    public static Localizable _DevTestDeployVs_deploying(Object arg0) {
        return new Localizable(holder, "DevTestDeployVs.deploying", arg0);
    }

    /**
     * Key {@code DevTestParser.FieldNotExists}: {@code Field {0} not exists
     * or cannot be parsed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Field {0} not exists or cannot be parsed}
     */
    public static String DevTestParser_FieldNotExists(Object arg0) {
        return holder.format("DevTestParser.FieldNotExists", arg0);
    }

    /**
     * Key {@code DevTestParser.FieldNotExists}: {@code Field {0} not exists
     * or cannot be parsed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Field {0} not exists or cannot be parsed}
     */
    public static Localizable _DevTestParser_FieldNotExists(Object arg0) {
        return new Localizable(holder, "DevTestParser.FieldNotExists", arg0);
    }

    /**
     * Key {@code DevTestReport.FailedCycles}: {@code Failed cycles}.
     * 
     * @return
     *     {@code Failed cycles}
     */
    public static String DevTestReport_FailedCycles() {
        return holder.format("DevTestReport.FailedCycles");
    }

    /**
     * Key {@code DevTestReport.FailedCycles}: {@code Failed cycles}.
     * 
     * @return
     *     {@code Failed cycles}
     */
    public static Localizable _DevTestReport_FailedCycles() {
        return new Localizable(holder, "DevTestReport.FailedCycles");
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.createError}: {@code Creation of
     * virtual service failed!}.
     * 
     * @return
     *     {@code Creation of virtual service failed!}
     */
    public static String DevTestCreateAndDeployVs_createError() {
        return holder.format("DevTestCreateAndDeployVs.createError");
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.createError}: {@code Creation of
     * virtual service failed!}.
     * 
     * @return
     *     {@code Creation of virtual service failed!}
     */
    public static Localizable _DevTestCreateAndDeployVs_createError() {
        return new Localizable(holder, "DevTestCreateAndDeployVs.createError");
    }

    /**
     * Key {@code DevTestStartTest.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization - Start Test}.
     * 
     * @return
     *     {@code CA Service Virtualization - Start Test}
     */
    public static String DevTestStartTest_DescriptorImpl_DisplayName() {
        return holder.format("DevTestStartTest.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestStartTest.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization - Start Test}.
     * 
     * @return
     *     {@code CA Service Virtualization - Start Test}
     */
    public static Localizable _DevTestStartTest_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "DevTestStartTest.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestParser.CycleNotParsed}: {@code Failed to parse
     * cycle}.
     * 
     * @return
     *     {@code Failed to parse cycle}
     */
    public static String DevTestParser_CycleNotParsed() {
        return holder.format("DevTestParser.CycleNotParsed");
    }

    /**
     * Key {@code DevTestParser.CycleNotParsed}: {@code Failed to parse
     * cycle}.
     * 
     * @return
     *     {@code Failed to parse cycle}
     */
    public static Localizable _DevTestParser_CycleNotParsed() {
        return new Localizable(holder, "DevTestParser.CycleNotParsed");
    }

    /**
     * Key {@code DevTestParser.SuiteNotParsed}: {@code Failed to parse
     * suite}.
     * 
     * @return
     *     {@code Failed to parse suite}
     */
    public static String DevTestParser_SuiteNotParsed() {
        return holder.format("DevTestParser.SuiteNotParsed");
    }

    /**
     * Key {@code DevTestParser.SuiteNotParsed}: {@code Failed to parse
     * suite}.
     * 
     * @return
     *     {@code Failed to parse suite}
     */
    public static Localizable _DevTestParser_SuiteNotParsed() {
        return new Localizable(holder, "DevTestParser.SuiteNotParsed");
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.DescriptorImpl.MissingConfig}:
     * {@code Configuration JSON cannot be empty}.
     * 
     * @return
     *     {@code Configuration JSON cannot be empty}
     */
    public static String DevTestCreateAndDeployVs_DescriptorImpl_MissingConfig() {
        return holder.format("DevTestCreateAndDeployVs.DescriptorImpl.MissingConfig");
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.DescriptorImpl.MissingConfig}:
     * {@code Configuration JSON cannot be empty}.
     * 
     * @return
     *     {@code Configuration JSON cannot be empty}
     */
    public static Localizable _DevTestCreateAndDeployVs_DescriptorImpl_MissingConfig() {
        return new Localizable(holder, "DevTestCreateAndDeployVs.DescriptorImpl.MissingConfig");
    }

    /**
     * Key {@code DevTestReport.Title}: {@code CA Service Virtualization
     * report}.
     * 
     * @return
     *     {@code CA Service Virtualization report}
     */
    public static String DevTestReport_Title() {
        return holder.format("DevTestReport.Title");
    }

    /**
     * Key {@code DevTestReport.Title}: {@code CA Service Virtualization
     * report}.
     * 
     * @return
     *     {@code CA Service Virtualization report}
     */
    public static Localizable _DevTestReport_Title() {
        return new Localizable(holder, "DevTestReport.Title");
    }

    /**
     * Key {@code DevTestPlugin.responseBody}: {@code Response body:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Response body:
     *     {0}}
     */
    public static String DevTestPlugin_responseBody(Object arg0) {
        return holder.format("DevTestPlugin.responseBody", arg0);
    }

    /**
     * Key {@code DevTestPlugin.responseBody}: {@code Response body:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Response body:
     *     {0}}
     */
    public static Localizable _DevTestPlugin_responseBody(Object arg0) {
        return new Localizable(holder, "DevTestPlugin.responseBody", arg0);
    }

    /**
     * Key {@code DevTestDeployTest.success}: {@code Test/Suite from MAR file
     * was successfully deployed, id = {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test/Suite from MAR file was successfully deployed, id = {0}}
     */
    public static String DevTestDeployTest_success(Object arg0) {
        return holder.format("DevTestDeployTest.success", arg0);
    }

    /**
     * Key {@code DevTestDeployTest.success}: {@code Test/Suite from MAR file
     * was successfully deployed, id = {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test/Suite from MAR file was successfully deployed, id = {0}}
     */
    public static Localizable _DevTestDeployTest_success(Object arg0) {
        return new Localizable(holder, "DevTestDeployTest.success", arg0);
    }

    /**
     * Key {@code DevTestPlugin.clientFailed}: {@code HTTP client failed to
     * do request: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code HTTP client failed to do request: {0}}
     */
    public static String DevTestPlugin_clientFailed(Object arg0) {
        return holder.format("DevTestPlugin.clientFailed", arg0);
    }

    /**
     * Key {@code DevTestPlugin.clientFailed}: {@code HTTP client failed to
     * do request: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code HTTP client failed to do request: {0}}
     */
    public static Localizable _DevTestPlugin_clientFailed(Object arg0) {
        return new Localizable(holder, "DevTestPlugin.clientFailed", arg0);
    }

    /**
     * Key {@code DevTestStopVs.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization - Stop Virtual Service}.
     * 
     * @return
     *     {@code CA Service Virtualization - Stop Virtual Service}
     */
    public static String DevTestStopVs_DescriptorImpl_DisplayName() {
        return holder.format("DevTestStopVs.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestStopVs.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization - Stop Virtual Service}.
     * 
     * @return
     *     {@code CA Service Virtualization - Stop Virtual Service}
     */
    public static Localizable _DevTestStopVs_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "DevTestStopVs.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestPlugin.fileEx}: {@code Cannot located file with
     * relative path {0} in workspace of job}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot located file with relative path {0} in workspace of job}
     */
    public static String DevTestPlugin_fileEx(Object arg0) {
        return holder.format("DevTestPlugin.fileEx", arg0);
    }

    /**
     * Key {@code DevTestPlugin.fileEx}: {@code Cannot located file with
     * relative path {0} in workspace of job}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot located file with relative path {0} in workspace of job}
     */
    public static Localizable _DevTestPlugin_fileEx(Object arg0) {
        return new Localizable(holder, "DevTestPlugin.fileEx", arg0);
    }

    /**
     * Key {@code DevTestReport.Failures}: {@code failures}.
     * 
     * @return
     *     {@code failures}
     */
    public static String DevTestReport_Failures() {
        return holder.format("DevTestReport.Failures");
    }

    /**
     * Key {@code DevTestReport.Failures}: {@code failures}.
     * 
     * @return
     *     {@code failures}
     */
    public static Localizable _DevTestReport_Failures() {
        return new Localizable(holder, "DevTestReport.Failures");
    }

    /**
     * Key {@code DevTestReport.FailedTests}: {@code Failed Tests}.
     * 
     * @return
     *     {@code Failed Tests}
     */
    public static String DevTestReport_FailedTests() {
        return holder.format("DevTestReport.FailedTests");
    }

    /**
     * Key {@code DevTestReport.FailedTests}: {@code Failed Tests}.
     * 
     * @return
     *     {@code Failed Tests}
     */
    public static Localizable _DevTestReport_FailedTests() {
        return new Localizable(holder, "DevTestReport.FailedTests");
    }

    /**
     * Key {@code DevTestPlugin.DescriptorImpl.MissingVs}: {@code Names of
     * virtual services cannot be empty}.
     * 
     * @return
     *     {@code Names of virtual services cannot be empty}
     */
    public static String DevTestPlugin_DescriptorImpl_MissingVs() {
        return holder.format("DevTestPlugin.DescriptorImpl.MissingVs");
    }

    /**
     * Key {@code DevTestPlugin.DescriptorImpl.MissingVs}: {@code Names of
     * virtual services cannot be empty}.
     * 
     * @return
     *     {@code Names of virtual services cannot be empty}
     */
    public static Localizable _DevTestPlugin_DescriptorImpl_MissingVs() {
        return new Localizable(holder, "DevTestPlugin.DescriptorImpl.MissingVs");
    }

    /**
     * Key {@code DevTestUndeployVs.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization - Undeploy  Virtual Service}.
     * 
     * @return
     *     {@code CA Service Virtualization - Undeploy  Virtual Service}
     */
    public static String DevTestUndeployVs_DescriptorImpl_DisplayName() {
        return holder.format("DevTestUndeployVs.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestUndeployVs.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization - Undeploy  Virtual Service}.
     * 
     * @return
     *     {@code CA Service Virtualization - Undeploy  Virtual Service}
     */
    public static Localizable _DevTestUndeployVs_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "DevTestUndeployVs.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestDeployVs.success}: {@code Virtual service from MAR
     * file: {0} was successfully deployed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Virtual service from MAR file: {0} was successfully deployed}
     */
    public static String DevTestDeployVs_success(Object arg0) {
        return holder.format("DevTestDeployVs.success", arg0);
    }

    /**
     * Key {@code DevTestDeployVs.success}: {@code Virtual service from MAR
     * file: {0} was successfully deployed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Virtual service from MAR file: {0} was successfully deployed}
     */
    public static Localizable _DevTestDeployVs_success(Object arg0) {
        return new Localizable(holder, "DevTestDeployVs.success", arg0);
    }

    /**
     * Key {@code DevTestReport.PassedTests}: {@code Passed Tests}.
     * 
     * @return
     *     {@code Passed Tests}
     */
    public static String DevTestReport_PassedTests() {
        return holder.format("DevTestReport.PassedTests");
    }

    /**
     * Key {@code DevTestReport.PassedTests}: {@code Passed Tests}.
     * 
     * @return
     *     {@code Passed Tests}
     */
    public static Localizable _DevTestReport_PassedTests() {
        return new Localizable(holder, "DevTestReport.PassedTests");
    }

    /**
     * Key {@code DevTestReport.NoResults}: {@code No test results}.
     * 
     * @return
     *     {@code No test results}
     */
    public static String DevTestReport_NoResults() {
        return holder.format("DevTestReport.NoResults");
    }

    /**
     * Key {@code DevTestReport.NoResults}: {@code No test results}.
     * 
     * @return
     *     {@code No test results}
     */
    public static Localizable _DevTestReport_NoResults() {
        return new Localizable(holder, "DevTestReport.NoResults");
    }

    /**
     * Key {@code DevTestPlugin.invalidCredentials}: {@code Authorization
     * failed: Invalid credentials provided!}.
     * 
     * @return
     *     {@code Authorization failed: Invalid credentials provided!}
     */
    public static String DevTestPlugin_invalidCredentials() {
        return holder.format("DevTestPlugin.invalidCredentials");
    }

    /**
     * Key {@code DevTestPlugin.invalidCredentials}: {@code Authorization
     * failed: Invalid credentials provided!}.
     * 
     * @return
     *     {@code Authorization failed: Invalid credentials provided!}
     */
    public static Localizable _DevTestPlugin_invalidCredentials() {
        return new Localizable(holder, "DevTestPlugin.invalidCredentials");
    }

    /**
     * Key {@code DevTestReport.Cycle}: {@code Cycle}.
     * 
     * @return
     *     {@code Cycle}
     */
    public static String DevTestReport_Cycle() {
        return holder.format("DevTestReport.Cycle");
    }

    /**
     * Key {@code DevTestReport.Cycle}: {@code Cycle}.
     * 
     * @return
     *     {@code Cycle}
     */
    public static Localizable _DevTestReport_Cycle() {
        return new Localizable(holder, "DevTestReport.Cycle");
    }

    /**
     * Key {@code DevTestUndeployVs.error}: {@code Undeploying of the virtual
     * service {0} failed!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Undeploying of the virtual service {0} failed!}
     */
    public static String DevTestUndeployVs_error(Object arg0) {
        return holder.format("DevTestUndeployVs.error", arg0);
    }

    /**
     * Key {@code DevTestUndeployVs.error}: {@code Undeploying of the virtual
     * service {0} failed!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Undeploying of the virtual service {0} failed!}
     */
    public static Localizable _DevTestUndeployVs_error(Object arg0) {
        return new Localizable(holder, "DevTestUndeployVs.error", arg0);
    }

    /**
     * Key {@code DevTestStartVs.starting}: {@code Starting virtual service:
     * {0} on VSE: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Starting virtual service: {0} on VSE: {1}}
     */
    public static String DevTestStartVs_starting(Object arg0, Object arg1) {
        return holder.format("DevTestStartVs.starting", arg0, arg1);
    }

    /**
     * Key {@code DevTestStartVs.starting}: {@code Starting virtual service:
     * {0} on VSE: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Starting virtual service: {0} on VSE: {1}}
     */
    public static Localizable _DevTestStartVs_starting(Object arg0, Object arg1) {
        return new Localizable(holder, "DevTestStartVs.starting", arg0, arg1);
    }

    /**
     * Key {@code DevTestDeployTest.statusDetails}: {@code Test/Suite run
     * details: {0} test(s) executed ({1} test(s) passed, {2} test(s)
     * failed)}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test/Suite run details: {0} test(s) executed ({1} test(s)
     *     passed, {2} test(s) failed)}
     */
    public static String DevTestDeployTest_statusDetails(Object arg0, Object arg1, Object arg2) {
        return holder.format("DevTestDeployTest.statusDetails", arg0, arg1, arg2);
    }

    /**
     * Key {@code DevTestDeployTest.statusDetails}: {@code Test/Suite run
     * details: {0} test(s) executed ({1} test(s) passed, {2} test(s)
     * failed)}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test/Suite run details: {0} test(s) executed ({1} test(s)
     *     passed, {2} test(s) failed)}
     */
    public static Localizable _DevTestDeployTest_statusDetails(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "DevTestDeployTest.statusDetails", arg0, arg1, arg2);
    }

    /**
     * Key {@code DevTestStartTest.Suite}: {@code Suite}.
     * 
     * @return
     *     {@code Suite}
     */
    public static String DevTestStartTest_Suite() {
        return holder.format("DevTestStartTest.Suite");
    }

    /**
     * Key {@code DevTestStartTest.Suite}: {@code Suite}.
     * 
     * @return
     *     {@code Suite}
     */
    public static Localizable _DevTestStartTest_Suite() {
        return new Localizable(holder, "DevTestStartTest.Suite");
    }

    /**
     * Key {@code DevTestDeployVs.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization - Deploy Virtual Service}.
     * 
     * @return
     *     {@code CA Service Virtualization - Deploy Virtual Service}
     */
    public static String DevTestDeployVs_DescriptorImpl_DisplayName() {
        return holder.format("DevTestDeployVs.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestDeployVs.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization - Deploy Virtual Service}.
     * 
     * @return
     *     {@code CA Service Virtualization - Deploy Virtual Service}
     */
    public static Localizable _DevTestDeployVs_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "DevTestDeployVs.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestParser.Start}: {@code Parsing report}.
     * 
     * @return
     *     {@code Parsing report}
     */
    public static String DevTestParser_Start() {
        return holder.format("DevTestParser.Start");
    }

    /**
     * Key {@code DevTestParser.Start}: {@code Parsing report}.
     * 
     * @return
     *     {@code Parsing report}
     */
    public static Localizable _DevTestParser_Start() {
        return new Localizable(holder, "DevTestParser.Start");
    }

    /**
     * Key {@code DevTestDeployTest.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization - Deploy Test}.
     * 
     * @return
     *     {@code CA Service Virtualization - Deploy Test}
     */
    public static String DevTestDeployTest_DescriptorImpl_DisplayName() {
        return holder.format("DevTestDeployTest.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestDeployTest.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization - Deploy Test}.
     * 
     * @return
     *     {@code CA Service Virtualization - Deploy Test}
     */
    public static Localizable _DevTestDeployTest_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "DevTestDeployTest.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestReport.Url}: {@code CAServiceVirtualizationReport}.
     * 
     * @return
     *     {@code CAServiceVirtualizationReport}
     */
    public static String DevTestReport_Url() {
        return holder.format("DevTestReport.Url");
    }

    /**
     * Key {@code DevTestReport.Url}: {@code CAServiceVirtualizationReport}.
     * 
     * @return
     *     {@code CAServiceVirtualizationReport}
     */
    public static Localizable _DevTestReport_Url() {
        return new Localizable(holder, "DevTestReport.Url");
    }

    /**
     * Key {@code DevTestReport.TestName}: {@code Test name}.
     * 
     * @return
     *     {@code Test name}
     */
    public static String DevTestReport_TestName() {
        return holder.format("DevTestReport.TestName");
    }

    /**
     * Key {@code DevTestReport.TestName}: {@code Test name}.
     * 
     * @return
     *     {@code Test name}
     */
    public static Localizable _DevTestReport_TestName() {
        return new Localizable(holder, "DevTestReport.TestName");
    }

    /**
     * Key {@code DevTestDeployTest.deploying}: {@code Deploying Test MAR
     * file: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deploying Test MAR file: {0}}
     */
    public static String DevTestDeployTest_deploying(Object arg0) {
        return holder.format("DevTestDeployTest.deploying", arg0);
    }

    /**
     * Key {@code DevTestDeployTest.deploying}: {@code Deploying Test MAR
     * file: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deploying Test MAR file: {0}}
     */
    public static Localizable _DevTestDeployTest_deploying(Object arg0) {
        return new Localizable(holder, "DevTestDeployTest.deploying", arg0);
    }

    /**
     * Key {@code DevTestPlugin.success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static String DevTestPlugin_success() {
        return holder.format("DevTestPlugin.success");
    }

    /**
     * Key {@code DevTestPlugin.success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static Localizable _DevTestPlugin_success() {
        return new Localizable(holder, "DevTestPlugin.success");
    }

    /**
     * Key {@code DevTestParser.CaseNotParsedIn}: {@code Cannot parse test
     * case in {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot parse test case in {0}}
     */
    public static String DevTestParser_CaseNotParsedIn(Object arg0) {
        return holder.format("DevTestParser.CaseNotParsedIn", arg0);
    }

    /**
     * Key {@code DevTestParser.CaseNotParsedIn}: {@code Cannot parse test
     * case in {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot parse test case in {0}}
     */
    public static Localizable _DevTestParser_CaseNotParsedIn(Object arg0) {
        return new Localizable(holder, "DevTestParser.CaseNotParsedIn", arg0);
    }

    /**
     * Key {@code Utils.EmptyRegistry}: {@code Custom DevTest Registry
     * endpoint was selected but configuration of the endpoint in build step
     * was incorrect. There are some empty fields!}.
     * 
     * @return
     *     {@code Custom DevTest Registry endpoint was selected but configuration
     *     of the endpoint in build step was incorrect. There are some empty
     *     fields!}
     */
    public static String Utils_EmptyRegistry() {
        return holder.format("Utils.EmptyRegistry");
    }

    /**
     * Key {@code Utils.EmptyRegistry}: {@code Custom DevTest Registry
     * endpoint was selected but configuration of the endpoint in build step
     * was incorrect. There are some empty fields!}.
     * 
     * @return
     *     {@code Custom DevTest Registry endpoint was selected but configuration
     *     of the endpoint in build step was incorrect. There are some empty
     *     fields!}
     */
    public static Localizable _Utils_EmptyRegistry() {
        return new Localizable(holder, "Utils.EmptyRegistry");
    }

    /**
     * Key {@code DevTestPlugin.emptyVsNames}: {@code VS names cannot be
     * empty!}.
     * 
     * @return
     *     {@code VS names cannot be empty!}
     */
    public static String DevTestPlugin_emptyVsNames() {
        return holder.format("DevTestPlugin.emptyVsNames");
    }

    /**
     * Key {@code DevTestPlugin.emptyVsNames}: {@code VS names cannot be
     * empty!}.
     * 
     * @return
     *     {@code VS names cannot be empty!}
     */
    public static Localizable _DevTestPlugin_emptyVsNames() {
        return new Localizable(holder, "DevTestPlugin.emptyVsNames");
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.creating}: {@code Creating virtual
     * service}.
     * 
     * @return
     *     {@code Creating virtual service}
     */
    public static String DevTestCreateAndDeployVs_creating() {
        return holder.format("DevTestCreateAndDeployVs.creating");
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.creating}: {@code Creating virtual
     * service}.
     * 
     * @return
     *     {@code Creating virtual service}
     */
    public static Localizable _DevTestCreateAndDeployVs_creating() {
        return new Localizable(holder, "DevTestCreateAndDeployVs.creating");
    }

    /**
     * Key {@code DevTestParser.StartCases}: {@code Parsing cases}.
     * 
     * @return
     *     {@code Parsing cases}
     */
    public static String DevTestParser_StartCases() {
        return holder.format("DevTestParser.StartCases");
    }

    /**
     * Key {@code DevTestParser.StartCases}: {@code Parsing cases}.
     * 
     * @return
     *     {@code Parsing cases}
     */
    public static Localizable _DevTestParser_StartCases() {
        return new Localizable(holder, "DevTestParser.StartCases");
    }

    /**
     * Key {@code Utils.FolderNoAccess}: {@code Cannot access folder {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot access folder {0}}
     */
    public static String Utils_FolderNoAccess(Object arg0) {
        return holder.format("Utils.FolderNoAccess", arg0);
    }

    /**
     * Key {@code Utils.FolderNoAccess}: {@code Cannot access folder {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot access folder {0}}
     */
    public static Localizable _Utils_FolderNoAccess(Object arg0) {
        return new Localizable(holder, "Utils.FolderNoAccess", arg0);
    }

    /**
     * Key {@code DevTestStartVs.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization - Start Virtual Service}.
     * 
     * @return
     *     {@code CA Service Virtualization - Start Virtual Service}
     */
    public static String DevTestStartVs_DescriptorImpl_DisplayName() {
        return holder.format("DevTestStartVs.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestStartVs.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization - Start Virtual Service}.
     * 
     * @return
     *     {@code CA Service Virtualization - Start Virtual Service}
     */
    public static Localizable _DevTestStartVs_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "DevTestStartVs.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.createAndDeploySuccess}: {@code
     * Virtual Service has been created and deployed successfully}.
     * 
     * @return
     *     {@code Virtual Service has been created and deployed successfully}
     */
    public static String DevTestCreateAndDeployVs_createAndDeploySuccess() {
        return holder.format("DevTestCreateAndDeployVs.createAndDeploySuccess");
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.createAndDeploySuccess}: {@code
     * Virtual Service has been created and deployed successfully}.
     * 
     * @return
     *     {@code Virtual Service has been created and deployed successfully}
     */
    public static Localizable _DevTestCreateAndDeployVs_createAndDeploySuccess() {
        return new Localizable(holder, "DevTestCreateAndDeployVs.createAndDeploySuccess");
    }

    /**
     * Key {@code DevTestReport.NoReports}: {@code No reports found}.
     * 
     * @return
     *     {@code No reports found}
     */
    public static String DevTestReport_NoReports() {
        return holder.format("DevTestReport.NoReports");
    }

    /**
     * Key {@code DevTestReport.NoReports}: {@code No reports found}.
     * 
     * @return
     *     {@code No reports found}
     */
    public static Localizable _DevTestReport_NoReports() {
        return new Localizable(holder, "DevTestReport.NoReports");
    }

    /**
     * Key {@code DevTestReport.Message}: {@code view message}.
     * 
     * @return
     *     {@code view message}
     */
    public static String DevTestReport_Message() {
        return holder.format("DevTestReport.Message");
    }

    /**
     * Key {@code DevTestReport.Message}: {@code view message}.
     * 
     * @return
     *     {@code view message}
     */
    public static Localizable _DevTestReport_Message() {
        return new Localizable(holder, "DevTestReport.Message");
    }

    /**
     * Key {@code DevTestParser.CaseNotParsed}: {@code Failed to parse test
     * case}.
     * 
     * @return
     *     {@code Failed to parse test case}
     */
    public static String DevTestParser_CaseNotParsed() {
        return holder.format("DevTestParser.CaseNotParsed");
    }

    /**
     * Key {@code DevTestParser.CaseNotParsed}: {@code Failed to parse test
     * case}.
     * 
     * @return
     *     {@code Failed to parse test case}
     */
    public static Localizable _DevTestParser_CaseNotParsed() {
        return new Localizable(holder, "DevTestParser.CaseNotParsed");
    }

    /**
     * Key {@code DevTestReport.AllTestsPassed}: {@code All tests have
     * passed}.
     * 
     * @return
     *     {@code All tests have passed}
     */
    public static String DevTestReport_AllTestsPassed() {
        return holder.format("DevTestReport.AllTestsPassed");
    }

    /**
     * Key {@code DevTestReport.AllTestsPassed}: {@code All tests have
     * passed}.
     * 
     * @return
     *     {@code All tests have passed}
     */
    public static Localizable _DevTestReport_AllTestsPassed() {
        return new Localizable(holder, "DevTestReport.AllTestsPassed");
    }

    /**
     * Key {@code DevTestReport.Cycles}: {@code Cycles}.
     * 
     * @return
     *     {@code Cycles}
     */
    public static String DevTestReport_Cycles() {
        return holder.format("DevTestReport.Cycles");
    }

    /**
     * Key {@code DevTestReport.Cycles}: {@code Cycles}.
     * 
     * @return
     *     {@code Cycles}
     */
    public static Localizable _DevTestReport_Cycles() {
        return new Localizable(holder, "DevTestReport.Cycles");
    }

    /**
     * Key {@code DevTestStartTest.Test}: {@code Test}.
     * 
     * @return
     *     {@code Test}
     */
    public static String DevTestStartTest_Test() {
        return holder.format("DevTestStartTest.Test");
    }

    /**
     * Key {@code DevTestStartTest.Test}: {@code Test}.
     * 
     * @return
     *     {@code Test}
     */
    public static Localizable _DevTestStartTest_Test() {
        return new Localizable(holder, "DevTestStartTest.Test");
    }

    /**
     * Key {@code DevTestDeployTest.missing.mar}: {@code Path to MAR file
     * cannot be empty}.
     * 
     * @return
     *     {@code Path to MAR file cannot be empty}
     */
    public static String DevTestDeployTest_missing_mar() {
        return holder.format("DevTestDeployTest.missing.mar");
    }

    /**
     * Key {@code DevTestDeployTest.missing.mar}: {@code Path to MAR file
     * cannot be empty}.
     * 
     * @return
     *     {@code Path to MAR file cannot be empty}
     */
    public static Localizable _DevTestDeployTest_missing_mar() {
        return new Localizable(holder, "DevTestDeployTest.missing.mar");
    }

    /**
     * Key {@code DevTestDeployTest.Test}: {@code Test}.
     * 
     * @return
     *     {@code Test}
     */
    public static String DevTestDeployTest_Test() {
        return holder.format("DevTestDeployTest.Test");
    }

    /**
     * Key {@code DevTestDeployTest.Test}: {@code Test}.
     * 
     * @return
     *     {@code Test}
     */
    public static Localizable _DevTestDeployTest_Test() {
        return new Localizable(holder, "DevTestDeployTest.Test");
    }

    /**
     * Key {@code DevTestParser.SuiteIDNotParsed}: {@code Failed to parse
     * suite for ids}.
     * 
     * @return
     *     {@code Failed to parse suite for ids}
     */
    public static String DevTestParser_SuiteIDNotParsed() {
        return holder.format("DevTestParser.SuiteIDNotParsed");
    }

    /**
     * Key {@code DevTestParser.SuiteIDNotParsed}: {@code Failed to parse
     * suite for ids}.
     * 
     * @return
     *     {@code Failed to parse suite for ids}
     */
    public static Localizable _DevTestParser_SuiteIDNotParsed() {
        return new Localizable(holder, "DevTestParser.SuiteIDNotParsed");
    }

    /**
     * Key {@code DevTestParser.SuiteNotParsedIn}: {@code Cannot parse suite
     * in {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot parse suite in {0}}
     */
    public static String DevTestParser_SuiteNotParsedIn(Object arg0) {
        return holder.format("DevTestParser.SuiteNotParsedIn", arg0);
    }

    /**
     * Key {@code DevTestParser.SuiteNotParsedIn}: {@code Cannot parse suite
     * in {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot parse suite in {0}}
     */
    public static Localizable _DevTestParser_SuiteNotParsedIn(Object arg0) {
        return new Localizable(holder, "DevTestParser.SuiteNotParsedIn", arg0);
    }

    /**
     * Key {@code Utils.IncorrectRegistry}: {@code Custom registry was not
     * specified but configuration of DevTest Registry endpoint in global
     * configuration was incorrect. There are some empty fields!}.
     * 
     * @return
     *     {@code Custom registry was not specified but configuration of DevTest
     *     Registry endpoint in global configuration was incorrect. There are
     *     some empty fields!}
     */
    public static String Utils_IncorrectRegistry() {
        return holder.format("Utils.IncorrectRegistry");
    }

    /**
     * Key {@code Utils.IncorrectRegistry}: {@code Custom registry was not
     * specified but configuration of DevTest Registry endpoint in global
     * configuration was incorrect. There are some empty fields!}.
     * 
     * @return
     *     {@code Custom registry was not specified but configuration of DevTest
     *     Registry endpoint in global configuration was incorrect. There are
     *     some empty fields!}
     */
    public static Localizable _Utils_IncorrectRegistry() {
        return new Localizable(holder, "Utils.IncorrectRegistry");
    }

    /**
     * Key {@code DevTestPlugin.DescriptorImpl.MissingCustomRegistry}: {@code
     * When using custom registry, then all attributes needs to be filled}.
     * 
     * @return
     *     {@code When using custom registry, then all attributes needs to be
     *     filled}
     */
    public static String DevTestPlugin_DescriptorImpl_MissingCustomRegistry() {
        return holder.format("DevTestPlugin.DescriptorImpl.MissingCustomRegistry");
    }

    /**
     * Key {@code DevTestPlugin.DescriptorImpl.MissingCustomRegistry}: {@code
     * When using custom registry, then all attributes needs to be filled}.
     * 
     * @return
     *     {@code When using custom registry, then all attributes needs to be
     *     filled}
     */
    public static Localizable _DevTestPlugin_DescriptorImpl_MissingCustomRegistry() {
        return new Localizable(holder, "DevTestPlugin.DescriptorImpl.MissingCustomRegistry");
    }

    /**
     * Key {@code DevTestParser.FailedReadFile}: {@code Failed to read file
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to read file {0}}
     */
    public static String DevTestParser_FailedReadFile(Object arg0) {
        return holder.format("DevTestParser.FailedReadFile", arg0);
    }

    /**
     * Key {@code DevTestParser.FailedReadFile}: {@code Failed to read file
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to read file {0}}
     */
    public static Localizable _DevTestParser_FailedReadFile(Object arg0) {
        return new Localizable(holder, "DevTestParser.FailedReadFile", arg0);
    }

    /**
     * Key {@code DevTestPlugin.DescriptorImpl.requiredCred}: {@code Registry
     * credentials must be specified!}.
     * 
     * @return
     *     {@code Registry credentials must be specified!}
     */
    public static String DevTestPlugin_DescriptorImpl_requiredCred() {
        return holder.format("DevTestPlugin.DescriptorImpl.requiredCred");
    }

    /**
     * Key {@code DevTestPlugin.DescriptorImpl.requiredCred}: {@code Registry
     * credentials must be specified!}.
     * 
     * @return
     *     {@code Registry credentials must be specified!}
     */
    public static Localizable _DevTestPlugin_DescriptorImpl_requiredCred() {
        return new Localizable(holder, "DevTestPlugin.DescriptorImpl.requiredCred");
    }

    /**
     * Key {@code DevTestStopVs.success}: {@code Virtual service: {0} on VSE:
     * {1} was successfully stopped}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Virtual service: {0} on VSE: {1} was successfully stopped}
     */
    public static String DevTestStopVs_success(Object arg0, Object arg1) {
        return holder.format("DevTestStopVs.success", arg0, arg1);
    }

    /**
     * Key {@code DevTestStopVs.success}: {@code Virtual service: {0} on VSE:
     * {1} was successfully stopped}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Virtual service: {0} on VSE: {1} was successfully stopped}
     */
    public static Localizable _DevTestStopVs_success(Object arg0, Object arg1) {
        return new Localizable(holder, "DevTestStopVs.success", arg0, arg1);
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.creatingAndDeploying}: {@code
     * Creating and deploying virtual service}.
     * 
     * @return
     *     {@code Creating and deploying virtual service}
     */
    public static String DevTestCreateAndDeployVs_creatingAndDeploying() {
        return holder.format("DevTestCreateAndDeployVs.creatingAndDeploying");
    }

    /**
     * Key {@code DevTestCreateAndDeployVs.creatingAndDeploying}: {@code
     * Creating and deploying virtual service}.
     * 
     * @return
     *     {@code Creating and deploying virtual service}
     */
    public static Localizable _DevTestCreateAndDeployVs_creatingAndDeploying() {
        return new Localizable(holder, "DevTestCreateAndDeployVs.creatingAndDeploying");
    }

    /**
     * Key {@code DevTestStartVs.success}: {@code Virtual service: {0} on
     * VSE: {1} was successfully started}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Virtual service: {0} on VSE: {1} was successfully started}
     */
    public static String DevTestStartVs_success(Object arg0, Object arg1) {
        return holder.format("DevTestStartVs.success", arg0, arg1);
    }

    /**
     * Key {@code DevTestStartVs.success}: {@code Virtual service: {0} on
     * VSE: {1} was successfully started}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Virtual service: {0} on VSE: {1} was successfully started}
     */
    public static Localizable _DevTestStartVs_success(Object arg0, Object arg1) {
        return new Localizable(holder, "DevTestStartVs.success", arg0, arg1);
    }

    /**
     * Key {@code DevTestPlugin.connectionFailed}: {@code Connection failed!
     * Status code {0} and response is:
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection failed! Status code {0} and response is:
     *     {1}}
     */
    public static String DevTestPlugin_connectionFailed(Object arg0, Object arg1) {
        return holder.format("DevTestPlugin.connectionFailed", arg0, arg1);
    }

    /**
     * Key {@code DevTestPlugin.connectionFailed}: {@code Connection failed!
     * Status code {0} and response is:
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection failed! Status code {0} and response is:
     *     {1}}
     */
    public static Localizable _DevTestPlugin_connectionFailed(Object arg0, Object arg1) {
        return new Localizable(holder, "DevTestPlugin.connectionFailed", arg0, arg1);
    }

    /**
     * Key {@code DevTestReport.Response}: {@code response}.
     * 
     * @return
     *     {@code response}
     */
    public static String DevTestReport_Response() {
        return holder.format("DevTestReport.Response");
    }

    /**
     * Key {@code DevTestReport.Response}: {@code response}.
     * 
     * @return
     *     {@code response}
     */
    public static Localizable _DevTestReport_Response() {
        return new Localizable(holder, "DevTestReport.Response");
    }

    /**
     * Key {@code DevTestUndeployVs.undeploying}: {@code Undeploying virtual
     * service: {0} on VSE: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Undeploying virtual service: {0} on VSE: {1}}
     */
    public static String DevTestUndeployVs_undeploying(Object arg0, Object arg1) {
        return holder.format("DevTestUndeployVs.undeploying", arg0, arg1);
    }

    /**
     * Key {@code DevTestUndeployVs.undeploying}: {@code Undeploying virtual
     * service: {0} on VSE: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Undeploying virtual service: {0} on VSE: {1}}
     */
    public static Localizable _DevTestUndeployVs_undeploying(Object arg0, Object arg1) {
        return new Localizable(holder, "DevTestUndeployVs.undeploying", arg0, arg1);
    }

    /**
     * Key {@code DevTestDeployVs.error}: {@code Deployment of virtual
     * service failed!}.
     * 
     * @return
     *     {@code Deployment of virtual service failed!}
     */
    public static String DevTestDeployVs_error() {
        return holder.format("DevTestDeployVs.error");
    }

    /**
     * Key {@code DevTestDeployVs.error}: {@code Deployment of virtual
     * service failed!}.
     * 
     * @return
     *     {@code Deployment of virtual service failed!}
     */
    public static Localizable _DevTestDeployVs_error() {
        return new Localizable(holder, "DevTestDeployVs.error");
    }

    /**
     * Key {@code DevTestReport.Tests}: {@code tests}.
     * 
     * @return
     *     {@code tests}
     */
    public static String DevTestReport_Tests() {
        return holder.format("DevTestReport.Tests");
    }

    /**
     * Key {@code DevTestReport.Tests}: {@code tests}.
     * 
     * @return
     *     {@code tests}
     */
    public static Localizable _DevTestReport_Tests() {
        return new Localizable(holder, "DevTestReport.Tests");
    }

    /**
     * Key {@code DevTestUndeployVs.VSNotFound}: {@code Virtual service: {0}
     * does not exist on VSE: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Virtual service: {0} does not exist on VSE: {1}}
     */
    public static String DevTestUndeployVs_VSNotFound(Object arg0, Object arg1) {
        return holder.format("DevTestUndeployVs.VSNotFound", arg0, arg1);
    }

    /**
     * Key {@code DevTestUndeployVs.VSNotFound}: {@code Virtual service: {0}
     * does not exist on VSE: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Virtual service: {0} does not exist on VSE: {1}}
     */
    public static Localizable _DevTestUndeployVs_VSNotFound(Object arg0, Object arg1) {
        return new Localizable(holder, "DevTestUndeployVs.VSNotFound", arg0, arg1);
    }

    /**
     * Key {@code DevTestReport.FailedWithStatus}: {@code Failed with
     * status}.
     * 
     * @return
     *     {@code Failed with status}
     */
    public static String DevTestReport_FailedWithStatus() {
        return holder.format("DevTestReport.FailedWithStatus");
    }

    /**
     * Key {@code DevTestReport.FailedWithStatus}: {@code Failed with
     * status}.
     * 
     * @return
     *     {@code Failed with status}
     */
    public static Localizable _DevTestReport_FailedWithStatus() {
        return new Localizable(holder, "DevTestReport.FailedWithStatus");
    }

    /**
     * Key {@code DevTestDeployVs.DescriptorImpl.MissingMarFile}: {@code MAR
     * file location cannot be empty}.
     * 
     * @return
     *     {@code MAR file location cannot be empty}
     */
    public static String DevTestDeployVs_DescriptorImpl_MissingMarFile() {
        return holder.format("DevTestDeployVs.DescriptorImpl.MissingMarFile");
    }

    /**
     * Key {@code DevTestDeployVs.DescriptorImpl.MissingMarFile}: {@code MAR
     * file location cannot be empty}.
     * 
     * @return
     *     {@code MAR file location cannot be empty}
     */
    public static Localizable _DevTestDeployVs_DescriptorImpl_MissingMarFile() {
        return new Localizable(holder, "DevTestDeployVs.DescriptorImpl.MissingMarFile");
    }

    /**
     * Key {@code DevTestPlugin.devTestLocation}: {@code To DevTest API
     * located on {0}:{1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code To DevTest API located on {0}:{1}}
     */
    public static String DevTestPlugin_devTestLocation(Object arg0, Object arg1) {
        return holder.format("DevTestPlugin.devTestLocation", arg0, arg1);
    }

    /**
     * Key {@code DevTestPlugin.devTestLocation}: {@code To DevTest API
     * located on {0}:{1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code To DevTest API located on {0}:{1}}
     */
    public static Localizable _DevTestPlugin_devTestLocation(Object arg0, Object arg1) {
        return new Localizable(holder, "DevTestPlugin.devTestLocation", arg0, arg1);
    }

    /**
     * Key {@code DevTestUndeployVs.success}: {@code Virtual service: {0} on
     * VSE: {1} was successfully undeployed}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Virtual service: {0} on VSE: {1} was successfully undeployed}
     */
    public static String DevTestUndeployVs_success(Object arg0, Object arg1) {
        return holder.format("DevTestUndeployVs.success", arg0, arg1);
    }

    /**
     * Key {@code DevTestUndeployVs.success}: {@code Virtual service: {0} on
     * VSE: {1} was successfully undeployed}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Virtual service: {0} on VSE: {1} was successfully undeployed}
     */
    public static Localizable _DevTestUndeployVs_success(Object arg0, Object arg1) {
        return new Localizable(holder, "DevTestUndeployVs.success", arg0, arg1);
    }

    /**
     * Key {@code DevTestPlugin.DescriptorImpl.MissingVse}: {@code Name of
     * Virtual Service Environment cannot be empty}.
     * 
     * @return
     *     {@code Name of Virtual Service Environment cannot be empty}
     */
    public static String DevTestPlugin_DescriptorImpl_MissingVse() {
        return holder.format("DevTestPlugin.DescriptorImpl.MissingVse");
    }

    /**
     * Key {@code DevTestPlugin.DescriptorImpl.MissingVse}: {@code Name of
     * Virtual Service Environment cannot be empty}.
     * 
     * @return
     *     {@code Name of Virtual Service Environment cannot be empty}
     */
    public static Localizable _DevTestPlugin_DescriptorImpl_MissingVse() {
        return new Localizable(holder, "DevTestPlugin.DescriptorImpl.MissingVse");
    }

    /**
     * Key {@code DevTestReport.Failed}: {@code FAILED}.
     * 
     * @return
     *     {@code FAILED}
     */
    public static String DevTestReport_Failed() {
        return holder.format("DevTestReport.Failed");
    }

    /**
     * Key {@code DevTestReport.Failed}: {@code FAILED}.
     * 
     * @return
     *     {@code FAILED}
     */
    public static Localizable _DevTestReport_Failed() {
        return new Localizable(holder, "DevTestReport.Failed");
    }

    /**
     * Key {@code DevTestPlugin.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization}.
     * 
     * @return
     *     {@code CA Service Virtualization}
     */
    public static String DevTestPlugin_DescriptorImpl_DisplayName() {
        return holder.format("DevTestPlugin.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestPlugin.DescriptorImpl.DisplayName}: {@code CA
     * Service Virtualization}.
     * 
     * @return
     *     {@code CA Service Virtualization}
     */
    public static Localizable _DevTestPlugin_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "DevTestPlugin.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code DevTestPlugin.emptyVseName}: {@code VSE name cannot be
     * empty!}.
     * 
     * @return
     *     {@code VSE name cannot be empty!}
     */
    public static String DevTestPlugin_emptyVseName() {
        return holder.format("DevTestPlugin.emptyVseName");
    }

    /**
     * Key {@code DevTestPlugin.emptyVseName}: {@code VSE name cannot be
     * empty!}.
     * 
     * @return
     *     {@code VSE name cannot be empty!}
     */
    public static Localizable _DevTestPlugin_emptyVseName() {
        return new Localizable(holder, "DevTestPlugin.emptyVseName");
    }

    /**
     * Key {@code DevTestPlugin.missingFile}: {@code File {0} is not present
     * in the workspace of job}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code File {0} is not present in the workspace of job}
     */
    public static String DevTestPlugin_missingFile(Object arg0) {
        return holder.format("DevTestPlugin.missingFile", arg0);
    }

    /**
     * Key {@code DevTestPlugin.missingFile}: {@code File {0} is not present
     * in the workspace of job}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code File {0} is not present in the workspace of job}
     */
    public static Localizable _DevTestPlugin_missingFile(Object arg0) {
        return new Localizable(holder, "DevTestPlugin.missingFile", arg0);
    }

}
