/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.secretsmanager;

import hudson.Extension;
import io.jenkins.plugins.casc.SecretSource;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;

@Extension
public class AwsSecretsManagerSecretSource
extends SecretSource {
    private static final Logger LOG = Logger.getLogger(AwsSecretsManagerSecretSource.class.getName());
    private transient SecretsManagerClient client = null;

    public Optional<String> reveal(String id) throws IOException {
        try {
            GetSecretValueRequest request = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(id).build();
            GetSecretValueResponse result = this.client.getSecretValue(request);
            if (result.secretBinary() != null) {
                throw new IOException(String.format("The binary secret '%s' is not supported. Please change its value to a string, or alternatively delete it.", result.name()));
            }
            return Optional.ofNullable(result.secretString());
        }
        catch (ResourceNotFoundException e) {
            LOG.info(e.getMessage());
            return Optional.empty();
        }
        catch (SecretsManagerException e) {
            LOG.warning(e.getMessage());
            throw new IOException(e);
        }
    }

    public void init() {
        try {
            this.client = SecretsManagerClient.create();
        }
        catch (SdkClientException e) {
            LOG.log(Level.WARNING, "Could not set up AWS Secrets Manager client. Reason: {0}", e.getMessage());
        }
    }
}

