/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.supplier;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.model.Filter;
import com.amazonaws.services.secretsmanager.model.ListSecretsRequest;
import com.amazonaws.services.secretsmanager.model.ListSecretsResult;
import com.amazonaws.services.secretsmanager.model.SecretListEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class ListSecretsOperation
implements Supplier<Collection<SecretListEntry>> {
    private final AWSSecretsManager client;
    private final Collection<Filter> filters;

    ListSecretsOperation(AWSSecretsManager client, Collection<Filter> filters) {
        this.client = client;
        this.filters = filters;
    }

    @Override
    public Collection<SecretListEntry> get() {
        ListSecretsResult result;
        ArrayList<SecretListEntry> secretList = new ArrayList<SecretListEntry>();
        Optional<Object> nextToken = Optional.empty();
        do {
            ListSecretsRequest base = new ListSecretsRequest().withFilters(this.filters);
            ListSecretsRequest request = nextToken.map(nt -> base.withNextToken(nt)).orElse(base);
            result = this.client.listSecrets(request);
            List secrets = result.getSecretList().stream().filter(ListSecretsOperation::isNotDeleted).collect(Collectors.toList());
            secretList.addAll(secrets);
        } while ((nextToken = Optional.ofNullable(result.getNextToken())).isPresent());
        return secretList;
    }

    private static boolean isNotDeleted(SecretListEntry entry) {
        return entry.getDeletedDate() == null;
    }
}

