/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.autify.model;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import io.jenkins.plugins.autify.Messages;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class UrlReplacement
extends AbstractDescribableImpl<UrlReplacement> {
    private final String patternUrl;
    private final String replacementUrl;

    @DataBoundConstructor
    public UrlReplacement(String patternUrl, String replacementUrl) {
        this.patternUrl = StringUtils.trimToNull((String)patternUrl);
        this.replacementUrl = StringUtils.trimToNull((String)replacementUrl);
    }

    public String getPatternUrl() {
        return this.patternUrl;
    }

    public String getReplacementUrl() {
        return this.replacementUrl;
    }

    public String toCliString() {
        if (this.patternUrl == null || this.replacementUrl == null) {
            return null;
        }
        return this.patternUrl + " " + this.replacementUrl;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<UrlReplacement> {
        private final UrlValidator urlValidator = new UrlValidator(new String[]{"http", "https"}, 8L);

        public FormValidation doCheckPatternUrl(@QueryParameter String value, @QueryParameter String replacementUrl) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)Messages.AutifyWebBuilder_CannotBeEmpty());
            }
            if (StringUtils.isNotBlank((String)replacementUrl) && value.equals(replacementUrl)) {
                return FormValidation.error((String)Messages.AutifyWebBuilder_CannotSetTheSameUrl());
            }
            if (!this.urlValidator.isValid(value)) {
                return FormValidation.warning((String)Messages.AutifyWebBuilder_InvalidUrl());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckReplacementUrl(@QueryParameter String value, @QueryParameter String patternUrl) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)Messages.AutifyWebBuilder_CannotBeEmpty());
            }
            if (StringUtils.isNotBlank((String)patternUrl) && value.equals(patternUrl)) {
                return FormValidation.error((String)Messages.AutifyWebBuilder_CannotSetTheSameUrl());
            }
            if (!this.urlValidator.isValid(value)) {
                return FormValidation.warning((String)Messages.AutifyWebBuilder_InvalidUrl());
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "UrlReplacement";
        }
    }
}

