/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.autify;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.autify.AutifyCli;
import io.jenkins.plugins.autify.Messages;
import io.jenkins.plugins.autify.model.UrlReplacement;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class AutifyWebBuilder
extends Builder
implements SimpleBuildStep {
    private static final String userAgentSuffix = "jenkins-plugin-autifyWeb";
    private final String credentialsId;
    private final String autifyUrl;
    private boolean wait;
    private String timeout;
    private List<UrlReplacement> urlReplacements;
    private String testExecutionName;
    private String browser;
    private String device;
    private String deviceType;
    private String os;
    private String osVersion;
    private String autifyConnect;
    private boolean autifyConnectClient;
    private String autifyConnectClientExtraArguments;
    private String autifyPath;
    private String shellInstallerUrl;

    @DataBoundConstructor
    public AutifyWebBuilder(String credentialsId, String autifyUrl) {
        this.credentialsId = credentialsId;
        this.autifyUrl = autifyUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getAutifyUrl() {
        return this.autifyUrl;
    }

    public boolean isWait() {
        return this.wait;
    }

    @DataBoundSetter
    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public String getTimeout() {
        return StringUtils.trimToEmpty((String)this.timeout);
    }

    @DataBoundSetter
    public void setTimeout(@CheckForNull String value) {
        this.timeout = value;
    }

    public List<UrlReplacement> getUrlReplacements() {
        return this.urlReplacements == null ? Collections.emptyList() : this.urlReplacements;
    }

    @DataBoundSetter
    public void setUrlReplacements(@CheckForNull List<UrlReplacement> value) {
        this.urlReplacements = value;
    }

    public String getTestExecutionName() {
        return StringUtils.trimToEmpty((String)this.testExecutionName);
    }

    @DataBoundSetter
    public void setTestExecutionName(@CheckForNull String value) {
        this.testExecutionName = value;
    }

    public String getBrowser() {
        return StringUtils.trimToEmpty((String)this.browser);
    }

    @DataBoundSetter
    public void setBrowser(@CheckForNull String value) {
        this.browser = value;
    }

    public String getDevice() {
        return StringUtils.trimToEmpty((String)this.device);
    }

    @DataBoundSetter
    public void setDevice(@CheckForNull String value) {
        this.device = value;
    }

    public String getDeviceType() {
        return StringUtils.trimToEmpty((String)this.deviceType);
    }

    @DataBoundSetter
    public void setDeviceType(@CheckForNull String value) {
        this.deviceType = value;
    }

    public String getOs() {
        return StringUtils.trimToEmpty((String)this.os);
    }

    @DataBoundSetter
    public void setOs(@CheckForNull String value) {
        this.os = value;
    }

    public String getOsVersion() {
        return StringUtils.trimToEmpty((String)this.osVersion);
    }

    @DataBoundSetter
    public void setOsVersion(@CheckForNull String value) {
        this.osVersion = value;
    }

    public String getAutifyConnect() {
        return StringUtils.trimToEmpty((String)this.autifyConnect);
    }

    @DataBoundSetter
    public void setAutifyConnect(@CheckForNull String value) {
        this.autifyConnect = value;
    }

    public boolean isAutifyConnectClient() {
        return this.autifyConnectClient;
    }

    @DataBoundSetter
    public void setAutifyConnectClient(@CheckForNull boolean value) {
        this.autifyConnectClient = value;
    }

    public String getAutifyConnectClientExtraArguments() {
        return StringUtils.trimToEmpty((String)this.autifyConnectClientExtraArguments);
    }

    @DataBoundSetter
    public void setAutifyConnectClientExtraArguments(@CheckForNull String value) {
        this.autifyConnectClientExtraArguments = value;
    }

    public String getAutifyPath() {
        return StringUtils.trimToEmpty((String)this.autifyPath);
    }

    @DataBoundSetter
    public void setAutifyPath(@CheckForNull String value) {
        this.autifyPath = value;
    }

    public String getShellInstallerUrl() {
        return StringUtils.trimToEmpty((String)this.shellInstallerUrl);
    }

    @DataBoundSetter
    public void setShellInstallerUrl(@CheckForNull String value) {
        this.shellInstallerUrl = value;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        StringCredentials credentials = (StringCredentials)CredentialsProvider.findCredentialById((String)this.credentialsId, StringCredentials.class, run, Collections.emptyList());
        if (credentials == null) {
            listener.getLogger().println("Cannot find any credentials for " + this.credentialsId);
            run.setResult(Result.FAILURE);
            return;
        }
        String webAccessToken = Secret.toString((Secret)credentials.getSecret());
        AutifyCli autifyCli = new AutifyCli(workspace, launcher, listener, this.autifyPath, this.shellInstallerUrl, userAgentSuffix);
        if (autifyCli.install() != 0) {
            listener.getLogger().println("Failed to install autify-cli");
            run.setResult(Result.FAILURE);
            return;
        }
        autifyCli.webAuthLogin(webAccessToken);
        if (autifyCli.webTestRun(this.autifyUrl, this.wait, this.timeout, this.urlReplacements, this.testExecutionName, this.browser, this.device, this.deviceType, this.os, this.osVersion, this.autifyConnect, this.autifyConnectClient, this.autifyConnectClientExtraArguments) != 0) {
            listener.getLogger().println("Failed to execute autify web test run");
            run.setResult(Result.FAILURE);
            return;
        }
    }

    @Symbol(value={"autifyWeb"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private static final Pattern TEST_SCENARIO_URL_PATTERN = Pattern.compile("^https://app.autify.com/projects/\\d+/scenarios/\\d+/?$");
        private static final Pattern TEST_PLAN_URL_PATTERN = Pattern.compile("^https://app.autify.com/projects/\\d+/test_plans/\\d+/?$");

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM, item, StringCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)Messages.AutifyWebBuilder_CannotBeEmpty());
            }
            if (CredentialsProvider.listCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.withId((String)value)).isEmpty()) {
                return FormValidation.error((String)Messages.AutifyWebBuilder_CannotFindCurrentlySelectedCredentials());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAutifyUrl(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)Messages.AutifyWebBuilder_CannotBeEmpty());
            }
            if (!this.isTestScenarioUrl(value) && !this.isTestPlanUrl(value)) {
                return FormValidation.error((String)Messages.AutifyWebBuilder_InvalidUrl());
            }
            return FormValidation.ok();
        }

        private boolean isTestScenarioUrl(String value) {
            return TEST_SCENARIO_URL_PATTERN.matcher(value).find();
        }

        private boolean isTestPlanUrl(String value) {
            return TEST_PLAN_URL_PATTERN.matcher(value).find();
        }

        public FormValidation doCheckWait(@QueryParameter boolean value, @QueryParameter boolean autifyConnectClient) {
            if (autifyConnectClient && !value) {
                return FormValidation.error((String)Messages.AutifyWebBuilder_WaitMustBeCheckedWhenAutifyConnectClientIsEnabled());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value, @QueryParameter boolean wait) {
            if (StringUtils.isNotBlank((String)value) && !wait) {
                return FormValidation.warning((String)Messages.AutifyWebBuilder_NoEffectWhenWaitIsUnchecked());
            }
            return FormValidation.ok();
        }

        private FormValidation checkEffectiveOnlyForTestScenarioUrl(String value, String autifyUrl) {
            if (StringUtils.isNotBlank((String)value) && !this.isTestScenarioUrl(autifyUrl)) {
                return FormValidation.warning((String)Messages.AutifyWebBuilder_EffectiveOnlyForTestScenarioUrl());
            }
            return FormValidation.ok((String)Messages.AutifyWebBuilder_EffectiveOnlyForTestScenarioUrl());
        }

        public FormValidation doCheckTestExecutionName(@QueryParameter String value, @QueryParameter String autifyUrl) {
            return this.checkEffectiveOnlyForTestScenarioUrl(value, autifyUrl);
        }

        public FormValidation doCheckBrowser(@QueryParameter String value, @QueryParameter String autifyUrl) {
            return this.checkEffectiveOnlyForTestScenarioUrl(value, autifyUrl);
        }

        public FormValidation doCheckDevice(@QueryParameter String value, @QueryParameter String autifyUrl) {
            return this.checkEffectiveOnlyForTestScenarioUrl(value, autifyUrl);
        }

        public FormValidation doCheckDeviceType(@QueryParameter String value, @QueryParameter String autifyUrl) {
            return this.checkEffectiveOnlyForTestScenarioUrl(value, autifyUrl);
        }

        public FormValidation doCheckOs(@QueryParameter String value, @QueryParameter String autifyUrl) {
            return this.checkEffectiveOnlyForTestScenarioUrl(value, autifyUrl);
        }

        public FormValidation doCheckOsVersion(@QueryParameter String value, @QueryParameter String autifyUrl) {
            return this.checkEffectiveOnlyForTestScenarioUrl(value, autifyUrl);
        }

        public FormValidation doCheckAutifyConnect(@QueryParameter String value, @QueryParameter boolean autifyConnectClient) {
            if (StringUtils.isNotEmpty((String)value) && autifyConnectClient) {
                return FormValidation.error((String)Messages.AutifyWebBuilder_CannotSpecifyBothAutifyConnectAccessPointAndAutifyConnectClient());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAutifyConnectClient(@QueryParameter boolean value, @QueryParameter boolean wait, @QueryParameter String autifyConnect) {
            if (value && !wait) {
                return FormValidation.error((String)Messages.AutifyWebBuilder_WaitMustBeCheckedWhenAutifyConnectClientIsEnabled());
            }
            if (value && StringUtils.isNotEmpty((String)autifyConnect)) {
                return FormValidation.error((String)Messages.AutifyWebBuilder_CannotSpecifyBothAutifyConnectAccessPointAndAutifyConnectClient());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.AutifyWebBuilder_DescriptorImpl_DisplayName();
        }
    }
}

