/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.autify;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.autify.AutifyCli;
import io.jenkins.plugins.autify.Messages;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class AutifyMobileUploadBuilder
extends Builder
implements SimpleBuildStep {
    private static final String userAgentSuffix = "jenkins-plugin-autifyMobileUpload";
    private final String credentialsId;
    private final String workspaceId;
    private final String buildPath;
    private String autifyPath;
    private String shellInstallerUrl;

    @DataBoundConstructor
    public AutifyMobileUploadBuilder(String credentialsId, String workspaceId, String buildPath) {
        this.credentialsId = credentialsId;
        this.workspaceId = workspaceId;
        this.buildPath = buildPath;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getWorkspaceId() {
        return StringUtils.trimToEmpty((String)this.workspaceId);
    }

    public String getBuildPath() {
        return StringUtils.trimToEmpty((String)this.buildPath);
    }

    public String getAutifyPath() {
        return StringUtils.trimToEmpty((String)this.autifyPath);
    }

    @DataBoundSetter
    public void setAutifyPath(@CheckForNull String value) {
        this.autifyPath = value;
    }

    public String getShellInstallerUrl() {
        return StringUtils.trimToEmpty((String)this.shellInstallerUrl);
    }

    @DataBoundSetter
    public void setShellInstallerUrl(@CheckForNull String value) {
        this.shellInstallerUrl = value;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        StringCredentials credentials = (StringCredentials)CredentialsProvider.findCredentialById((String)this.credentialsId, StringCredentials.class, run, Collections.emptyList());
        if (credentials == null) {
            listener.getLogger().println("Cannot find any credentials for " + this.credentialsId);
            run.setResult(Result.FAILURE);
            return;
        }
        String mobileAccessToken = Secret.toString((Secret)credentials.getSecret());
        AutifyCli autifyCli = new AutifyCli(workspace, launcher, listener, this.autifyPath, this.shellInstallerUrl, userAgentSuffix);
        if (autifyCli.install() != 0) {
            listener.getLogger().println("Failed to install autify-cli");
            run.setResult(Result.FAILURE);
            return;
        }
        autifyCli.mobileAuthLogin(mobileAccessToken);
        if (autifyCli.mobileBuildUpload(this.workspaceId, this.buildPath) != 0) {
            listener.getLogger().println("Failed to execute autify mobile build upload");
            run.setResult(Result.FAILURE);
            return;
        }
    }

    @Symbol(value={"autifyMobileUpload"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM, item, StringCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)Messages.AutifyMobileUploadBuilder_CannotBeEmpty());
            }
            if (CredentialsProvider.listCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.withId((String)value)).isEmpty()) {
                return FormValidation.error((String)Messages.AutifyMobileUploadBuilder_CannotFindCurrentlySelectedCredentials());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckWorkspaceId(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)Messages.AutifyMobileUploadBuilder_CannotBeEmpty());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckBuildPath(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)Messages.AutifyMobileUploadBuilder_CannotBeEmpty());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.AutifyMobileUploadBuilder_DescriptorImpl_DisplayName();
        }
    }
}

