/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.autify;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.autify.AutifyCli;
import io.jenkins.plugins.autify.Messages;
import java.io.IOException;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class AutifyMobileBuilder
extends Builder
implements SimpleBuildStep {
    private static final String userAgentSuffix = "jenkins-plugin-autifyMobile";
    private final String credentialsId;
    private final String autifyUrl;
    private String buildId;
    private String buildPath;
    private boolean wait;
    private String timeout;
    private String autifyPath;
    private String shellInstallerUrl;

    @DataBoundConstructor
    public AutifyMobileBuilder(String credentialsId, String autifyUrl) {
        this.credentialsId = credentialsId;
        this.autifyUrl = autifyUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getAutifyUrl() {
        return this.autifyUrl;
    }

    public String getBuildId() {
        return StringUtils.trimToEmpty((String)this.buildId);
    }

    @DataBoundSetter
    public void setBuildId(String value) {
        this.buildId = value;
    }

    public String getBuildPath() {
        return StringUtils.trimToEmpty((String)this.buildPath);
    }

    @DataBoundSetter
    public void setBuildPath(String value) {
        this.buildPath = value;
    }

    public boolean isWait() {
        return this.wait;
    }

    @DataBoundSetter
    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public String getTimeout() {
        return StringUtils.trimToEmpty((String)this.timeout);
    }

    @DataBoundSetter
    public void setTimeout(@CheckForNull String value) {
        this.timeout = value;
    }

    public String getAutifyPath() {
        return StringUtils.trimToEmpty((String)this.autifyPath);
    }

    @DataBoundSetter
    public void setAutifyPath(@CheckForNull String value) {
        this.autifyPath = value;
    }

    public String getShellInstallerUrl() {
        return StringUtils.trimToEmpty((String)this.shellInstallerUrl);
    }

    @DataBoundSetter
    public void setShellInstallerUrl(@CheckForNull String value) {
        this.shellInstallerUrl = value;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        StringCredentials credentials = (StringCredentials)CredentialsProvider.findCredentialById((String)this.credentialsId, StringCredentials.class, run, Collections.emptyList());
        if (credentials == null) {
            listener.getLogger().println("Cannot find any credentials for " + this.credentialsId);
            run.setResult(Result.FAILURE);
            return;
        }
        String mobileAccessToken = Secret.toString((Secret)credentials.getSecret());
        AutifyCli autifyCli = new AutifyCli(workspace, launcher, listener, this.autifyPath, this.shellInstallerUrl, userAgentSuffix);
        if (autifyCli.install() != 0) {
            listener.getLogger().println("Failed to install autify-cli");
            run.setResult(Result.FAILURE);
            return;
        }
        autifyCli.mobileAuthLogin(mobileAccessToken);
        if (autifyCli.mobileTestRun(this.autifyUrl, this.buildId, this.buildPath, this.wait, this.timeout) != 0) {
            listener.getLogger().println("Failed to execute autify mobile test run");
            run.setResult(Result.FAILURE);
            return;
        }
    }

    @Symbol(value={"autifyMobile"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private static final Pattern TEST_PLAN_URL_PATTERN = Pattern.compile("^https://mobile-app.autify.com/projects/[^/]+/test_plans/[^/]+/?$");

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM, item, StringCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)Messages.AutifyMobileBuilder_CannotBeEmpty());
            }
            if (CredentialsProvider.listCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.withId((String)value)).isEmpty()) {
                return FormValidation.error((String)Messages.AutifyMobileBuilder_CannotFindCurrentlySelectedCredentials());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAutifyUrl(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)Messages.AutifyMobileBuilder_CannotBeEmpty());
            }
            if (!this.isTestPlanUrl(value)) {
                return FormValidation.error((String)Messages.AutifyMobileBuilder_InvalidUrl());
            }
            return FormValidation.ok();
        }

        private boolean isTestPlanUrl(String value) {
            return TEST_PLAN_URL_PATTERN.matcher(value).find();
        }

        public FormValidation doCheckBuildId(@QueryParameter String value, @QueryParameter String buildPath) {
            if (StringUtils.isNotBlank((String)value) && StringUtils.isNotBlank((String)buildPath)) {
                return FormValidation.error((String)Messages.AutifyMobileBuilder_CannotSpecifyBothBuildIdAndBuildPath());
            }
            if (StringUtils.isBlank((String)value) && StringUtils.isBlank((String)buildPath)) {
                return FormValidation.error((String)Messages.AutifyMobileBuilder_SpecifyEitherBuildIdOrBuildPath());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckBuildPath(@QueryParameter String value, @QueryParameter String buildId) {
            if (StringUtils.isNotBlank((String)value) && StringUtils.isNotBlank((String)buildId)) {
                return FormValidation.error((String)Messages.AutifyMobileBuilder_CannotSpecifyBothBuildIdAndBuildPath());
            }
            if (StringUtils.isBlank((String)value) && StringUtils.isBlank((String)buildId)) {
                return FormValidation.error((String)Messages.AutifyMobileBuilder_SpecifyEitherBuildIdOrBuildPath());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value, @QueryParameter boolean wait) {
            if (StringUtils.isNotBlank((String)value) && !wait) {
                return FormValidation.warning((String)Messages.AutifyMobileBuilder_NoEffectWhenWaitIsUnchecked());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.AutifyMobileBuilder_DescriptorImpl_DisplayName();
        }
    }
}

