/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.autify;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import io.jenkins.plugins.autify.model.UrlReplacement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class AutifyCli {
    static final String INSTALL_SCRIPT_URL = "https://autify-cli-assets.s3.amazonaws.com/autify-cli/channels/stable/install-cicd.bash";
    private final FilePath workspace;
    private final Launcher launcher;
    private final PrintStream logger;
    private final String autifyPath;
    private final String shellInstallerUrl;
    private final String userAgentSuffix;
    private String webAccessToken = "";
    private String mobileAccessToken = "";

    public AutifyCli(FilePath workspace, Launcher launcher, TaskListener listener, String autifyPath, String shellInstallerUrl, String userAgentSuffix) {
        this.workspace = workspace;
        this.launcher = launcher;
        this.logger = listener.getLogger();
        this.autifyPath = StringUtils.isEmpty((String)autifyPath) ? "autify" : autifyPath;
        this.shellInstallerUrl = StringUtils.isEmpty((String)shellInstallerUrl) ? INSTALL_SCRIPT_URL : shellInstallerUrl;
        this.userAgentSuffix = StringUtils.trimToEmpty((String)userAgentSuffix);
    }

    public int install() {
        try {
            URL url = new URL(this.shellInstallerUrl);
            InputStream scriptStream = url.openStream();
            return this.runBashScript(scriptStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
    }

    public int webTestRun(String autifyUrl, boolean wait, String timeout, List<UrlReplacement> urlReplacements, String testExecutionName, String browser, String device, String deviceType, String os, String osVersion, String autifyConnect, boolean autifyConnectClient, String autifyConnectClientExtraArguments) {
        Builder builder = new Builder("web", "test", "run");
        builder.add(autifyUrl);
        builder.addFlag("--wait", wait);
        builder.addFlag("--timeout", timeout);
        if (urlReplacements != null) {
            for (UrlReplacement urlReplacement : urlReplacements) {
                builder.addFlag("--url-replacements", urlReplacement.toCliString());
            }
        }
        builder.addFlag("--name", testExecutionName);
        builder.addFlag("--browser", browser);
        builder.addFlag("--device", device);
        builder.addFlag("--device-type", deviceType);
        builder.addFlag("--os", os);
        builder.addFlag("--os-version", osVersion);
        builder.addFlag("--autify-connect", autifyConnect);
        if (autifyConnectClient) {
            if (!wait) {
                this.logger.println("Wait option must be set when running with Autify Connect Client.");
                return 1;
            }
            if (this.execute(new Builder("connect", "client", "install")) != 0) {
                this.logger.println("Failed to install Autify Connect Client.");
                return 1;
            }
            builder.addFlag("--autify-connect-client", autifyConnectClient);
            builder.addFlag("--autify-connect-client-extra-arguments", autifyConnectClientExtraArguments);
        }
        return this.execute(builder);
    }

    public int mobileTestRun(String autifyUrl, String buildId, String buildPath, boolean wait, String timeout) {
        Builder builder = new Builder("mobile", "test", "run");
        builder.add(autifyUrl);
        if (StringUtils.isNotBlank((String)buildId) && StringUtils.isNotBlank((String)buildPath)) {
            this.logger.println("Cannot specify both buildId and buildPath.");
            return 1;
        }
        if (StringUtils.isNotBlank((String)buildId)) {
            builder.addFlag("--build-id", buildId);
        } else if (StringUtils.isNotBlank((String)buildPath)) {
            builder.addFlag("--build-path", buildPath);
        } else {
            this.logger.println("Either buildId or buildPath is required.");
            return 1;
        }
        builder.addFlag("--wait", wait);
        builder.addFlag("--timeout", timeout);
        return this.execute(builder);
    }

    public int mobileBuildUpload(String workspaceId, String buildPath) {
        Builder builder = new Builder("mobile", "build", "upload");
        builder.add(buildPath);
        builder.addFlag("--workspace-id", workspaceId);
        return this.execute(builder);
    }

    public void webAuthLogin(String webAccessToken) {
        this.webAccessToken = webAccessToken;
    }

    public void mobileAuthLogin(String mobileAccessToken) {
        this.mobileAccessToken = mobileAccessToken;
    }

    private int runCommand(InputStream stdin, ArgumentListBuilder builder) {
        return this.runCommand(stdin, builder.toCommandArray());
    }

    private int runCommand(InputStream stdin, String ... command) {
        try {
            Launcher.ProcStarter procStarter = this.launcher.launch().pwd(this.workspace).envs(this.getEnvs()).stdout((OutputStream)this.logger).stderr((OutputStream)this.logger).cmds(command);
            if (stdin != null) {
                procStarter = procStarter.stdin(stdin);
            }
            return procStarter.start().join();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace(this.logger);
            return 1;
        }
    }

    private Map<String, String> getEnvs() {
        HashMap<String, String> envs = new HashMap<String, String>(System.getenv());
        envs.putIfAbsent("AUTIFY_CLI_USER_AGENT_SUFFIX", this.userAgentSuffix);
        envs.put("AUTIFY_CLI_INSTALL_USE_CACHE", "1");
        envs.put("AUTIFY_WEB_ACCESS_TOKEN", this.webAccessToken);
        envs.put("AUTIFY_MOBILE_ACCESS_TOKEN", this.mobileAccessToken);
        envs.put("XDG_CACHE_HOME", this.workspace + "/.cache");
        envs.put("XDG_CONFIG_HOME", this.workspace + "/.config");
        envs.put("XDG_DATA_HOME", this.workspace + "/.data");
        return envs;
    }

    private int execute(ArgumentListBuilder builder) {
        try {
            InputStream scriptStream = AutifyCli.class.getResourceAsStream("/io/jenkins/plugins/autify/AutifyCli/execute.bash");
            int ret = this.runBashScript(scriptStream, builder);
            scriptStream.close();
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
    }

    private int runBashScript(InputStream scriptStream) {
        return this.runBashScript(scriptStream, new ArgumentListBuilder());
    }

    private int runBashScript(InputStream scriptStream, ArgumentListBuilder builder) {
        try {
            int ret;
            if (SystemUtils.IS_OS_WINDOWS) {
                String command = "bash -xe -s - " + builder.toString();
                ret = this.runCommand(scriptStream, "cmd.exe", "/C", command);
            } else {
                builder.prepend(new String[]{"bash", "-xe", "-s", "-"});
                ret = this.runCommand(scriptStream, builder);
            }
            scriptStream.close();
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace(this.logger);
            return 1;
        }
    }

    private class Builder
    extends ArgumentListBuilder {
        public Builder(String ... arguments) {
            super(new String[]{AutifyCli.this.autifyPath});
            this.add(arguments);
        }

        public Builder addFlag(String flag, String value) {
            if (StringUtils.isNotBlank((String)value)) {
                this.add(new String[]{flag, value});
            }
            return this;
        }

        public Builder addFlag(String flag, boolean value) {
            if (value) {
                this.add(flag);
            }
            return this;
        }
    }
}

