/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.scanner;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.scanner.Region;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.ArtifactManager;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AppknoxScanner
extends Builder
implements SimpleBuildStep {
    private final String credentialsId;
    private final String filePath;
    private final String riskThreshold;
    private final String region;

    @DataBoundConstructor
    public AppknoxScanner(String credentialsId, String filePath, String riskThreshold, String region) {
        this.credentialsId = credentialsId;
        this.filePath = filePath;
        this.riskThreshold = riskThreshold;
        this.region = region;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getRiskThreshold() {
        return this.riskThreshold;
    }

    public String getRegion() {
        return this.region;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, AbortException {
        if (workspace == null) {
            listener.getLogger().println("Workspace is null.");
            return;
        }
        if (workspace.isRemote()) {
            listener.getLogger().println("Running on Agent...");
        } else {
            listener.getLogger().println("Running on Controller...");
        }
        String reportName = "summary-report.csv";
        boolean success = this.executeAppknoxCommands(run, workspace, reportName, launcher, listener);
        if (success) {
            this.archiveArtifact(run, workspace, reportName, launcher, listener);
        } else if (run != null) {
            run.setResult(Result.FAILURE);
        }
    }

    private boolean executeAppknoxCommands(Run<?, ?> run, FilePath workspace, String reportName, Launcher launcher, TaskListener listener) throws IOException, InterruptedException, AbortException {
        try {
            String reportOutput;
            String reportID;
            String accessToken = this.getAccessToken(listener);
            if (accessToken == null) {
                return false;
            }
            EnvVars env = new EnvVars();
            env.put("APPKNOX_ACCESS_TOKEN", accessToken);
            String appknoxPath = this.downloadAndInstallAppknox(workspace, listener, launcher);
            listener.getLogger().println("Selected Region: " + this.region);
            String appFilePath = this.findAppFilePath(workspace, this.filePath, listener);
            if (appFilePath == null) {
                listener.getLogger().println("Neither APK nor IPA file found in the expected directories.");
                return false;
            }
            String uploadOutput = this.uploadFile(appknoxPath, listener, env, appFilePath, launcher, workspace);
            String fileID = this.extractFileID(uploadOutput, listener);
            if (fileID == null) {
                return false;
            }
            boolean ciCheckSuccess = this.runCICheck(appknoxPath, run, fileID, listener, env, launcher, workspace);
            if (!ciCheckSuccess && run != null) {
                listener.getLogger().println("Vulnerabilities detected. Aborting the build process.");
                run.setResult(Result.FAILURE);
            }
            if ((reportID = this.extractReportID(reportOutput = this.createReport(appknoxPath, fileID, listener, env, launcher, workspace), listener)) == null) {
                return false;
            }
            this.downloadReportSummaryCSV(appknoxPath, reportName, reportID, run, workspace, listener, env, launcher);
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception e) {
            listener.error("Error executing Appknox commands: " + e.getMessage());
            if (run != null) {
                run.setResult(Result.FAILURE);
            }
            return false;
        }
        return true;
    }

    private String downloadAndInstallAppknox(FilePath workspace, TaskListener listener, Launcher launcher) throws IOException, InterruptedException {
        String osName = this.getOSName(launcher, listener);
        String appknoxURL = this.getAppknoxDownloadURL(osName);
        String binaryName = this.getBinaryName(osName);
        FilePath appknoxFile = workspace.child(binaryName);
        if (!appknoxFile.exists()) {
            listener.getLogger().println("Downloading Appknox CLI from: " + appknoxURL);
            this.downloadFile(appknoxURL, appknoxFile, listener);
            listener.getLogger().println("Appknox CLI downloaded successfully.");
        } else {
            listener.getLogger().println("Appknox CLI already exists at: " + appknoxFile.getRemote());
        }
        if (launcher.isUnix()) {
            appknoxFile.chmod(493);
        }
        listener.getLogger().println("Appknox CLI located at: " + appknoxFile.getRemote());
        return appknoxFile.getRemote();
    }

    private String getBinaryName(String os) {
        if (os.contains("win")) {
            return "appknox-Windows-x86_64.exe";
        }
        if (os.contains("mac")) {
            return "appknox-Darwin-x86_64";
        }
        if (os.contains("linux")) {
            return "appknox-Linux-x86_64";
        }
        throw new UnsupportedOperationException("Unsupported operating system for Appknox CLI download.");
    }

    private String getOSName(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        if (launcher.isUnix()) {
            Launcher.ProcStarter procStarter = launcher.launch();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            procStarter.cmds(new String[]{"uname", "-s"});
            procStarter.stdout((OutputStream)outputStream);
            procStarter.stderr((OutputStream)listener.getLogger());
            int exitCode = procStarter.join();
            if (exitCode == 0) {
                String osName = outputStream.toString("UTF-8").trim();
                listener.getLogger().println("Detected OS: " + osName);
                if (osName.equalsIgnoreCase("Darwin")) {
                    return "mac";
                }
                return "linux";
            }
            listener.getLogger().println("Failed to determine OS using 'uname -s', defaulting to 'linux'");
            return "linux";
        }
        return "win";
    }

    private void downloadFile(String url, FilePath destinationFile, TaskListener listener) throws IOException, InterruptedException {
        URL downloadUrl = new URL(url);
        try (InputStream in = downloadUrl.openStream();){
            destinationFile.copyFrom(in);
        }
    }

    private String getAppknoxDownloadURL(String os) {
        String binaryName;
        if (os.contains("win")) {
            binaryName = "appknox-Windows-x86_64.exe";
        } else if (os.contains("mac")) {
            binaryName = "appknox-Darwin-x86_64";
        } else if (os.contains("linux")) {
            binaryName = "appknox-Linux-x86_64";
        } else {
            throw new UnsupportedOperationException("Unsupported operating system for Appknox CLI download.");
        }
        return "https://github.com/appknox/appknox-go/releases/latest/download/" + binaryName;
    }

    private String findAppFilePath(FilePath workspace, String fileName, TaskListener listener) throws IOException, InterruptedException {
        boolean isApk = fileName.endsWith(".apk");
        boolean isIpa = fileName.endsWith(".ipa");
        ArrayList<String> possibleDirs = new ArrayList<String>();
        if (isApk) {
            possibleDirs.addAll(Arrays.asList("app/build/outputs/apk/", "app/build/outputs/apk/release/", "app/build/outputs/apk/debug/"));
        } else if (isIpa) {
            possibleDirs.addAll(Arrays.asList("Build/Products/", "Build/Products/Debug-iphoneos/", "Build/Products/Release-iphoneos/"));
        }
        for (String dir : possibleDirs) {
            FilePath appFile = workspace.child(dir).child(fileName);
            if (!appFile.exists() || appFile.isDirectory()) continue;
            listener.getLogger().println("File found at: " + appFile.getRemote());
            return appFile.getRemote();
        }
        String buildDir = isApk ? "app/build" : "Build";
        FilePath buildDirPath = workspace.child(buildDir);
        String result = this.findAppFilePathRecursive(buildDirPath, fileName, listener);
        if (result != null) {
            listener.getLogger().println("File found during recursive search at: " + result);
            return result;
        }
        FilePath customFile = workspace.child(fileName);
        if (customFile.exists() && !customFile.isDirectory()) {
            listener.getLogger().println("File found at specified path: " + customFile.getRemote());
            return customFile.getRemote();
        }
        if (new File(fileName).isAbsolute()) {
            listener.getLogger().println("File not found at specified absolute path: " + fileName);
            return null;
        }
        listener.getLogger().println("File not found in specified directories, through recursive search, or at the specified path.");
        return null;
    }

    private String findAppFilePathRecursive(FilePath dir, String fileName, TaskListener listener) throws IOException, InterruptedException {
        List files = dir.list();
        if (files != null) {
            for (FilePath file : files) {
                if (file.isDirectory()) {
                    String result = this.findAppFilePathRecursive(file, fileName, listener);
                    if (result == null) continue;
                    return result;
                }
                if (!file.getName().equals(fileName)) continue;
                listener.getLogger().println("File found during recursive search at: " + file.getRemote());
                return file.getRemote();
            }
        }
        return null;
    }

    private String uploadFile(String appknoxPath, TaskListener listener, EnvVars env, String appFilePath, Launcher launcher, FilePath workspace) throws IOException, InterruptedException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(appknoxPath);
        command.add("upload");
        command.add(appFilePath);
        command.add("--region");
        command.add(this.region);
        ArgumentListBuilder args = new ArgumentListBuilder(command.toArray(new String[0]));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Proc proc = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)outputStream).pwd(workspace).quiet(true).start();
        int exitCode = proc.join();
        if (exitCode != 0) {
            listener.getLogger().println("Upload failed with exit code: " + exitCode);
            return null;
        }
        String output = outputStream.toString("UTF-8").trim();
        String fileID = this.extractFileID(output, listener);
        if (fileID == null) {
            return null;
        }
        listener.getLogger().println("Upload Command Output:");
        listener.getLogger().println("File ID = " + fileID);
        String fileUrl = Region.fromValue(this.region).getBaseUrl() + "dashboard/file/" + fileID;
        listener.getLogger().println("File URL = " + fileUrl);
        return fileID;
    }

    private boolean runCICheck(String appknoxPath, Run<?, ?> run, String fileID, TaskListener listener, EnvVars env, Launcher launcher, FilePath workspace) throws IOException, InterruptedException, AbortException {
        String line;
        ArrayList<String> command = new ArrayList<String>();
        command.add(appknoxPath);
        command.add("cicheck");
        command.add(fileID);
        command.add("--risk-threshold");
        command.add(this.riskThreshold);
        command.add("--region");
        command.add(this.region);
        ArgumentListBuilder args = new ArgumentListBuilder(command.toArray(new String[0]));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Proc proc = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)outputStream).pwd(workspace).quiet(true).start();
        int exitCode = proc.join();
        String output = outputStream.toString("UTF-8").trim();
        listener.getLogger().println("Ci Check Output:");
        BufferedReader reader = new BufferedReader(new StringReader(output));
        StringBuilder outputBuilder = new StringBuilder();
        boolean foundStarted = false;
        while ((line = reader.readLine()) != null) {
            if (!foundStarted) {
                if (!line.contains("Found") && !line.contains("No")) continue;
                outputBuilder.append(line).append("\n");
                if (run != null) {
                    run.setDescription(outputBuilder.toString() + " Check Console Output for more details.");
                }
                listener.getLogger().println();
                foundStarted = true;
                continue;
            }
            outputBuilder.append(line).append("\n");
        }
        if (!foundStarted) {
            listener.getLogger().println("No line with 'Found' or 'No' encountered in the output.");
            return false;
        }
        String finalOutput = outputBuilder.toString().trim();
        listener.getLogger().println(finalOutput);
        if (exitCode != 0) {
            if (run != null) {
                run.setResult(Result.FAILURE);
                throw new AbortException("Vulnerabilities detected. Failing the build.");
            }
            return false;
        }
        return true;
    }

    private String createReport(String appknoxPath, String fileID, TaskListener listener, EnvVars env, Launcher launcher, FilePath workspace) throws IOException, InterruptedException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(appknoxPath);
        command.add("reports");
        command.add("create");
        command.add(fileID);
        command.add("--region");
        command.add(this.region);
        ArgumentListBuilder args = new ArgumentListBuilder(command.toArray(new String[0]));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Proc proc = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)outputStream).pwd(workspace).quiet(true).start();
        int exitCode = proc.join();
        String output = outputStream.toString("UTF-8").trim();
        String reportID = this.extractReportID(output, listener);
        if (reportID != null) {
            listener.getLogger().println("Create Report Command Output:");
            listener.getLogger().println("Report Id = " + reportID);
            listener.getLogger().println();
        } else {
            listener.getLogger().println("Failed to create report. Output: " + output);
        }
        if (exitCode != 0) {
            listener.getLogger().println("Report Creation failed with exit code: " + exitCode);
            return null;
        }
        return reportID;
    }

    private void downloadReportSummaryCSV(String appknoxPath, String reportName, String reportID, Run<?, ?> run, FilePath workspace, TaskListener listener, EnvVars env, Launcher launcher) throws IOException, InterruptedException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(appknoxPath);
        command.add("reports");
        command.add("download");
        command.add("summary-csv");
        command.add(reportID);
        command.add("--output");
        command.add(workspace.child(reportName).getRemote());
        command.add("--region");
        command.add(this.region);
        ArgumentListBuilder args = new ArgumentListBuilder(command.toArray(new String[0]));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Proc proc = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)outputStream).pwd(workspace).quiet(true).start();
        int exitCode = proc.join();
        if (exitCode != 0) {
            listener.getLogger().println("Download CSV failed. Exit code: " + exitCode);
        } else {
            listener.getLogger().println("Summary report saved at: " + workspace.child(reportName).getRemote());
        }
    }

    private void archiveArtifact(Run<?, ?> run, FilePath workspace, String reportName, Launcher launcher, TaskListener listener) {
        try {
            FilePath artifactFile = workspace.child(reportName);
            if (!artifactFile.exists()) {
                listener.error("Artifact file does not exist: " + artifactFile.getRemote());
                return;
            }
            ArtifactManager artifactManager = run.getArtifactManager();
            HashMap<String, String> artifacts = new HashMap<String, String>();
            artifacts.put(reportName, artifactFile.getName());
            artifactManager.archive(workspace, launcher, (BuildListener)listener, artifacts);
            listener.getLogger().println("Artifact archived: " + artifactFile.getRemote());
        }
        catch (IOException | InterruptedException e) {
            listener.error("Error archiving artifact: " + e.getMessage());
            e.printStackTrace(listener.getLogger());
        }
    }

    private String getAccessToken(TaskListener listener) {
        Jenkins jenkins = Jenkins.get();
        StringCredentials credentials = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)jenkins, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.create().build()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
        if (credentials != null) {
            return credentials.getSecret().getPlainText();
        }
        listener.getLogger().println("Failed to retrieve access token from credentials.");
        return null;
    }

    private String extractFileID(String uploadOutput, TaskListener listener) {
        String[] lines = uploadOutput.split("\\r?\\n");
        for (int i = lines.length - 1; i >= 0; --i) {
            String line = lines[i].trim();
            if (!line.matches("\\d+")) continue;
            return line;
        }
        listener.getLogger().println("Could not extract file ID from upload output.");
        return null;
    }

    private String extractReportID(String createReportOutput, TaskListener listener) {
        if (createReportOutput != null && !createReportOutput.isEmpty()) {
            return createReportOutput.trim();
        }
        listener.getLogger().println("Report output does not contain any lines.");
        return null;
    }

    @Extension
    @Symbol(value={"appKnoxScanner"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            super(AppknoxScanner.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Appknox Security Scanner";
        }

        @POST
        public ListBoxModel doFillRegionItems() {
            ListBoxModel items = new ListBoxModel();
            for (Region region : Region.values()) {
                items.add((Object)new ListBoxModel.Option(region.getDisplayName(), region.getValue()));
            }
            return items;
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup<?> context) {
            if (context == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                ((AccessControlled)context).checkPermission(Item.CONFIGURE);
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, context, StringCredentials.class, URIRequirementBuilder.fromUri((String)"").build(), CredentialsMatchers.instanceOf(StringCredentials.class));
        }

        @POST
        public FormValidation doCheckCredentialsId(@QueryParameter String value) {
            Jenkins.get().checkPermission(Item.CONFIGURE);
            if (value.isEmpty()) {
                return FormValidation.error((String)"Appknox Access Token must be selected");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckFilePath(@QueryParameter String value) {
            Jenkins.get().checkPermission(Item.CONFIGURE);
            if (value.isEmpty()) {
                return FormValidation.error((String)"File Path must not be empty");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckRiskThreshold(@QueryParameter String value) {
            Jenkins.get().checkPermission(Item.CONFIGURE);
            if (value.isEmpty() || !value.equals("LOW") && !value.equals("MEDIUM") && !value.equals("HIGH") && !value.equals("CRITICAL")) {
                return FormValidation.error((String)"Risk Threshold must be one of: LOW, MEDIUM, HIGH, CRITICAL");
            }
            return FormValidation.ok();
        }
    }
}

