/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.inspector.jenkins.amazoninspectorbuildstep.sbomgen;

import com.amazon.inspector.jenkins.amazoninspectorbuildstep.AmazonInspectorBuilder;
import com.amazon.inspector.jenkins.amazoninspectorbuildstep.sbomgen.SbomgenUtils;
import com.google.common.annotations.VisibleForTesting;
import hudson.FilePath;
import hudson.Launcher;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class SbomgenRunner {
    public String sbomgenPath;
    public String archiveType;
    public String archivePath;
    public Launcher launcher;
    public FilePath workspace;
    public String dockerUsername;
    public String dockerPassword;
    private final String sbomgenSkipFiles;

    public SbomgenRunner(Launcher launcher, FilePath workspace, String sbomgenPath, String activeArchiveType, String archivePath, String dockerUsername, String dockerPassword, String sbomgenSkipFiles) {
        this.sbomgenPath = sbomgenPath;
        this.archivePath = archivePath;
        this.archiveType = activeArchiveType;
        this.dockerUsername = dockerUsername;
        this.dockerPassword = dockerPassword;
        this.launcher = launcher;
        this.workspace = workspace;
        this.sbomgenSkipFiles = sbomgenSkipFiles;
    }

    public String run() throws Exception {
        return this.runSbomgen(this.sbomgenPath, this.archivePath);
    }

    private String runSbomgen(String sbomgenPath, String archivePath) throws Exception {
        String[] patterns;
        List validPatterns;
        FilePath sbomgenFilePath = this.workspace.getChannel() != null ? new FilePath(this.workspace.getChannel(), sbomgenPath) : new FilePath(new File(sbomgenPath));
        if (!this.isValidPath(sbomgenFilePath.getRemote())) {
            throw new IllegalArgumentException("Invalid sbomgen path: " + sbomgenPath);
        }
        HashMap<String, String> environment = new HashMap<String, String>();
        if (this.dockerPassword != null && !this.dockerPassword.isEmpty()) {
            environment.put("INSPECTOR_SBOMGEN_USERNAME", this.dockerUsername);
            environment.put("INSPECTOR_SBOMGEN_PASSWORD", this.dockerPassword);
        }
        AmazonInspectorBuilder.logger.println("Making downloaded SBOMGen executable...");
        SbomgenUtils.runCommand(new String[]{"chmod", "+x", sbomgenFilePath.getRemote()}, this.launcher, environment);
        AmazonInspectorBuilder.logger.println("Running command...");
        String option = "--image";
        if (!this.archiveType.equals("container")) {
            option = "--path";
        }
        Object[] baseCommandList = new String[]{sbomgenFilePath.getRemote(), this.archiveType, option, archivePath};
        AmazonInspectorBuilder.logger.println(Arrays.toString(baseCommandList));
        if (this.sbomgenSkipFiles != null && !this.sbomgenSkipFiles.trim().isEmpty() && !(validPatterns = Arrays.stream(patterns = this.sbomgenSkipFiles.split("\\r?\\n")).map(String::trim).filter(p -> !p.isEmpty()).collect(Collectors.toList())).isEmpty()) {
            String skipFilesJoined = String.join((CharSequence)",", validPatterns);
            String[] extendedCommandList = (String[])Arrays.copyOf(baseCommandList, baseCommandList.length + 2);
            extendedCommandList[extendedCommandList.length - 2] = "--skip-files";
            extendedCommandList[extendedCommandList.length - 1] = skipFilesJoined;
            baseCommandList = extendedCommandList;
            AmazonInspectorBuilder.logger.println("DEBUG: --skip-files argument: " + skipFilesJoined);
            AmazonInspectorBuilder.logger.println(Arrays.toString(baseCommandList));
        }
        String output = SbomgenUtils.runCommand((String[])baseCommandList, this.launcher, environment);
        return SbomgenUtils.processSbomgenOutput(output);
    }

    @VisibleForTesting
    protected boolean isValidPath(String path) {
        String regex = "^[a-zA-Z0-9/._\\-: ]+$";
        return path.matches(regex);
    }

    @Generated
    public void setDockerUsername(String dockerUsername) {
        this.dockerUsername = dockerUsername;
    }

    @Generated
    public void setDockerPassword(String dockerPassword) {
        this.dockerPassword = dockerPassword;
    }
}

