/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.akeyless.cloudid;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jenkins.plugins.akeyless.cloudid.Utils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;

public class AwsCredentialResolver {
    public static AwsCredentials resolve() throws Exception {
        String accessKey = System.getenv("AWS_ACCESS_KEY_ID");
        String secretKey = System.getenv("AWS_SECRET_ACCESS_KEY");
        String sessionToken = System.getenv("AWS_SESSION_TOKEN");
        if (accessKey != null && secretKey != null) {
            return new AwsCredentials(accessKey, secretKey, sessionToken);
        }
        String relativeUri = System.getenv("AWS_CONTAINER_CREDENTIALS_RELATIVE_URI");
        if (relativeUri != null) {
            String ecsUrl = "http://169.254.170.2" + relativeUri;
            return AwsCredentialResolver.fetchCredentialsFromMetadataService(ecsUrl);
        }
        String token = AwsCredentialResolver.fetchImdsV2Token();
        String roleName = AwsCredentialResolver.httpGet("http://169.254.169.254/latest/meta-data/iam/security-credentials/", token);
        String credsJson = AwsCredentialResolver.httpGet("http://169.254.169.254/latest/meta-data/iam/security-credentials/" + roleName, token);
        Map json = (Map)new ObjectMapper().readValue(credsJson, Map.class);
        return new AwsCredentials((String)json.get("AccessKeyId"), (String)json.get("SecretAccessKey"), (String)json.get("Token"));
    }

    private static String fetchImdsV2Token() throws Exception {
        URL url = new URL("http://169.254.169.254/latest/api/token");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(3000);
        conn.setReadTimeout(3000);
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("X-aws-ec2-metadata-token-ttl-seconds", "21600");
        if (conn.getResponseCode() != 200) {
            throw new RuntimeException("Failed to fetch IMDSv2 token");
        }
        BufferedReader br = null;
        try {
            String token;
            br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            String string = token = br.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read IMDSv2 token response", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String httpGet(String url, String imdsToken) throws Exception {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("GET");
            if (imdsToken != null) {
                conn.setRequestProperty("X-aws-ec2-metadata-token", imdsToken);
            }
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed to fetch metadata from " + url);
            }
            String string = Utils.readDataFromStream(conn.getInputStream()).toString();
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AwsCredentials fetchCredentialsFromMetadataService(String urlStr) throws Exception {
        URL url = new URL(urlStr);
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed to fetch ECS credentials from " + urlStr);
            }
            StringBuilder response = Utils.readDataFromStream(conn.getInputStream());
            Map json = (Map)new ObjectMapper().readValue(response.toString(), Map.class);
            AwsCredentials awsCredentials = new AwsCredentials((String)json.get("AccessKeyId"), (String)json.get("SecretAccessKey"), (String)json.get("Token"));
            return awsCredentials;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static class AwsCredentials {
        public final String accessKeyId;
        public final String secretAccessKey;
        public final String sessionToken;

        public AwsCredentials(String accessKeyId, String secretAccessKey, String sessionToken) {
            this.accessKeyId = accessKeyId;
            this.secretAccessKey = secretAccessKey;
            this.sessionToken = sessionToken;
        }
    }
}

