/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.akeyless.cloudid;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jenkins.plugins.akeyless.cloudid.AwsCredentialResolver;
import io.jenkins.plugins.akeyless.cloudid.CloudIdProvider;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AwsCloudIdProvider
implements CloudIdProvider {
    private static final String SERVICE = "sts";
    private static final String REGION = "us-east-1";
    private static final String ENDPOINT = "https://sts.amazonaws.com/";

    @Override
    public String getCloudId() throws Exception {
        AwsCredentialResolver.AwsCredentials creds = AwsCredentialResolver.resolve();
        if (creds.accessKeyId == null || creds.secretAccessKey == null) {
            throw new IllegalStateException("Missing AWS credentials");
        }
        String body = "Action=GetCallerIdentity&Version=2011-06-15";
        byte[] bodyBytes = body.getBytes(StandardCharsets.UTF_8);
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        String amzDate = now.format(DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'"));
        String dateStamp = now.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String host = URI.create(ENDPOINT).getHost();
        String contentSha256 = AwsCloudIdProvider.toHex(AwsCloudIdProvider.hash(bodyBytes));
        LinkedHashMap<String, List<Object>> headers = new LinkedHashMap<String, List<Object>>();
        headers.put("Content-Type", Collections.singletonList("application/x-www-form-urlencoded; charset=utf-8"));
        headers.put("Host", Collections.singletonList(host));
        headers.put("X-Amz-Date", Collections.singletonList(amzDate));
        if (creds.sessionToken != null) {
            headers.put("X-Amz-Security-Token", Collections.singletonList(creds.sessionToken));
        }
        StringBuilder canonicalHeaders = new StringBuilder();
        ArrayList<String> signedHeadersList = new ArrayList<String>();
        for (Map.Entry entry : headers.entrySet()) {
            String headerValue = (String)((List)entry.getValue()).get(0);
            canonicalHeaders.append(((String)entry.getKey()).toLowerCase()).append(":").append(headerValue.trim()).append("\n");
            signedHeadersList.add(((String)entry.getKey()).toLowerCase());
        }
        String signedHeaders = String.join((CharSequence)";", signedHeadersList);
        String canonicalRequest = "POST\n/\n\n" + canonicalHeaders + "\n" + signedHeaders + "\n" + contentSha256;
        String algorithm = "AWS4-HMAC-SHA256";
        String credentialScope = dateStamp + "/us-east-1/sts/aws4_request";
        String stringToSign = algorithm + "\n" + amzDate + "\n" + credentialScope + "\n" + AwsCloudIdProvider.toHex(AwsCloudIdProvider.hash(canonicalRequest.getBytes(StandardCharsets.UTF_8)));
        byte[] signingKey = AwsCloudIdProvider.getSignatureKey(creds.secretAccessKey, dateStamp, REGION, SERVICE);
        byte[] signature = AwsCloudIdProvider.hmacSHA256(signingKey, stringToSign);
        String signatureHex = AwsCloudIdProvider.toHex(signature);
        String authorizationHeader = algorithm + " Credential=" + creds.accessKeyId + "/" + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signatureHex;
        headers.put("Authorization", Collections.singletonList(authorizationHeader));
        ObjectMapper mapper = new ObjectMapper();
        String headersJson = mapper.writeValueAsString(headers);
        LinkedHashMap<String, String> awsData = new LinkedHashMap<String, String>();
        awsData.put("sts_request_method", "POST");
        awsData.put("sts_request_url", Base64.getEncoder().encodeToString(ENDPOINT.getBytes(StandardCharsets.UTF_8)));
        awsData.put("sts_request_body", Base64.getEncoder().encodeToString(bodyBytes));
        awsData.put("sts_request_headers", Base64.getEncoder().encodeToString(headersJson.getBytes(StandardCharsets.UTF_8)));
        String awsDataJson = mapper.writeValueAsString(awsData);
        return Base64.getEncoder().encodeToString(awsDataJson.getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] hmacSHA256(byte[] key, String data) throws Exception {
        String algorithm = "HmacSHA256";
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(key, algorithm));
        return mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] getSignatureKey(String secretKey, String date, String region, String service) throws Exception {
        byte[] kSecret = ("AWS4" + secretKey).getBytes(StandardCharsets.UTF_8);
        byte[] kDate = AwsCloudIdProvider.hmacSHA256(kSecret, date);
        byte[] kRegion = AwsCloudIdProvider.hmacSHA256(kDate, region);
        byte[] kService = AwsCloudIdProvider.hmacSHA256(kRegion, service);
        return AwsCloudIdProvider.hmacSHA256(kService, "aws4_request");
    }

    private static byte[] hash(byte[] data) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        return md.digest(data);
    }

    private static String toHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            hex.append(String.format("%02x", b));
        }
        return hex.toString();
    }
}

