/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.akeyless;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.console.ConsoleLogFilter;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import io.jenkins.plugins.akeyless.AkeylessAccessor;
import io.jenkins.plugins.akeyless.MaskSecretsLogsFilter;
import io.jenkins.plugins.akeyless.configuration.AkeylessConfiguration;
import io.jenkins.plugins.akeyless.model.AkeylessPKIIssuer;
import io.jenkins.plugins.akeyless.model.AkeylessSSHIssuer;
import io.jenkins.plugins.akeyless.model.AkeylessSecret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.GeneralNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AkeylessBindingStep
extends Step {
    private AkeylessConfiguration configuration;
    private List<AkeylessSecret> akeylessSecrets;
    private List<AkeylessPKIIssuer> akeylessPKIIssuers;
    private List<AkeylessSSHIssuer> akeylessSSHIssuers;

    @DataBoundConstructor
    public AkeylessBindingStep(@CheckForNull List<AkeylessSecret> akeylessSecrets, @CheckForNull List<AkeylessPKIIssuer> akeylessPKIIssuers, @CheckForNull List<AkeylessSSHIssuer> akeylessSSHIssuers) {
        this.akeylessSecrets = akeylessSecrets;
        this.akeylessPKIIssuers = akeylessPKIIssuers;
        this.akeylessSSHIssuers = akeylessSSHIssuers;
    }

    public List<AkeylessSecret> getAkeylessSecrets() {
        return this.akeylessSecrets;
    }

    public List<AkeylessPKIIssuer> getAkeylessPKIIssuers() {
        return this.akeylessPKIIssuers;
    }

    public List<AkeylessSSHIssuer> getAkeylessSSHIssuers() {
        return this.akeylessSSHIssuers;
    }

    @DataBoundSetter
    public void setConfiguration(AkeylessConfiguration configuration) {
        this.configuration = configuration;
    }

    public AkeylessConfiguration getConfiguration() {
        return this.configuration;
    }

    @DataBoundSetter
    public void setAkeylessSecrets(List<AkeylessSecret> akeylessSecrets) {
        this.akeylessSecrets = akeylessSecrets;
    }

    @DataBoundSetter
    public void setAkeylessPKIIssuers(List<AkeylessPKIIssuer> akeylessPKIIssuers) {
        this.akeylessPKIIssuers = akeylessPKIIssuers;
    }

    @DataBoundSetter
    public void setAkeylessSSHIssuers(List<AkeylessSSHIssuer> akeylessSSHIssuers) {
        this.akeylessSSHIssuers = akeylessSSHIssuers;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    protected static class Execution
    extends GeneralNonBlockingStepExecution {
        private static final long serialVersionUID = 1L;
        private transient AkeylessBindingStep step;
        private transient AkeylessAccessor akeylessAccessor;

        public Execution(AkeylessBindingStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        @VisibleForTesting
        public void setAkeylessAccessor(AkeylessAccessor akeylessAccessor) {
            this.akeylessAccessor = akeylessAccessor;
        }

        public boolean start() throws Exception {
            this.run(this::doStart);
            return false;
        }

        private void doStart() throws Exception {
            Run run = (Run)this.getContext().get(Run.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
            Map<String, String> overrides = AkeylessAccessor.retrieveSecrets(run, listener.getLogger(), envVars, this.akeylessAccessor, this.step.getConfiguration(), this.step.getAkeylessSecrets(), this.step.getAkeylessPKIIssuers(), this.step.getAkeylessSSHIssuers());
            ArrayList<String> secretValues = new ArrayList<String>();
            secretValues.addAll(overrides.values());
            this.getContext().newBodyInvoker().withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new Overrider(overrides))).withContext((Object)BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)((ConsoleLogFilter)this.getContext().get(ConsoleLogFilter.class)), (ConsoleLogFilter)new MaskSecretsLogsFilter(run.getCharset().name(), secretValues))).withCallback((BodyExecutionCallback)new Callback()).start();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(TaskListener.class, Run.class, EnvVars.class)));
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public String getFunctionName() {
            return "withAkeyless";
        }

        @NonNull
        public String getDisplayName() {
            return "Akeyless Plugin";
        }
    }

    private static class Callback
    extends BodyExecutionCallback.TailCall {
        private Callback() {
        }

        protected void finished(StepContext context) throws Exception {
        }
    }

    private static final class Overrider
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final Map<String, Secret> overrides = new HashMap<String, Secret>();

        Overrider(Map<String, String> overrides) {
            for (Map.Entry<String, String> override : overrides.entrySet()) {
                this.overrides.put(override.getKey(), Secret.fromString((String)override.getValue()));
            }
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            for (Map.Entry<String, Secret> override : this.overrides.entrySet()) {
                env.override(override.getKey(), override.getValue().getPlainText());
            }
        }

        public Set<String> getSensitiveVariables() {
            return Collections.unmodifiableSet(this.overrides.keySet());
        }
    }
}

