/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.akeyless;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsUnavailableException;
import com.cloudbees.plugins.credentials.matchers.IdMatcher;
import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import hudson.EnvVars;
import hudson.ExtensionList;
import hudson.model.Run;
import hudson.security.ACL;
import io.akeyless.client.ApiClient;
import io.akeyless.client.ApiException;
import io.akeyless.client.Configuration;
import io.akeyless.client.api.V2Api;
import io.akeyless.client.model.Auth;
import io.akeyless.client.model.DescribeItem;
import io.akeyless.client.model.GetCertificateValue;
import io.akeyless.client.model.GetCertificateValueOutput;
import io.akeyless.client.model.GetDynamicSecretValue;
import io.akeyless.client.model.GetPKICertificate;
import io.akeyless.client.model.GetPKICertificateOutput;
import io.akeyless.client.model.GetRotatedSecretValue;
import io.akeyless.client.model.GetSSHCertificate;
import io.akeyless.client.model.GetSSHCertificateOutput;
import io.akeyless.client.model.GetSecretValue;
import io.akeyless.client.model.Item;
import io.jenkins.plugins.akeyless.AkeylessPluginException;
import io.jenkins.plugins.akeyless.cloudid.CloudIdProvider;
import io.jenkins.plugins.akeyless.cloudid.CloudProviderFactory;
import io.jenkins.plugins.akeyless.configuration.AkeylessConfigResolver;
import io.jenkins.plugins.akeyless.configuration.AkeylessConfiguration;
import io.jenkins.plugins.akeyless.credentials.AkeylessCredential;
import io.jenkins.plugins.akeyless.credentials.CredentialsPayload;
import io.jenkins.plugins.akeyless.model.AkeylessPKIIssuer;
import io.jenkins.plugins.akeyless.model.AkeylessSSHIssuer;
import io.jenkins.plugins.akeyless.model.AkeylessSecret;
import io.jenkins.plugins.akeyless.model.AkeylessSecretBase;
import io.jenkins.plugins.akeyless.model.AkeylessSecretValue;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class AkeylessAccessor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient V2Api api;
    private final AkeylessCredential credential;
    public static final String DATA_KEY = "data";
    private static final Gson gson = new Gson();

    public AkeylessAccessor(V2Api api, AkeylessCredential credential) {
        this.api = api;
        this.credential = credential;
    }

    public V2Api getApi() {
        return this.api;
    }

    public static Map<String, String> retrieveSecrets(Run<?, ?> run, PrintStream logger, EnvVars envVars, AkeylessAccessor accessor, AkeylessConfiguration configuration, List<AkeylessSecret> akeylessSecrets, List<AkeylessPKIIssuer> akeylessPKIIssuers, List<AkeylessSSHIssuer> akeylessSSHIssuers) {
        HashMap<String, String> secrets = new HashMap<String, String>();
        AkeylessConfiguration config = AkeylessAccessor.pullAndMergeConfiguration(run, configuration);
        String url = config.getAkeylessUrl();
        if (StringUtils.isBlank((String)url)) {
            throw new AkeylessPluginException("The Akeyless url was not configured - please specify the Akeyless url to use.");
        }
        AkeylessCredential credential = config.getAkeylessCredential();
        if (credential == null) {
            credential = AkeylessAccessor.retrieveAkeylessCredentials(run, config);
        }
        if (credential == null) {
            throw new AkeylessPluginException("Failed to retrieve Akeyless credential");
        }
        ApiClient client = Configuration.getDefaultApiClient();
        client.setBasePath(url);
        client.setVerifyingSsl(config.getSkipSslVerification() == false);
        client.setConnectTimeout(config.getTimeout().intValue());
        V2Api api = new V2Api(client);
        accessor = new AkeylessAccessor(api, credential);
        CredentialsPayload payload = credential.getCredentialsPayload();
        String token = payload.getToken() == null ? null : payload.getToken().getPlainText();
        try {
            if (token == null || token.isEmpty()) {
                Auth auth = payload.getAuth();
                if (payload.isCloudIdNeeded()) {
                    CloudIdProvider idProvider = CloudProviderFactory.getCloudIdProvider(auth.getAccessType());
                    auth.setCloudId(idProvider.getCloudId());
                }
                token = api.auth(auth).getToken();
            }
        }
        catch (ApiException e) {
            throw new AkeylessPluginException("Authentication failed: " + e.getResponseBody(), e);
        }
        catch (Exception e) {
            throw new AkeylessPluginException("Authentication failed.", e);
        }
        AkeylessAccessor.fillObjectValues(logger, envVars, accessor, token, akeylessSecrets, secrets);
        AkeylessAccessor.fillObjectValues(logger, envVars, accessor, token, akeylessPKIIssuers, secrets);
        AkeylessAccessor.fillObjectValues(logger, envVars, accessor, token, akeylessSSHIssuers, secrets);
        return secrets;
    }

    public static void fillObjectValues(PrintStream logger, EnvVars envVars, AkeylessAccessor accessor, String token, List<? extends AkeylessSecretBase> akeylessSecrets, Map<String, String> secrets) {
        if (secrets == null) {
            throw new AkeylessPluginException("Akeyless secrets holder should be initialized.");
        }
        if (akeylessSecrets == null || akeylessSecrets.isEmpty()) {
            return;
        }
        for (AkeylessSecretBase akeylessSecretBase : akeylessSecrets) {
            String path = envVars.expand(akeylessSecretBase.getPath());
            logger.printf("Retrieving secret: %s%n", path);
            Map<String, Object> values = accessor.getSecret(token, akeylessSecretBase);
            Object tempVal = values.get(path);
            if (tempVal instanceof String) {
                tempVal = StringEscapeUtils.escapeJava((String)tempVal.toString());
                String newVal = "{\"data\": \"" + tempVal + "\"}";
                tempVal = gson.fromJson(JSONObject.fromObject((Object)newVal).toString(), LinkedTreeMap.class);
            }
            Map<String, Object> innerValues = AkeylessAccessor.fillDataValues((LinkedTreeMap)tempVal, values);
            for (AkeylessSecretValue value : akeylessSecretBase.getSecretValues()) {
                String key = value.getSecretKey();
                Object secret = innerValues.get(key);
                if (secret == null && value.getIsRequired()) {
                    throw new IllegalArgumentException("Required secret " + key + " at " + path + " is either null or empty. Please check the Secret name and type in Akeyless.");
                }
                if (secret == null) continue;
                secrets.put(value.getEnvVar(), secret.toString());
            }
            logger.printf("Retrieving secret: %s -- SUCCESS.%n", path);
        }
    }

    private static Map<String, Object> fillDataValues(LinkedTreeMap innerValues, Map<String, Object> values) {
        if (innerValues == null && (innerValues = (LinkedTreeMap)values.get("value")) == null) {
            innerValues = new LinkedTreeMap();
            innerValues.putAll(values);
        }
        if (innerValues.get((Object)DATA_KEY) == null) {
            innerValues.put((Object)DATA_KEY, (Object)JSONObject.fromObject((Object)innerValues).toString());
        }
        return innerValues;
    }

    public static AkeylessCredential retrieveAkeylessCredentials(Run build, AkeylessConfiguration config) {
        if (Jenkins.getInstanceOrNull() != null) {
            String id = config.getAkeylessCredentialId();
            if (StringUtils.isEmpty((String)id)) {
                throw new AkeylessPluginException("The credential id was not configured - please specify the credentials to use.");
            }
            List credentials = CredentialsProvider.lookupCredentials(AkeylessCredential.class, (hudson.model.Item)build.getParent(), (Authentication)ACL.SYSTEM, Collections.emptyList());
            AkeylessCredential credential = (AkeylessCredential)CredentialsMatchers.firstOrNull((Iterable)credentials, (CredentialsMatcher)new IdMatcher(id));
            if (credential == null) {
                throw new CredentialsUnavailableException(id);
            }
            return credential;
        }
        return null;
    }

    public static AkeylessConfiguration pullAndMergeConfiguration(Run<?, ?> build, AkeylessConfiguration buildConfiguration) {
        AkeylessConfiguration configuration = buildConfiguration;
        for (AkeylessConfigResolver resolver : ExtensionList.lookup(AkeylessConfigResolver.class)) {
            if (configuration != null) {
                configuration = configuration.mergeWithParent(resolver.forJob((hudson.model.Item)build.getParent()));
                continue;
            }
            configuration = resolver.forJob((hudson.model.Item)build.getParent());
        }
        if (configuration == null) {
            throw new AkeylessPluginException("No configuration found - please configure the Akeyless Plugin.");
        }
        return configuration;
    }

    public Map<String, Object> getSecret(String token, AkeylessSecretBase akeylessSecret) {
        DescribeItem describeItem = new DescribeItem();
        describeItem.setToken(token);
        describeItem.setName(akeylessSecret.getPath());
        String type = null;
        try {
            Item item = this.getApi().describeItem(describeItem);
            type = item.getItemType();
        }
        catch (ApiException e) {
            throw new AkeylessPluginException("Failed to describe item: " + e.getResponseBody(), e);
        }
        try {
            switch (type) {
                case "STATIC_SECRET": {
                    GetSecretValue body = new GetSecretValue();
                    body.setToken(token);
                    body.json(Boolean.valueOf(true));
                    List<String> paths = Collections.singletonList(akeylessSecret.getPath());
                    body.names(paths);
                    body.setPrettyPrint(Boolean.valueOf(true));
                    return this.getApi().getSecretValue(body);
                }
                case "DYNAMIC_SECRET": {
                    GetDynamicSecretValue dbody = new GetDynamicSecretValue();
                    dbody.setToken(token);
                    dbody.json(Boolean.valueOf(true));
                    dbody.setName(akeylessSecret.getPath());
                    return this.getApi().getDynamicSecretValue(dbody);
                }
                case "ROTATED_SECRET": {
                    GetRotatedSecretValue rbody = new GetRotatedSecretValue();
                    rbody.setToken(token);
                    rbody.json(Boolean.valueOf(true));
                    rbody.setNames(akeylessSecret.getPath());
                    return this.getApi().getRotatedSecretValue(rbody);
                }
                case "CERTIFICATE": {
                    GetCertificateValue cbody = new GetCertificateValue();
                    cbody.setToken(token);
                    cbody.json(Boolean.valueOf(true));
                    cbody.setName(akeylessSecret.getPath());
                    GetCertificateValueOutput out = this.getApi().getCertificateValue(cbody);
                    return (Map)gson.fromJson(JSONObject.fromObject((Object)out).toString(), LinkedTreeMap.class);
                }
                case "SSH_CERT_ISSUER": {
                    GetSSHCertificate sshCertificate = this.getSSHCertificateBody(token, (AkeylessSSHIssuer)akeylessSecret);
                    GetSSHCertificateOutput sshout = this.getApi().getSSHCertificate(sshCertificate);
                    LinkedTreeMap forJson = new LinkedTreeMap();
                    forJson.put(DATA_KEY, sshout.getData());
                    return (Map)gson.fromJson(JSONObject.fromObject((Object)forJson).toString(), LinkedTreeMap.class);
                }
                case "PKI_CERT_ISSUER": {
                    GetPKICertificate pkiCertificate = this.getPKICertificateBody(token, (AkeylessPKIIssuer)akeylessSecret);
                    GetPKICertificateOutput pki = this.getApi().getPKICertificate(pkiCertificate);
                    LinkedTreeMap forJson = new LinkedTreeMap();
                    forJson.put(DATA_KEY, pki.getData());
                    return (Map)gson.fromJson(JSONObject.fromObject((Object)forJson).toString(), LinkedTreeMap.class);
                }
            }
            throw new AkeylessPluginException("Wrong or not supported item type: " + type);
        }
        catch (ApiException e) {
            throw new AkeylessPluginException("Failed to retrieve secret: " + e.getResponseBody(), e);
        }
    }

    @Nonnull
    private GetSSHCertificate getSSHCertificateBody(String token, AkeylessSSHIssuer sshIssuer) {
        GetSSHCertificate sshCertificate = new GetSSHCertificate();
        sshCertificate.setToken(token);
        sshCertificate.setJson(Boolean.valueOf(true));
        sshCertificate.setCertIssuerName(sshIssuer.getPath());
        sshCertificate.setPublicKeyData(sshIssuer.getPublicKey());
        sshCertificate.setCertUsername(sshIssuer.getCertUserName());
        sshCertificate.setTtl(Long.valueOf(sshIssuer.getTtl()));
        return sshCertificate;
    }

    @Nonnull
    private GetPKICertificate getPKICertificateBody(String token, AkeylessPKIIssuer pkiIssuer) {
        GetPKICertificate pkiCertificate = new GetPKICertificate();
        pkiCertificate.certIssuerName(pkiIssuer.getPath());
        pkiCertificate.setToken(token);
        pkiCertificate.setTtl(Long.toString(pkiIssuer.getTtl()));
        pkiCertificate.setJson(Boolean.valueOf(true));
        pkiCertificate.setCsrDataBase64(pkiIssuer.getCsrBase64());
        pkiCertificate.setKeyDataBase64(Base64.getEncoder().encodeToString(pkiIssuer.getPublicKey().getBytes(StandardCharsets.UTF_8)));
        return pkiCertificate;
    }
}

