/*
 * Decompiled with CFR 0.152.
 */
package com.xliic.ci.jenkins;

import com.xliic.ci.jenkins.Finder;
import com.xliic.ci.jenkins.LoggerImpl;
import com.xliic.cicd.audit.AuditResults;
import com.xliic.cicd.audit.Auditor;
import com.xliic.cicd.audit.Secret;
import com.xliic.cicd.audit.SharingType;
import com.xliic.cicd.common.Logger;
import com.xliic.cicd.common.OpenApiFinder;
import com.xliic.cicd.common.Reference;
import com.xliic.cicd.common.TaskException;
import com.xliic.cicd.common.Util;
import com.xliic.cicd.common.WritableWorkspace;
import com.xliic.common.ContentType;
import com.xliic.common.Workspace;
import com.xliic.common.WorkspaceContent;
import com.xliic.common.WorkspaceException;
import hudson.AbortException;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.TaskListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import jenkins.security.MasterToSlaveCallable;

public class RemoteAuditTask
extends MasterToSlaveCallable<Void, AbortException> {
    private TaskListener listener;
    private FilePath workspace;
    private String logLevel;
    private Secret apiKey;
    private String platformUrl;
    private String shareEveryone;
    private int minScore;
    private ProxyConfiguration proxyConfiguration;
    private String actualRepositoryName;
    private String actualBranchName;
    private String actualTagName;
    private String actualPrId;
    private String actualPrTargetBranch;
    private String defaultCollectionName;
    private String jsonReport;
    private String apiTags;
    private String rootDirectory;
    private boolean skipLocalChecks;
    private boolean ignoreNetworkErrors;
    private boolean ignoreFailures;

    RemoteAuditTask(FilePath workspace, TaskListener listener, Secret apiKey, String platformUrl, String logLevel, String defaultCollectionName, String rootDirectory, String jsonReport, String apiTags, boolean skipLocalChecks, boolean ignoreNetworkErrors, boolean ignoreFailures, String shareEveryone, int minScore, ProxyConfiguration proxyConfiguration, String actualRepositoryName, String actualBranchName, String actualTagName, String actualPrId, String actualPrTargetBranch) {
        this.listener = listener;
        this.workspace = workspace;
        this.logLevel = logLevel;
        this.apiKey = apiKey;
        this.platformUrl = platformUrl;
        this.shareEveryone = shareEveryone;
        this.minScore = minScore;
        this.proxyConfiguration = proxyConfiguration;
        this.actualRepositoryName = actualRepositoryName;
        this.actualBranchName = actualBranchName;
        this.actualTagName = actualTagName;
        this.actualPrId = actualPrId;
        this.actualPrTargetBranch = actualPrTargetBranch;
        this.defaultCollectionName = defaultCollectionName;
        this.rootDirectory = rootDirectory;
        this.jsonReport = jsonReport;
        this.apiTags = apiTags;
        this.skipLocalChecks = skipLocalChecks;
        this.ignoreFailures = ignoreFailures;
        this.ignoreNetworkErrors = ignoreNetworkErrors;
    }

    public Void call() throws AbortException {
        Reference reference;
        if (this.rootDirectory != null && !this.rootDirectory.equals("")) {
            this.workspace = new FilePath(this.workspace, this.rootDirectory);
        }
        WorkspaceImpl auditWorkspace = new WorkspaceImpl(this.workspace);
        Finder finder = new Finder(this.workspace);
        LoggerImpl logger = new LoggerImpl(this.listener.getLogger(), this.logLevel);
        Auditor auditor = new Auditor((OpenApiFinder)finder, (Logger)logger, this.apiKey, this.platformUrl, "Jenkins-CICD/2.0", "jenkins");
        auditor.setWriteJsonReportTo(this.jsonReport);
        try {
            auditor.setApiTags(this.apiTags);
        }
        catch (TaskException ex) {
            throw new AbortException(ex.getMessage());
        }
        auditor.setSkipLocalChecks(this.skipLocalChecks);
        auditor.setMinScore(this.minScore);
        if (this.defaultCollectionName != null && !this.defaultCollectionName.equals("")) {
            auditor.setDefaultCollectionName(this.defaultCollectionName);
        }
        if (this.shareEveryone.equals("READ_ONLY")) {
            auditor.setShareEveryone(SharingType.READ_ONLY);
        } else if (this.shareEveryone.equals("READ_WRITE")) {
            auditor.setShareEveryone(SharingType.READ_WRITE);
        }
        if (this.proxyConfiguration != null) {
            auditor.setProxy(this.proxyConfiguration.name, this.proxyConfiguration.port);
        }
        if ((reference = this.getReference(this.actualBranchName, this.actualTagName, this.actualPrId, this.actualPrTargetBranch)) == null) {
            throw new AbortException("Unable to retrieve branch/tag name or PR id");
        }
        if (this.ignoreFailures) {
            logger.info("Ignoring security audit failures");
        }
        if (this.ignoreNetworkErrors) {
            logger.info("Ignoring network errors");
        }
        try {
            AuditResults results = auditor.audit((WritableWorkspace)auditWorkspace, this.actualRepositoryName, reference);
            this.displayReport(results, logger, (Workspace)auditWorkspace);
            this.listener.getLogger().flush();
            if (!this.ignoreFailures && !results.ignoreFailures) {
                if (results.failures > 0) {
                    throw new AbortException(String.format("Detected %d failure(s) in the %d OpenAPI file(s) checked", results.failures, results.summary.size()));
                }
                if (results.summary.size() == 0) {
                    throw new AbortException("No OpenAPI files found.");
                }
            }
        }
        catch (TaskException ex) {
            if (this.ignoreNetworkErrors && ex.isNetworkError()) {
                logger.error(ex.getMessage());
            }
            ex.printStackTrace();
            throw new AbortException(ex.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AbortException(e.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new AbortException(e.getMessage());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new AbortException(e.getMessage());
        }
        catch (WorkspaceException e) {
            e.printStackTrace();
            throw new AbortException(e.getMessage());
        }
        return null;
    }

    private Reference getReference(String branch, String tag, String prId, String prTargetBranch) {
        if (branch != null) {
            return Reference.branch((String)branch);
        }
        if (tag != null) {
            return Reference.tag((String)tag);
        }
        if (prId != null && prTargetBranch != null) {
            return Reference.pr((String)prId, (String)prTargetBranch);
        }
        return null;
    }

    private void displayReport(AuditResults results, Logger logger, Workspace workspace) {
        results.summary.forEach((file, summary) -> {
            logger.error(String.format("Audited %s, the API score is %d", workspace.relativize(file).getPath(), summary.score));
            if (summary.failures.length > 0) {
                for (String failure : summary.failures) {
                    logger.error("    " + failure);
                }
            } else {
                logger.error("    No blocking issues found.");
            }
            if (summary.reportUrl != null) {
                logger.error("    Details:");
                logger.error(String.format("    %s", summary.reportUrl));
            }
            logger.error("");
        });
    }

    static class WorkspaceImpl
    implements WritableWorkspace {
        private FilePath workspace;

        WorkspaceImpl(FilePath workspace) {
            this.workspace = workspace;
        }

        public WorkspaceContent read(URI uri) throws IOException, InterruptedException {
            int read;
            FilePath filepath = new FilePath(this.workspace, uri.getPath());
            InputStream is = filepath.read();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((read = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, read);
            }
            buffer.flush();
            String contentData = new String(buffer.toByteArray(), StandardCharsets.UTF_8);
            boolean isYaml = Util.isYaml((String)uri.getPath());
            return new WorkspaceContent(contentData, isYaml ? ContentType.YAML : ContentType.JSON);
        }

        public void write(URI uri, WorkspaceContent content) throws IOException, InterruptedException, WorkspaceException {
            FilePath filepath = new FilePath(this.workspace, uri.getPath());
            filepath.write(content.data, StandardCharsets.UTF_8.name());
        }

        public boolean exists(URI file) throws IOException, InterruptedException {
            FilePath filepath = new FilePath(this.workspace, file.getPath());
            return filepath.exists();
        }

        public URI resolve(String filename) {
            try {
                String safeFilename = new URI(null, filename, null).getRawSchemeSpecificPart();
                return this.workspace.toURI().resolve(safeFilename);
            }
            catch (IOException | InterruptedException | URISyntaxException e) {
                throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
            }
        }

        public URI relativize(URI uri) {
            try {
                return this.workspace.toURI().relativize(uri);
            }
            catch (IOException | InterruptedException e) {
                throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
            }
        }
    }
}

