/*
 * Decompiled with CFR 0.152.
 */
package com.xliic.ci.jenkins;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.xliic.ci.jenkins.ApiKey;
import com.xliic.ci.jenkins.Messages;
import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ApiKeyImpl
extends BaseStandardCredentials
implements ApiKey {
    static final long serialVersionUID = 42L;
    @Nonnull
    private final Secret apiKey;

    @DataBoundConstructor
    public ApiKeyImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @Nonnull Secret apiKey, @CheckForNull String description) throws IOException {
        super(scope, id, description);
        this.apiKey = apiKey;
    }

    @Override
    @Nonnull
    public Secret getApiKey() {
        return this.apiKey;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return Messages.ApiKeyImpl_api_key();
        }

        public FormValidation doCheckApiKey(@QueryParameter(value="apiKey") String apiKey) {
            String decryptedKey = Secret.fromString((String)apiKey).getPlainText();
            if (Util.fixEmptyAndTrim((String)decryptedKey) == null) {
                return FormValidation.error((String)"API Token cannot be empty");
            }
            if (!decryptedKey.matches("(api_)?[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}")) {
                return FormValidation.error((String)"Invalid API Token format");
            }
            return FormValidation.ok((String)"Valid API Token format");
        }
    }
}

