/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.jenkinsfile.runner.util;

import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class TemporaryDirectoryAllocator {
    private final Set<File> tmpDirectories = new HashSet<File>();
    private final File base;

    public TemporaryDirectoryAllocator(File base) {
        this.base = base;
    }

    public TemporaryDirectoryAllocator() {
        this.base = new File(System.getProperty("java.io.tmpdir"), "jenkinsTests.tmp");
        this.base.mkdirs();
    }

    public synchronized File allocate() throws IOException {
        try {
            File f = File.createTempFile("jenkins", "test", this.base);
            f.delete();
            f.mkdirs();
            this.tmpDirectories.add(f);
            return f;
        }
        catch (IOException e) {
            throw new IOException("Failed to create a temporary directory in " + this.base, e);
        }
    }

    public synchronized void dispose() throws IOException, InterruptedException {
        IOException x = null;
        for (File dir : this.tmpDirectories) {
            try {
                new FilePath(dir).deleteRecursive();
            }
            catch (IOException e) {
                x = e;
            }
        }
        this.tmpDirectories.clear();
        if (x != null) {
            throw new IOException("Failed to clean up temp dirs", x);
        }
    }

    public synchronized void disposeAsync() {
        final HashSet<File> tbr = new HashSet<File>(this.tmpDirectories);
        this.tmpDirectories.clear();
        new Thread("Disposing " + this.base){

            @Override
            public void run() {
                for (File dir : tbr) {
                    try {
                        new FilePath(dir).deleteRecursive();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }
}

