/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.jenkinsfile.runner;

import hudson.security.ACL;
import io.jenkins.jenkinsfile.runner.JenkinsEmbedder;
import io.jenkins.jenkinsfile.runner.NoListenerConfiguration;
import io.jenkins.jenkinsfile.runner.PluginManagerImpl;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import jenkins.slaves.DeprecatedAgentProtocolMonitor;
import org.acegisecurity.Authentication;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class JenkinsfileRunnerRule
extends JenkinsEmbedder {
    private final File warDir;
    private final File pluginsDir;
    private final Set<Object> noGc = new HashSet<Object>();

    public JenkinsfileRunnerRule(File warDir, File pluginsDir) {
        this.warDir = warDir;
        this.pluginsDir = pluginsDir;
    }

    @Override
    protected ServletContext createWebServer() throws Exception {
        QueuedThreadPool queuedThreadPool = new QueuedThreadPool(10);
        this.server = new Server((ThreadPool)queuedThreadPool);
        WebAppContext context = new WebAppContext(this.warDir.getPath(), this.contextPath);
        context.setClassLoader(this.getClass().getClassLoader());
        context.setConfigurations(new Configuration[]{new WebXmlConfiguration()});
        context.addBean((Object)new NoListenerConfiguration(context));
        this.server.setHandler((Handler)context);
        context.getSecurityHandler().setLoginService(this.configureUserRealm());
        context.setResourceBase(this.warDir.getPath());
        this.server.start();
        this.localPort = -1;
        this.setPluginManager(new PluginManagerImpl((ServletContext)context.getServletContext(), this.pluginsDir));
        return context.getServletContext();
    }

    @Override
    protected LoginService configureUserRealm() {
        return new HashLoginService();
    }

    @Override
    public void before() throws Throwable {
        this.setLogLevels();
        super.before();
    }

    private void setLogLevels() {
        Logger.getLogger("").setLevel(Level.WARNING);
        Logger l = Logger.getLogger(DeprecatedAgentProtocolMonitor.class.getName());
        l.setLevel(Level.OFF);
        this.noGc.add(l);
    }

    @Override
    public void after() throws Exception {
        this.jenkins = null;
        super.after();
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                JenkinsfileRunnerRule.this.testDescription = description;
                Thread t = Thread.currentThread();
                String o = t.getName();
                t.setName("Executing " + JenkinsfileRunnerRule.this.testDescription.getDisplayName());
                JenkinsfileRunnerRule.this.before();
                try {
                    ACL.impersonate((Authentication)ACL.SYSTEM);
                    base.evaluate();
                }
                finally {
                    JenkinsfileRunnerRule.this.after();
                    JenkinsfileRunnerRule.this.testDescription = null;
                    t.setName(o);
                }
            }
        };
    }
}

