/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.jenkinsfile.runner;

import hudson.ClassicPluginStrategy;
import hudson.CloseProofOutputStream;
import hudson.DNSMultiCast;
import hudson.DescriptorExtensionList;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.Launcher;
import hudson.Main;
import hudson.PluginManager;
import hudson.WebAppMain;
import hudson.init.InitMilestone;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.DownloadService;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.model.Queue;
import hudson.model.RootAction;
import hudson.model.TaskListener;
import hudson.model.UpdateSite;
import hudson.model.User;
import hudson.remoting.Which;
import hudson.tools.ToolProperty;
import hudson.util.PersistedList;
import hudson.util.StreamTaskListener;
import hudson.util.jna.GNUCLibrary;
import io.jenkins.jenkinsfile.runner.WarExploder;
import io.jenkins.jenkinsfile.runner.util.HudsonHomeLoader;
import io.jenkins.jenkinsfile.runner.util.JenkinsRecipe;
import io.jenkins.jenkinsfile.runner.util.LenientRunnable;
import io.jenkins.jenkinsfile.runner.util.SupportLogFormatter;
import io.jenkins.jenkinsfile.runner.util.TestEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import org.apache.commons.io.FileUtils;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Server;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.MetaClassLoader;

public abstract class JenkinsEmbedder
implements RootAction {
    protected TestEnvironment env;
    protected Description testDescription;
    public Jenkins jenkins;
    protected HudsonHomeLoader homeLoader = HudsonHomeLoader.NEW;
    protected int localPort;
    protected Server server;
    public String contextPath = "/jenkins";
    protected List<LenientRunnable> tearDowns = new ArrayList<LenientRunnable>();
    protected List<JenkinsRecipe.Runner> recipes = new ArrayList<JenkinsRecipe.Runner>();
    public int timeout = Integer.getInteger("jenkins.test.timeout", System.getProperty("maven.surefire.debug") == null ? 180 : 0);
    private PluginManager pluginManager = null;
    private boolean origDefaultUseCache = true;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Logger SPRING_LOGGER = Logger.getLogger("org.springframework");
    private static final Logger JETTY_LOGGER = Logger.getLogger("org.mortbay.log");
    private static final Logger LOGGER;
    public static final List<ToolProperty<?>> NO_PROPERTIES;
    public static final MimeTypes MIME_TYPES;

    public Jenkins getInstance() {
        return this.jenkins;
    }

    public void before() throws Throwable {
        for (Handler h : Logger.getLogger("").getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            ((ConsoleHandler)h).setFormatter(new SupportLogFormatter());
        }
        if (Thread.interrupted()) {
            LOGGER.warning("was interrupted before start");
        }
        if (Functions.isWindows()) {
            URLConnection aConnection = new File(".").toURI().toURL().openConnection();
            this.origDefaultUseCache = aConnection.getDefaultUseCaches();
            aConnection.setDefaultUseCaches(false);
        }
        this.env = new TestEnvironment(this.testDescription);
        this.env.pin();
        this.recipe();
        AbstractProject.WORKSPACE.toString();
        User.clear();
        try {
            Field theInstance = Jenkins.class.getDeclaredField("theInstance");
            theInstance.setAccessible(true);
            if (theInstance.get(null) != null) {
                LOGGER.warning("Jenkins.theInstance was not cleared by a previous test, doing that now");
                theInstance.set(null, null);
            }
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        try {
            this.jenkins = this.newHudson();
            if (this.jenkins.getInitLevel() != InitMilestone.COMPLETED) {
                throw new Exception("Jenkins initialization has not reached the COMPLETED initialization stage. Current state is " + this.jenkins.getInitLevel() + ". Likely there is an issue with the Initialization task graph (e.g. usage of @Initializer(after = InitMilestone.COMPLETED)). See JENKINS-37759 for more info");
            }
        }
        catch (Exception e) {
            Field f = Jenkins.class.getDeclaredField("theInstance");
            f.setAccessible(true);
            f.set(null, null);
            throw e;
        }
        this.jenkins.setNoUsageStatistics(Boolean.valueOf(true));
        this.jenkins.servletContext.setAttribute("app", (Object)this.jenkins);
        this.jenkins.servletContext.setAttribute("version", (Object)"?");
        WebAppMain.installExpressionFactory((ServletContextEvent)new ServletContextEvent(this.jenkins.servletContext));
        this.jenkins.getJDKs().add(new JDK("default", System.getProperty("java.home")));
        this.configureUpdateCenter();
        this.jenkins.getActions().add(this);
        JenkinsLocationConfiguration.get().setUrl(this.getURL().toString());
    }

    protected void configureUpdateCenter() throws Exception {
        JenkinsEmbedder.jettyLevel(Level.INFO);
        DownloadService.neverUpdate = true;
        UpdateSite.neverUpdate = true;
        PersistedList sites = this.jenkins.getUpdateCenter().getSites();
        sites.clear();
    }

    private static void dumpThreads() {
        ThreadInfo[] threadInfos = Functions.getThreadInfos();
        Functions.ThreadGroupMap m = Functions.sortThreadsAndGetGroupMap((ThreadInfo[])threadInfos);
        for (ThreadInfo ti : threadInfos) {
            System.err.println(Functions.dumpThreadInfo((ThreadInfo)ti, (Functions.ThreadGroupMap)m));
        }
    }

    public void after() throws Exception {
        JenkinsEmbedder.jettyLevel(Level.WARNING);
        try {
            this.server.stop();
        }
        catch (Exception exception) {
        }
        finally {
            JenkinsEmbedder.jettyLevel(Level.INFO);
        }
        for (LenientRunnable r : this.tearDowns) {
            try {
                r.run();
            }
            catch (Exception exception) {}
        }
        if (this.jenkins != null) {
            this.jenkins.cleanUp();
        }
        ExtensionList.clearLegacyInstances();
        DescriptorExtensionList.clearLegacyInstances();
        try {
            this.env.dispose();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        System.gc();
        if (Functions.isWindows()) {
            URLConnection aConnection = new File(".").toURI().toURL().openConnection();
            aConnection.setDefaultUseCaches(this.origDefaultUseCache);
        }
    }

    private static void jettyLevel(Level level) {
        Logger.getLogger("org.eclipse.jetty").setLevel(level);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "self";
    }

    protected Hudson newHudson() throws Exception {
        JenkinsEmbedder.jettyLevel(Level.WARNING);
        ServletContext webServer = this.createWebServer();
        File home = this.homeLoader.allocate();
        for (JenkinsRecipe.Runner r : this.recipes) {
            r.decorateHome(this, home);
        }
        try {
            Hudson hudson = new Hudson(home, webServer, this.getPluginManager());
            return hudson;
        }
        catch (InterruptedException x) {
            throw new AssumptionViolatedException("Jenkins startup interrupted", (Throwable)x);
        }
        finally {
            JenkinsEmbedder.jettyLevel(Level.INFO);
        }
    }

    public PluginManager getPluginManager() {
        if (this.jenkins == null) {
            return this.pluginManager;
        }
        return this.jenkins.getPluginManager();
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
        if (this.jenkins != null) {
            throw new IllegalStateException("Too late to override the plugin manager");
        }
    }

    public JenkinsEmbedder with(PluginManager pluginManager) {
        this.setPluginManager(pluginManager);
        return this;
    }

    public File getWebAppRoot() throws Exception {
        return WarExploder.getExplodedDir();
    }

    protected abstract ServletContext createWebServer() throws Exception;

    protected String createUniqueProjectName() {
        return "test" + this.jenkins.getItems().size();
    }

    public Launcher.LocalLauncher createLocalLauncher() {
        return new Launcher.LocalLauncher((TaskListener)StreamTaskListener.fromStdout());
    }

    public URL getURL() throws IOException {
        return new URL("http://localhost:" + this.localPort + this.contextPath + "/");
    }

    public void interactiveBreak() throws Exception {
        System.out.println("Jenkins is running at " + this.getURL());
        new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    public void pause() throws IOException {
        new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    public TaskListener createTaskListener() {
        return new StreamTaskListener((OutputStream)new CloseProofOutputStream((OutputStream)System.out));
    }

    public void setQuietPeriod(int qp) throws IOException {
        this.jenkins.setQuietPeriod(Integer.valueOf(qp));
    }

    public boolean isSomethingHappening() {
        if (!this.jenkins.getQueue().isEmpty()) {
            return true;
        }
        for (Computer n : this.jenkins.getComputers()) {
            if (n.isIdle()) continue;
            return true;
        }
        return false;
    }

    public void waitUntilNoActivity() throws Exception {
        this.waitUntilNoActivityUpTo(Integer.MAX_VALUE);
    }

    public void waitUntilNoActivityUpTo(int timeout) throws Exception {
        long startTime = System.currentTimeMillis();
        int streak = 0;
        do {
            Thread.sleep(10L);
            streak = this.isSomethingHappening() ? 0 : ++streak;
            if (streak <= 5) continue;
            return;
        } while (System.currentTimeMillis() - startTime <= (long)timeout);
        ArrayList<Queue.Executable> building = new ArrayList<Queue.Executable>();
        for (Computer c : this.jenkins.getComputers()) {
            for (Executor e : c.getExecutors()) {
                if (!e.isBusy()) continue;
                building.add(e.getCurrentExecutable());
            }
            for (Executor e : c.getOneOffExecutors()) {
                if (!e.isBusy()) continue;
                building.add(e.getCurrentExecutable());
            }
        }
        JenkinsEmbedder.dumpThreads();
        throw new AssertionError((Object)String.format("Jenkins is still doing something after %dms: queue=%s building=%s", timeout, Arrays.asList(this.jenkins.getQueue().getItems()), building));
    }

    public void recipe() throws Exception {
        try {
            for (final Annotation a : this.testDescription.getAnnotations()) {
                JenkinsRecipe r = a.annotationType().getAnnotation(JenkinsRecipe.class);
                if (r == null) continue;
                final JenkinsRecipe.Runner runner = r.value().newInstance();
                this.recipes.add(runner);
                this.tearDowns.add(new LenientRunnable(){

                    @Override
                    public void run() throws Exception {
                        runner.tearDown(JenkinsEmbedder.this, a);
                    }
                });
                runner.setup(this, a);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    static void decorateHomeFor(File home, List<URL> all) throws Exception {
        ArrayList<Jpl> jpls = new ArrayList<Jpl>();
        for (URL hpl : all) {
            Jpl jpl = new Jpl(home, hpl);
            jpl.loadManifest();
            jpls.add(jpl);
        }
        for (Jpl jpl : jpls) {
            jpl.resolveDependencies(jpls);
        }
    }

    public JenkinsEmbedder withNewHome() {
        return this.with(HudsonHomeLoader.NEW);
    }

    public JenkinsEmbedder withExistingHome(File source) throws Exception {
        return this.with(new HudsonHomeLoader.CopyExisting(source));
    }

    public JenkinsEmbedder withPresetData(String name) {
        name = "/" + name + ".zip";
        URL res = this.getClass().getResource(name);
        if (res == null) {
            throw new IllegalArgumentException("No such data set found: " + name);
        }
        return this.with(new HudsonHomeLoader.CopyExisting(res));
    }

    public JenkinsEmbedder with(HudsonHomeLoader homeLoader) {
        this.homeLoader = homeLoader;
        return this;
    }

    private Object writeReplace() {
        throw new AssertionError((Object)("JenkinsEmbedder " + this.testDescription.getDisplayName() + " is not supposed to be serialized"));
    }

    public Description getTestDescription() {
        return this.testDescription;
    }

    protected abstract LoginService configureUserRealm();

    static {
        Locale.setDefault(Locale.ENGLISH);
        Dispatcher.TRACE = true;
        MetaClass.NO_CACHE = true;
        File dir22 = new File("src/main/resources");
        if (dir22.exists() && MetaClassLoader.debugLoader == null) {
            try {
                MetaClassLoader.debugLoader = new MetaClassLoader((ClassLoader)new URLClassLoader(new URL[]{dir22.toURI().toURL()}));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        SPRING_LOGGER.setLevel(Level.WARNING);
        JETTY_LOGGER.setLevel(Level.WARNING);
        Main.isUnitTest = true;
        System.setProperty("org.mortbay.jetty.Request.maxFormContentSize", "-1");
        LOGGER = Logger.getLogger(JenkinsEmbedder.class.getName());
        NO_PROPERTIES = Collections.emptyList();
        JenkinsEmbedder.jettyLevel(Level.WARNING);
        try {
            MIME_TYPES = new MimeTypes();
        }
        finally {
            JenkinsEmbedder.jettyLevel(Level.INFO);
        }
        MIME_TYPES.addMimeMapping("js", "application/javascript");
        Functions.DEBUG_YUI = true;
        ClassicPluginStrategy.useAntClassLoader = true;
        DNSMultiCast.disabled = true;
        try {
            GNUCLibrary.LIBC.unsetenv("MAVEN_OPTS");
            GNUCLibrary.LIBC.unsetenv("MAVEN_DEBUG_OPTS");
        }
        catch (LinkageError dir22) {
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to cancel out MAVEN_OPTS", e);
        }
    }

    private static final class Jpl {
        private final File home;
        final URL jpl;
        Manifest m;
        private String shortName;

        Jpl(File home, URL jpl) {
            this.home = home;
            this.jpl = jpl;
        }

        void loadManifest() throws IOException {
            this.m = new Manifest(this.jpl.openStream());
            this.shortName = this.m.getMainAttributes().getValue("Short-Name");
            if (this.shortName == null) {
                throw new Error(this.jpl + " doesn't have the Short-Name attribute");
            }
            FileUtils.copyURLToFile((URL)this.jpl, (File)new File(this.home, "plugins/" + this.shortName + ".jpl"));
        }

        void resolveDependencies(List<Jpl> jpls) throws Exception {
            String dependencies = this.m.getMainAttributes().getValue("Plugin-Dependencies");
            if (dependencies != null) {
                block2: for (String dep : dependencies.split(",")) {
                    String suffix = ";resolution:=optional";
                    boolean optional = dep.endsWith(suffix);
                    if (optional) {
                        dep = dep.substring(0, dep.length() - suffix.length());
                    }
                    String[] tokens = dep.split(":");
                    String artifactId = tokens[0];
                    String version = tokens[1];
                    for (Jpl other : jpls) {
                        if (!other.shortName.equals(artifactId)) continue;
                        continue block2;
                    }
                    File dependencyJar = this.resolveDependencyJar(artifactId, version);
                    if (dependencyJar == null) {
                        if (optional) {
                            LOGGER.log(Level.INFO, "cannot resolve optional dependency {0} of {1}; skipping", new Object[]{dep, this.shortName});
                            continue;
                        }
                        throw new IOException("Could not resolve " + dep + " in " + System.getProperty("java.class.path"));
                    }
                    File dst = new File(this.home, "plugins/" + artifactId + ".jpi");
                    if (dst.exists() && dst.lastModified() == dependencyJar.lastModified()) continue;
                    try {
                        FileUtils.copyFile((File)dependencyJar, (File)dst);
                    }
                    catch (ClosedByInterruptException x) {
                        throw new AssumptionViolatedException("copying dependencies was interrupted", (Throwable)x);
                    }
                }
            }
        }

        @CheckForNull
        private File resolveDependencyJar(String artifactId, String version) throws Exception {
            Enumeration<URL> manifests = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                URL manifest = manifests.nextElement();
                InputStream is = manifest.openStream();
                Manifest m = new Manifest(is);
                is.close();
                if (!artifactId.equals(m.getMainAttributes().getValue("Short-Name"))) continue;
                return Which.jarFile((URL)manifest);
            }
            Enumeration<URL> jellies = this.getClass().getClassLoader().getResources("index.jelly");
            while (jellies.hasMoreElements()) {
                File hpi;
                File target;
                File jellyF;
                File classes;
                URL jellyU = jellies.nextElement();
                if (!jellyU.getProtocol().equals("file") || !(classes = (jellyF = new File(jellyU.toURI())).getParentFile()).getName().equals("classes") || !(target = classes.getParentFile()).getName().equals("target") || !(hpi = new File(target, artifactId + ".hpi")).isFile()) continue;
                return hpi;
            }
            return null;
        }
    }
}

