/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.jenkinsfile.runner.bootstrap;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.util.VersionNumber;
import io.jenkins.jenkinsfile.runner.bootstrap.ClassLoaderBuilder;
import io.jenkins.jenkinsfile.runner.bootstrap.IApp;
import io.jenkins.jenkinsfile.runner.bootstrap.SideClassLoader;
import io.jenkins.jenkinsfile.runner.bootstrap.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Bootstrap {
    public static final long CACHE_EXPIRE = System.currentTimeMillis() - 86400000L;
    private static final String WORKSPACES_DIR_SYSTEM_PROPERTY = "jenkins.model.Jenkins.workspacesDir";
    @Option(name="-w", aliases={"--jenkins-war"}, usage="Path to exploded jenkins war directory.Depending on packaging, it may contain the entire WAR or just resources to be loaded by the WAR file, for example Groovy hooks or extra libraries.", forbids={"-jv"})
    public File warDir;
    @Option(name="-jv", aliases={"--jenkins-version"}, usage="jenkins version to use (only in case 'warDir' is not specified). Defaults to latest LTS.")
    public String version;
    @Option(name="-p", aliases={"--plugins"}, usage="plugins required to run pipeline. Either a plugins.txt file or a /plugins installation directory. Defaults to plugins.txt.")
    public File pluginsDir;
    @Option(name="-m", aliases={"--mirror"}, usage="mirror site of Jenkins, defaults to http://updates.jenkins.io/download. Get the mirror list from http://mirrors.jenkins-ci.org/status.html.")
    public String mirror;
    @Option(name="-f", aliases={"--file"}, usage="Path to Jenkinsfile (or directory containing a Jenkinsfile) to run, default to ./Jenkinsfile.")
    public File jenkinsfile;
    @Option(name="--runWorkspace", usage="Path to the workspace of the run to be used within the node{} context. It applies to both Jenkins master and agents (or side containers) if any. Requires Jenkins 2.119 or above")
    @CheckForNull
    public File runWorkspace;
    @Option(name="--runHome", usage="Path to the empty Jenkins Home directory to use for this run. If not specified a temporary directory will be created. Note that the folder specified via --runHome will not be disposed after the run.")
    @CheckForNull
    public File runHome;
    @Option(name="--withInitHooks", usage="Path to a directory containing Groovy Init Hooks to copy into init.groovy.d")
    @CheckForNull
    public File withInitHooks;
    private static final String DEFAULT_JOBNAME = "job";
    @Option(name="-n", aliases={"--job-name"}, usage="Name of the job the run belongs to")
    public String jobName = "job";
    @Option(name="-c", aliases={"--cause"}, usage="Cause of the run")
    public String cause;
    @Option(name="-b", aliases={"--build-number"}, usage="Build number of the run")
    public int buildNumber = 1;
    @Option(name="-a", aliases={"--arg"}, usage="Parameters to be passed to workflow job. Use multiple -a switches for multiple params")
    @CheckForNull
    public Map<String, String> workflowParameters;
    @Option(name="-ns", aliases={"--no-sandbox"}, usage="Disable workflow job execution within sandbox environment")
    public boolean noSandBox;
    @Option(name="-v", aliases={"--version"}, usage="Prints the current Jenkinsfile Runner version")
    public boolean showVersion;
    @Option(name="-h", aliases={"--help"}, usage="Prints help information.", help=true, forbids={"-v", "-w", "-p", "-f", "--runWorkspace"})
    public boolean help;
    @Option(name="-u", aliases={"--keep-undefined-parameters"}, usage="Keep undefined parameters if set")
    public boolean keepUndefinedParameters = false;
    @Option(name="--cli", usage="Launch interactive CLI.", forbids={"-v", "--runWorkspace", "-a", "-ns"})
    public boolean cliOnly;
    @Option(name="--scm", usage="YAML definition of the SCM, with optional credentials, to use for the project")
    public File scm;
    private File cache = new File(System.getProperty("user.home") + "/.jenkinsfile-runner/");

    public static void main(String[] args) throws Throwable {
        if (Boolean.getBoolean("start.pause")) {
            System.console().readLine();
        }
        Bootstrap bootstrap = new Bootstrap();
        CmdLineParser parser = new CmdLineParser((Object)bootstrap);
        try {
            parser.parseArgument(args);
            bootstrap.postConstruct(parser);
            int status = bootstrap.run();
            System.exit(status);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage((OutputStream)System.err);
        }
    }

    @PostConstruct
    public void postConstruct(CmdLineParser parser) throws IOException {
        if (this.showVersion) {
            System.out.println(this.getVersion());
            System.exit(0);
        }
        if (System.getenv("FORCE_JENKINS_CLI") != null) {
            this.cliOnly = true;
        }
        if (this.version != null && !this.isVersionSupported()) {
            System.err.printf("Jenkins version [%s] not suported by this jenkinsfile-runner version (requires %s). %n", this.version, this.getMininumJenkinsVersion());
            System.exit(-1);
        }
        if (this.warDir == null) {
            this.warDir = this.getJenkinsWar();
        }
        if (this.help) {
            System.out.println("\nUsage: jenkinsfile-runner [options] [params]\n");
            System.out.println("Options:");
            parser.printUsage((OutputStream)System.out);
            System.exit(0);
        }
        if (this.jenkinsfile == null) {
            this.jenkinsfile = new File("Jenkinsfile");
        }
        if (!this.cliOnly && !this.jenkinsfile.exists()) {
            System.err.println("no Jenkinsfile in current directory.");
            System.exit(-1);
        }
        if (this.jenkinsfile.isDirectory()) {
            this.jenkinsfile = new File(this.jenkinsfile, "Jenkinsfile");
        }
        if (this.pluginsDir == null) {
            this.pluginsDir = new File("plugins.txt");
        } else if (!this.pluginsDir.exists()) {
            System.err.println("invalid plugins file.");
            System.exit(-1);
        }
        if (this.pluginsDir.isFile()) {
            File plugins_txt = this.pluginsDir;
            this.pluginsDir = Files.createTempDirectory("plugins", new FileAttribute[0]).toFile();
            Iterator iterator = FileUtils.readLines((File)plugins_txt, (Charset)StandardCharsets.UTF_8).iterator();
            while (iterator.hasNext()) {
                String line;
                String shortname = line = (String)iterator.next();
                String version = "latest";
                int i = line.indexOf(58);
                if (i != -1) {
                    shortname = line.substring(0, i);
                    version = line.substring(i + 1);
                }
                this.installPlugin(shortname, version);
            }
        }
        if (this.runWorkspace != null) {
            if (System.getProperty(WORKSPACES_DIR_SYSTEM_PROPERTY) != null) {
                System.out.println("Ignoring the --runWorkspace argument, because an explicit System property is set (-Djenkins.model.Jenkins.workspacesDir)");
            } else {
                System.setProperty(WORKSPACES_DIR_SYSTEM_PROPERTY, this.runWorkspace.getAbsolutePath());
            }
        }
        if (this.workflowParameters == null) {
            this.workflowParameters = new HashMap<String, String>();
        }
        for (Map.Entry<String, String> workflowParameter : this.workflowParameters.entrySet()) {
            if (workflowParameter.getValue() != null) continue;
            workflowParameter.setValue("");
        }
        if (this.cause != null) {
            this.cause = this.cause.trim();
            if (this.cause.isEmpty()) {
                this.cause = null;
            }
        }
        if (this.jobName.isEmpty()) {
            this.jobName = DEFAULT_JOBNAME;
        }
        if (this.keepUndefinedParameters) {
            System.setProperty("hudson.model.ParametersAction.keepUndefinedParameters", "true");
        }
    }

    private String getVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    private String getMininumJenkinsVersion() throws IOException {
        return this.readJenkinsPomProperty("jenkins.version");
    }

    private boolean isVersionSupported() throws IOException {
        return new VersionNumber(this.version).isNewerThanOrEqualTo(new VersionNumber(this.getMininumJenkinsVersion()));
    }

    private String readJenkinsPomProperty(String key) throws IOException {
        try (InputStream pomProperties = this.getClass().getResourceAsStream("/jenkins.properties");){
            Properties props = new Properties();
            props.load(pomProperties);
            String string = props.getProperty(key);
            return string;
        }
    }

    private File getJenkinsWar() throws IOException {
        if (this.version == null) {
            System.out.println("No explicit version has been selected, using latest LTS");
            File latestCore = new File(this.cache, "war/latest.txt");
            latestCore.getParentFile().mkdirs();
            if (!latestCore.exists() || latestCore.lastModified() < CACHE_EXPIRE) {
                FileUtils.copyURLToFile((URL)URI.create("http://updates.jenkins.io/stable/latestCore.txt").toURL(), (File)latestCore);
            }
            this.version = FileUtils.readFileToString((File)latestCore, (Charset)StandardCharsets.US_ASCII);
        }
        System.out.printf("Running pipeline on jenkins %s%n", this.version);
        File war = new File(this.cache, String.format("war/%s/jenkins-war-%s.war", this.version, this.version));
        if (!war.exists()) {
            war.getParentFile().mkdirs();
            URL url = new URL(this.getMirrorURL(String.format("http://updates.jenkins.io/download/war/%s/jenkins.war", this.version)));
            System.out.printf("Downloading jenkins %s...%n", this.version);
            FileUtils.copyURLToFile((URL)url, (File)war);
        }
        return war;
    }

    private void installPlugin(String shortname, String version) throws IOException {
        File install = new File(this.pluginsDir, shortname + ".jpi");
        File plugin = new File(this.cache, String.format("plugins/%s/%s-%s.hpi", shortname, shortname, version));
        if (!plugin.exists() || "latest".equals(version) && plugin.lastModified() < CACHE_EXPIRE) {
            plugin.getParentFile().mkdirs();
            URL url = new URL(this.getMirrorURL(String.format("https://updates.jenkins.io/download/plugins/%s/%s/%s.hpi", shortname, version, shortname)));
            System.out.printf("Downloading jenkins plugin %s (%s)...%n", shortname, version);
            FileUtils.copyURLToFile((URL)url, (File)plugin);
        }
        Files.createSymbolicLink(install.toPath(), plugin.toPath(), new FileAttribute[0]);
    }

    private String getMirrorURL(String url) {
        if (this.mirror == null || "".equals(this.mirror.trim())) {
            return url;
        }
        return url.replace("https://updates.jenkins.io/download", this.mirror);
    }

    public int run() throws Throwable {
        String appClassName = "io.jenkins.jenkinsfile.runner.App";
        if (this.hasClass(appClassName)) {
            Class<?> c = Class.forName(appClassName);
            return ((IApp)c.newInstance()).run(this);
        }
        String warPath = this.warDir.getAbsolutePath();
        if (FilenameUtils.getExtension((String)warPath).equals("war") && new File(warPath).isFile()) {
            System.out.println("Exploding," + warPath + "this might take some time.");
            this.warDir = Util.explodeWar(warPath);
        }
        ClassLoader jenkins = this.createJenkinsWarClassLoader();
        ClassLoader setup = this.createSetupClassLoader(jenkins);
        Thread.currentThread().setContextClassLoader(setup);
        try {
            Class<?> c = setup.loadClass(appClassName);
            return ((IApp)c.newInstance()).run(this);
        }
        catch (ClassNotFoundException e) {
            if (setup instanceof URLClassLoader) {
                throw new ClassNotFoundException(e.getMessage() + " not found in " + this.getAppRepo() + "," + new File(this.warDir, "WEB-INF/lib") + " " + Arrays.toString(((URLClassLoader)setup).getURLs()), e);
            }
            throw e;
        }
    }

    public ClassLoader createJenkinsWarClassLoader() throws PrivilegedActionException {
        return AccessController.doPrivileged(() -> new ClassLoaderBuilder(new SideClassLoader(this.getPlatformClassloader())).collectJars(new File(this.warDir, "WEB-INF/lib")).collectJars(new File(this.getAppRepo(), "javax/servlet")).make());
    }

    public ClassLoader createSetupClassLoader(ClassLoader jenkins) throws IOException {
        return new ClassLoaderBuilder(jenkins).collectJars(this.getAppRepo()).make();
    }

    private ClassLoader getPlatformClassloader() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (Bootstrap.isPostJava8()) {
            return (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        return null;
    }

    private static boolean isPostJava8() {
        String javaVersion = System.getProperty("java.version");
        return !javaVersion.startsWith("1.");
    }

    public boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public File getAppRepo() {
        return new File(System.getProperty("app.repo"));
    }
}

