/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.jenkinsfile.runner.bootstrap;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Util {
    public static File explodeWar(String jarPath) throws IOException {
        JarFile jarfile = new JarFile(new File(jarPath));
        Enumeration<JarEntry> enu = jarfile.entries();
        Path currentPath = FileSystems.getDefault().getPath("", new String[0]).toAbsolutePath();
        Path path = Files.createTempDirectory(currentPath.toAbsolutePath(), "jenkinsfile-runner", new FileAttribute[0]);
        File destDir = path.toFile();
        while (enu.hasMoreElements()) {
            JarEntry je = enu.nextElement();
            File file = new File(destDir, je.getName());
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file = new File(destDir, je.getName());
            }
            if (je.isDirectory()) continue;
            InputStream is = jarfile.getInputStream(je);
            FileOutputStream fo = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                while (is.available() > 0) {
                    fo.write(is.read());
                }
                fo.close();
                is.close();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fo == null) continue;
                if (throwable != null) {
                    try {
                        fo.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fo.close();
            }
        }
        return destDir;
    }
}

