/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.support.matrixauth;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.impl.attributes.MultivaluedAttribute;
import io.jenkins.plugins.casc.util.PermissionFinder;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainer;

public abstract class MatrixAuthorizationStrategyConfigurator<T extends AuthorizationContainer>
extends BaseConfigurator<T> {
    @NonNull
    public Class getImplementedAPI() {
        return AuthorizationStrategy.class;
    }

    @NonNull
    public Set<Attribute<T, ?>> describe() {
        return Collections.singleton(new MultivaluedAttribute("grantedPermissions", String.class).getter(MatrixAuthorizationStrategyConfigurator::getGrantedPermissions).setter(MatrixAuthorizationStrategyConfigurator::setGrantedPermissions));
    }

    static Collection<String> getGrantedPermissions(AuthorizationContainer container) {
        return container.getGrantedPermissions().entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream().map(v -> e.getKey() + ":" + v)).collect(Collectors.toList());
    }

    static void setGrantedPermissions(AuthorizationContainer container, Collection<String> permissions) {
        permissions.forEach(p -> {
            int i = p.indexOf(58);
            Permission permission = PermissionFinder.findPermission((String)p.substring(0, i));
            container.add(permission, p.substring(i + 1));
        });
    }
}

