/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.support.jobdsl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.RootElementConfigurator;
import io.jenkins.plugins.casc.SecretSourceResolver;
import io.jenkins.plugins.casc.impl.attributes.MultivaluedAttribute;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.support.jobdsl.ScriptSource;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javaposse.jobdsl.dsl.GeneratedItems;
import javaposse.jobdsl.dsl.JobManagement;
import javaposse.jobdsl.plugin.JenkinsDslScriptLoader;
import javaposse.jobdsl.plugin.JenkinsJobManagement;
import javaposse.jobdsl.plugin.LookupStrategy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(optional=true, ordinal=-100.0)
@Restricted(value={NoExternalUse.class})
public class SeedJobConfigurator
implements RootElementConfigurator<GeneratedItems[]> {
    @NonNull
    public String getName() {
        return "jobs";
    }

    public Class getTarget() {
        return GeneratedItems[].class;
    }

    @NonNull
    public Set<Attribute<GeneratedItems[], ?>> describe() {
        return Collections.singleton(new MultivaluedAttribute("", ScriptSource.class));
    }

    public GeneratedItems[] getTargetComponent(ConfigurationContext context) {
        return new GeneratedItems[0];
    }

    @NonNull
    public GeneratedItems[] configure(CNode config, ConfigurationContext context) throws ConfiguratorException {
        JenkinsJobManagement management = new JenkinsJobManagement(System.out, System.getenv(), null, null, LookupStrategy.JENKINS_ROOT);
        Configurator configurator = context.lookupOrFail(ScriptSource.class);
        return (GeneratedItems[])config.asSequence().stream().map(source -> this.getActualValue((CNode)source, context)).map(source -> this.getScriptFromSource((CNode)source, context, (Configurator<ScriptSource>)configurator)).map(script -> this.generateFromScript((String)script, management)).toArray(GeneratedItems[]::new);
    }

    public GeneratedItems[] check(CNode config, ConfigurationContext context) throws ConfiguratorException {
        return new GeneratedItems[0];
    }

    @NonNull
    public List<Configurator<GeneratedItems[]>> getConfigurators(ConfigurationContext context) {
        return Collections.singletonList(context.lookup(ScriptSource.class));
    }

    @CheckForNull
    public CNode describe(GeneratedItems[] instance, ConfigurationContext context) throws Exception {
        return null;
    }

    private CNode getActualValue(CNode config, ConfigurationContext context) {
        return ((Optional)API.unchecked((CheckedFunction0 & Serializable)() -> config.asMapping().entrySet().stream().findFirst()).apply()).map(entry -> {
            Mapping mapping = new Mapping();
            mapping.put((String)entry.getKey(), this.revealSourceOrGetValue((Map.Entry<String, CNode>)entry, context));
            return mapping;
        }).orElse(config);
    }

    private String revealSourceOrGetValue(Map.Entry<String, CNode> entry, ConfigurationContext context) {
        String value = (String)API.unchecked((CheckedFunction0 & Serializable)() -> ((CNode)entry.getValue()).asScalar().getValue()).apply();
        return SecretSourceResolver.resolve((ConfigurationContext)context, (String)value);
    }

    private GeneratedItems generateFromScript(String script, JenkinsJobManagement management) {
        return (GeneratedItems)API.unchecked((CheckedFunction0 & Serializable)() -> (GeneratedItems)API.Try((CheckedFunction0 & Serializable)() -> new JenkinsDslScriptLoader((JobManagement)management).runScript(script)).getOrElseThrow(t -> new ConfiguratorException((Configurator)this, "Failed to execute script with hash " + script.hashCode(), t))).apply();
    }

    private String getScriptFromSource(CNode source, ConfigurationContext context, Configurator<ScriptSource> configurator) {
        return (String)API.unchecked((CheckedFunction0 & Serializable)() -> ((ScriptSource)((Object)((Object)API.Try((CheckedFunction0 & Serializable)() -> (ScriptSource)((Object)((Object)((Object)configurator.configure(source, context))))).getOrElseThrow(t -> new ConfiguratorException((Configurator)this, "Failed to retrieve job-dsl script", t))))).getScript()).apply();
    }
}

