/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.yaml;

import io.jenkins.plugins.casc.ConfigurationAsCode;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.yaml.ModelConstructor;
import io.jenkins.plugins.casc.yaml.StreamReaderWithSource;
import io.jenkins.plugins.casc.yaml.YamlSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.resolver.Resolver;

public final class YamlUtils {
    public static final Logger LOGGER = Logger.getLogger(ConfigurationAsCode.class.getName());

    public static Node merge(List<YamlSource> sources, ConfigurationContext context) throws ConfiguratorException {
        Node root = null;
        for (YamlSource source : sources) {
            try {
                Reader reader = YamlUtils.reader(source);
                try {
                    Node node = YamlUtils.read(source, reader, context);
                    if (root == null) {
                        root = node;
                        continue;
                    }
                    if (node == null) continue;
                    YamlUtils.merge(root, node, source.toString());
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException io) {
                throw new ConfiguratorException("Failed to read " + source, io);
            }
        }
        return root;
    }

    public static Node read(YamlSource source, Reader reader, ConfigurationContext context) throws IOException {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setMaxAliasesForCollections(context.getYamlMaxAliasesForCollections());
        Composer composer = new Composer((Parser)new ParserImpl((StreamReader)new StreamReaderWithSource(source, reader)), new Resolver(), loaderOptions);
        try {
            return composer.getSingleNode();
        }
        catch (YAMLException e) {
            if (e.getMessage().startsWith("Number of aliases for non-scalar nodes exceeds the specified max")) {
                throw new ConfiguratorException(String.format("%s%nYou can increase the maximum by setting an environment variable or property%n  ENV: %s=\"100\"%n  PROPERTY: -D%s=\"100\"", e.getMessage(), "CASC_YAML_MAX_ALIASES", "casc.yaml.max.aliases"));
            }
            throw e;
        }
    }

    public static Reader reader(YamlSource<?> source) throws IOException {
        Object src = source.source;
        if (src instanceof String) {
            URL url = URI.create((String)src).toURL();
            return new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
        }
        if (src instanceof InputStream) {
            return new InputStreamReader((InputStream)src, StandardCharsets.UTF_8);
        }
        if (src instanceof HttpServletRequest) {
            return new InputStreamReader((InputStream)((HttpServletRequest)src).getInputStream(), StandardCharsets.UTF_8);
        }
        if (src instanceof Path) {
            return Files.newBufferedReader((Path)src);
        }
        throw new IOException(String.format("Unknown %s", source));
    }

    private static void merge(Node root, Node node, String source) throws ConfiguratorException {
        if (root.getNodeId() != node.getNodeId()) {
            throw new ConfiguratorException(String.format("Found incompatible configuration elements %s %s", source, node.getStartMark()));
        }
        switch (root.getNodeId()) {
            case sequence: {
                SequenceNode seq = (SequenceNode)root;
                SequenceNode seq2 = (SequenceNode)node;
                seq.getValue().addAll(seq2.getValue());
                return;
            }
            case mapping: {
                MappingNode map = (MappingNode)root;
                MappingNode map2 = (MappingNode)node;
                Iterator it = map2.getValue().iterator();
                while (it.hasNext()) {
                    NodeTuple t2 = (NodeTuple)it.next();
                    for (NodeTuple tuple : map.getValue()) {
                        Node key = tuple.getKeyNode();
                        Node key2 = t2.getKeyNode();
                        if (key.getNodeId() == NodeId.scalar) {
                            if (!((ScalarNode)key).getValue().equals(((ScalarNode)key2).getValue())) continue;
                            YamlUtils.merge(tuple.getValueNode(), t2.getValueNode(), source);
                            it.remove();
                            continue;
                        }
                        throw new ConfiguratorException(String.format("Found unmergeable configuration keys %s %s)", source, node.getEndMark()));
                    }
                }
                map.getValue().addAll(map2.getValue());
                return;
            }
        }
        throw new ConfiguratorException(String.format("Found conflicting configuration at %s %s", source, node.getStartMark()));
    }

    public static Mapping loadFrom(List<YamlSource> sources, ConfigurationContext context) throws ConfiguratorException {
        if (sources.isEmpty()) {
            return Mapping.EMPTY;
        }
        Node merged = YamlUtils.merge(sources, context);
        if (merged == null) {
            LOGGER.warning("configuration-as-code yaml source returned an empty document.");
            return Mapping.EMPTY;
        }
        return YamlUtils.loadFrom(merged);
    }

    private static Mapping loadFrom(final Node node) {
        ModelConstructor constructor = new ModelConstructor();
        constructor.setComposer(new Composer(null, null){

            public Node getSingleNode() {
                return node;
            }
        });
        return (Mapping)constructor.getSingleData(Mapping.class);
    }
}

