/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.configurators;

import com.google.common.base.CaseFormat;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Descriptor;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.RootElementConfigurator;
import io.jenkins.plugins.casc.model.Mapping;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class DescriptorConfigurator
extends BaseConfigurator<Descriptor>
implements RootElementConfigurator<Descriptor> {
    private final List<String> names;
    private final Descriptor descriptor;
    private final Class target;

    public DescriptorConfigurator(Descriptor descriptor) {
        this.descriptor = descriptor;
        this.target = descriptor.getClass();
        this.names = this.resolvePossibleNames(descriptor);
    }

    @Override
    @NonNull
    public String getName() {
        return this.names.get(0);
    }

    @Override
    @NonNull
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public Class<Descriptor> getTarget() {
        return this.target;
    }

    @Override
    public Descriptor getTargetComponent(ConfigurationContext context) {
        return this.descriptor;
    }

    @Override
    protected Descriptor instance(Mapping mapping, ConfigurationContext context) {
        return this.descriptor;
    }

    private List<String> resolvePossibleNames(Descriptor descriptor) {
        return Optional.ofNullable(descriptor.getClass().getAnnotation(Symbol.class)).map(s -> Arrays.asList(s.value())).orElseGet(() -> Collections.singletonList(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, descriptor.getKlass().toJavaClass().getSimpleName())));
    }
}

