/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.TextStringBuilder;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public class SecretSourceResolver {
    private static final String enclosedBy = "${";
    private static final String enclosedIn = "}";
    private static final char escapedWith = '^';
    private static final String escapeEnclosedBy = "^${";
    private static final Logger LOGGER = Logger.getLogger(SecretSourceResolver.class.getName());
    private final StringSubstitutor nullSubstitutor;
    private final StringSubstitutor substitutor;

    public SecretSourceResolver(ConfigurationContext configurationContext) {
        this.substitutor = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup((Map)ImmutableMap.builder().put((Object)"base64", (Object)Base64Lookup.INSTANCE).put((Object)"fileBase64", (Object)FileBase64Lookup.INSTANCE).put((Object)"readFileBase64", (Object)FileBase64Lookup.INSTANCE).put((Object)"file", (Object)FileStringLookup.INSTANCE).put((Object)"readFile", (Object)FileStringLookup.INSTANCE).put((Object)"decodeBase64", (Object)DecodeBase64Lookup.INSTANCE).build(), (StringLookup)new ConfigurationContextStringLookup(configurationContext), false)).setEscapeChar('^').setVariablePrefix(enclosedBy).setVariableSuffix(enclosedIn).setEnableSubstitutionInVariables(true).setPreserveEscapes(true);
        this.nullSubstitutor = new StringSubstitutor((StringLookup)UnresolvedLookup.INSTANCE).setEscapeChar('^').setVariablePrefix(enclosedBy).setVariableSuffix(enclosedIn);
    }

    public String encode(@CheckForNull String toEncode) {
        if (toEncode == null) {
            return null;
        }
        return toEncode.replace(enclosedBy, escapeEnclosedBy);
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public static String resolve(ConfigurationContext context, String toInterpolate) {
        return context.getSecretSourceResolver().resolve(toInterpolate);
    }

    public String resolve(String toInterpolate) {
        if (StringUtils.isBlank((String)toInterpolate) || !toInterpolate.contains(enclosedBy)) {
            return toInterpolate;
        }
        TextStringBuilder buf = new TextStringBuilder(toInterpolate);
        this.substitutor.replaceIn(buf);
        this.nullSubstitutor.replaceIn(buf);
        return buf.toString();
    }

    static class FileBase64Lookup
    implements StringLookup {
        static final FileBase64Lookup INSTANCE = new FileBase64Lookup();

        FileBase64Lookup() {
        }

        public String lookup(@NonNull String key) {
            try {
                byte[] fileContent = Files.readAllBytes(Paths.get(key, new String[0]));
                return Base64.getEncoder().encodeToString(fileContent);
            }
            catch (IOException | InvalidPathException e) {
                LOGGER.log(Level.WARNING, String.format("Configuration import: Error looking up file '%s'. Will default to empty string", key), e);
                return null;
            }
        }
    }

    static class DecodeBase64Lookup
    implements StringLookup {
        static final DecodeBase64Lookup INSTANCE = new DecodeBase64Lookup();

        DecodeBase64Lookup() {
        }

        public String lookup(@NonNull String key) {
            return new String(Base64.getDecoder().decode(key.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
    }

    static class Base64Lookup
    implements StringLookup {
        static final Base64Lookup INSTANCE = new Base64Lookup();

        Base64Lookup() {
        }

        public String lookup(@NonNull String key) {
            return Base64.getEncoder().encodeToString(key.getBytes(StandardCharsets.UTF_8));
        }
    }

    static class FileStringLookup
    implements StringLookup {
        static final FileStringLookup INSTANCE = new FileStringLookup();

        FileStringLookup() {
        }

        public String lookup(@NonNull String key) {
            try {
                return new String(Files.readAllBytes(Paths.get(key, new String[0])), StandardCharsets.UTF_8);
            }
            catch (IOException | InvalidPathException e) {
                LOGGER.log(Level.WARNING, String.format("Configuration import: Error looking up file '%s' with UTF-8 encoding. Will default to empty string", key), e);
                return null;
            }
        }
    }

    static class ConfigurationContextStringLookup
    implements StringLookup {
        private final ConfigurationContext context;

        private ConfigurationContextStringLookup(ConfigurationContext context) {
            this.context = context;
        }

        public String lookup(String key) {
            return this.context.getSecretSources().stream().map(source -> (Optional)API.unchecked((CheckedFunction0 & Serializable)() -> source.reveal(key)).apply()).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).findFirst().orElse(null);
        }
    }

    static class UnresolvedLookup
    implements StringLookup {
        static final UnresolvedLookup INSTANCE = new UnresolvedLookup();

        private UnresolvedLookup() {
        }

        public String lookup(String key) {
            LOGGER.log(Level.WARNING, String.format("Configuration import: Found unresolved variable '%s'. Will default to empty string", key));
            return "";
        }
    }
}

