/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationAsCode;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.RootElementConfigurator;
import io.jenkins.plugins.casc.impl.DefaultConfiguratorRegistry;
import io.jenkins.plugins.casc.impl.attributes.DescribableAttribute;
import io.jenkins.plugins.casc.impl.configurators.HeteroDescribableConfigurator;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public class SchemaGeneration {
    private static final Logger LOGGER = Logger.getLogger(SchemaGeneration.class.getName());
    static final JSONObject schemaTemplateObject = new JSONObject().put("$schema", (Object)"http://json-schema.org/draft-07/schema#").put("description", (Object)"Jenkins Configuration as Code").put("additionalProperties", false).put("type", (Object)"object");

    public static JSONObject generateSchema() {
        JSONObject schemaObject = new JSONObject(schemaTemplateObject.toString());
        DefaultConfiguratorRegistry registry = new DefaultConfiguratorRegistry();
        ConfigurationContext context = new ConfigurationContext(registry);
        JSONObject rootConfiguratorProperties = new JSONObject();
        for (RootElementConfigurator rootElementConfigurator : RootElementConfigurator.all()) {
            JSONObject schemaConfiguratorObjects = new JSONObject();
            LinkedHashSet<Object> elements = new LinkedHashSet<Object>();
            SchemaGeneration.listElements(elements, rootElementConfigurator.describe(), context, true);
            for (Object e : elements) {
                if (e instanceof BaseConfigurator) {
                    BaseConfigurator baseConfigurator = (BaseConfigurator)e;
                    List baseConfigAttributeList = baseConfigurator.getAttributes();
                    if (baseConfigAttributeList.size() == 0) {
                        String key = baseConfigurator.getName();
                        schemaConfiguratorObjects.put(key, (Object)new JSONObject().put("additionalProperties", false).put("type", (Object)"object").put("properties", (Object)new JSONObject()));
                        continue;
                    }
                    JSONObject attributeSchema = new JSONObject();
                    for (Attribute attribute : baseConfigAttributeList) {
                        if (attribute.multiple) {
                            SchemaGeneration.generateMultipleAttributeSchema(attributeSchema, attribute, context, baseConfigurator);
                            continue;
                        }
                        if (attribute.type.isEnum()) {
                            SchemaGeneration.generateEnumAttributeSchema(attributeSchema, attribute, baseConfigurator);
                            continue;
                        }
                        attributeSchema.put(attribute.getName(), (Object)SchemaGeneration.generateNonEnumAttributeObject(attribute, baseConfigurator));
                        String key = baseConfigurator.getName();
                        schemaConfiguratorObjects.put(key, (Object)new JSONObject().put("additionalProperties", false).put("type", (Object)"object").put("properties", (Object)attributeSchema));
                    }
                    continue;
                }
                if (e instanceof HeteroDescribableConfigurator) {
                    HeteroDescribableConfigurator heteroDescribableConfigurator = (HeteroDescribableConfigurator)e;
                    String key = heteroDescribableConfigurator.getName();
                    schemaConfiguratorObjects.put(key, (Object)SchemaGeneration.generateHeteroDescribableConfigObject(heteroDescribableConfigurator));
                    continue;
                }
                if (!(e instanceof Attribute)) continue;
                Attribute attribute = (Attribute)e;
                if (attribute.type.isEnum()) {
                    SchemaGeneration.generateEnumAttributeSchema(schemaConfiguratorObjects, attribute, null);
                    continue;
                }
                schemaConfiguratorObjects.put(attribute.getName(), (Object)SchemaGeneration.generateNonEnumAttributeObject(attribute, null));
            }
            rootConfiguratorProperties.put(rootElementConfigurator.getName(), (Object)new JSONObject().put("type", (Object)"object").put("additionalProperties", false).put("properties", (Object)schemaConfiguratorObjects).put("title", (Object)("Configuration base for the " + rootElementConfigurator.getName() + " classifier")));
        }
        schemaObject.put("properties", (Object)rootConfiguratorProperties);
        return schemaObject;
    }

    public static String writeJSONSchema() {
        return SchemaGeneration.generateSchema().toString(4);
    }

    private static JSONObject generateHeteroDescribableConfigObject(HeteroDescribableConfigurator heteroDescribableConfiguratorObject) {
        Map implementorsMap = heteroDescribableConfiguratorObject.getImplementors();
        JSONObject finalHeteroConfiguratorObject = new JSONObject();
        if (!implementorsMap.isEmpty()) {
            Iterator itr = implementorsMap.entrySet().iterator();
            JSONArray oneOfJsonArray = new JSONArray();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                JSONObject implementorObject = new JSONObject();
                implementorObject.put("additionalProperties", false);
                implementorObject.put("properties", (Object)new JSONObject().put(entry.getKey(), (Object)new JSONObject().put("$id", (Object)("#/definitions/" + entry.getValue().getName()))));
                oneOfJsonArray.put((Object)implementorObject);
            }
            finalHeteroConfiguratorObject.put("type", (Object)"object");
            finalHeteroConfiguratorObject.put("oneOf", (Object)oneOfJsonArray);
        }
        return finalHeteroConfiguratorObject;
    }

    private static void listElements(Set<Object> elements, Set<Attribute<?, ?>> attributes, ConfigurationContext context, boolean root) {
        attributes.stream().peek(attribute -> {
            if (root && !(attribute instanceof DescribableAttribute)) {
                elements.add(attribute);
            }
        }).map(attribute -> attribute.getType()).map(type -> context.lookup((Type)type)).filter(obj -> Objects.nonNull(obj)).map(c -> c.getConfigurators(context)).flatMap(configurators -> configurators.stream()).filter(e -> elements.add(e)).forEach(configurator -> SchemaGeneration.listElements(elements, configurator.describe(), context, false));
    }

    private static JSONObject generateNonEnumAttributeObject(Attribute attribute, BaseConfigurator baseConfigurator) {
        JSONObject attributeType = new JSONObject();
        Optional<String> description = SchemaGeneration.getDescription(attribute, baseConfigurator);
        switch (attribute.type.getName()) {
            case "java.lang.String": 
            case "hudson.Secret": {
                attributeType.put("type", (Object)"string");
                description.ifPresent(desc -> attributeType.put("description", desc));
                break;
            }
            case "int": 
            case "java.lang.Integer": 
            case "long": 
            case "java.lang.Long": {
                attributeType.put("type", (Object)"integer");
                description.ifPresent(desc -> attributeType.put("description", desc));
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                attributeType.put("type", (Object)"boolean");
                description.ifPresent(desc -> attributeType.put("description", desc));
                break;
            }
            default: {
                attributeType.put("type", (Object)"object");
                description.ifPresent(desc -> attributeType.put("description", desc));
                attributeType.put("additionalProperties", false);
                attributeType.put("$id", (Object)("#/definitions/" + attribute.type.getName()));
            }
        }
        return attributeType;
    }

    private static Optional<String> getDescription(Attribute attribute, BaseConfigurator baseConfigurator) {
        String description = null;
        if (baseConfigurator != null) {
            description = SchemaGeneration.retrieveDocStringFromAttribute(baseConfigurator.getTarget(), attribute.name);
        }
        return Optional.ofNullable(description);
    }

    private static void generateMultipleAttributeSchema(JSONObject attributeSchema, Attribute attribute, ConfigurationContext context, BaseConfigurator baseConfigurator) {
        Optional<String> description = SchemaGeneration.getDescription(attribute, baseConfigurator);
        if (attribute.type.getName().equals("java.lang.String")) {
            JSONObject jsonObject = new JSONObject().put("type", (Object)"string");
            description.ifPresent(desc -> jsonObject.put("description", desc));
            attributeSchema.put(attribute.getName(), (Object)jsonObject);
        } else {
            JSONObject properties = new JSONObject();
            Configurator lookup = context.lookup(attribute.getType());
            if (lookup != null) {
                lookup.getAttributes().forEach(attr -> properties.put(attr.getName(), (Object)SchemaGeneration.generateNonEnumAttributeObject(attr, baseConfigurator)));
            }
            JSONObject attributeObject = new JSONObject().put("type", (Object)"array").put("items", (Object)new JSONArray().put((Object)new JSONObject().put("type", (Object)"object").put("properties", (Object)properties).put("additionalProperties", false)));
            description.ifPresent(desc -> attributeObject.put("description", desc));
            attributeSchema.put(attribute.getName(), (Object)attributeObject);
        }
    }

    private static void generateEnumAttributeSchema(JSONObject attributeSchemaTemplate, Attribute attribute, BaseConfigurator baseConfigurator) {
        Optional<String> description = SchemaGeneration.getDescription(attribute, baseConfigurator);
        if (attribute.type.getEnumConstants().length == 0) {
            JSONObject jsonObject = new JSONObject().put("type", (Object)"string");
            description.ifPresent(desc -> jsonObject.put("description", desc));
            attributeSchemaTemplate.put(attribute.getName(), (Object)jsonObject);
        } else {
            ArrayList<String> attributeList = new ArrayList<String>();
            for (Object obj : attribute.type.getEnumConstants()) {
                attributeList.add(obj.toString());
            }
            JSONObject jsonObject = new JSONObject().put("type", (Object)"string").put("enum", (Object)new JSONArray(attributeList));
            description.ifPresent(desc -> jsonObject.put("description", desc));
            attributeSchemaTemplate.put(attribute.getName(), (Object)jsonObject);
        }
    }

    public static String retrieveDocStringFromAttribute(Class baseConfigClass, String attributeName) {
        try {
            String htmlDocString = ConfigurationAsCode.get().getHtmlHelp(baseConfigClass, attributeName);
            return SchemaGeneration.removeHtmlTags(htmlDocString);
        }
        catch (IOException e) {
            LOGGER.warning("Error getting help document for attribute : " + e);
            return null;
        }
    }

    public static String removeHtmlTags(String htmlDocString) {
        return htmlDocString.replaceAll("<.*?>", "").trim();
    }
}

