/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import io.jenkins.plugins.casc.ConfigurationContext;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.Tuple;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;

public class SecretSourceResolver {
    private static final String enclosedBy = "${";
    private static final String enclosedIn = "}";
    private static final char escapedWith = '^';
    private static final String defaultDelimiter = ":-";
    private static final Logger LOGGER = Logger.getLogger(SecretSourceResolver.class.getName());

    public static String encode(@CheckForNull String toEncode) {
        if (toEncode == null) {
            return null;
        }
        return toEncode.replace(enclosedBy, "^${");
    }

    public static String resolve(ConfigurationContext context, String toInterpolate) {
        return SecretSourceResolver.substitutor(context).replace(toInterpolate);
    }

    private static StrSubstitutor substitutor(ConfigurationContext context) {
        StrSubstitutor substitutor = new StrSubstitutor((StrLookup)new ConfigurationContextStrLookup(context));
        substitutor.setEscapeChar('^');
        substitutor.setVariablePrefix(enclosedBy);
        substitutor.setVariableSuffix(enclosedIn);
        return substitutor;
    }

    private static String handleJenkinsVariableDeclaration(ConfigurationContext context, String captured) {
        return enclosedBy + captured + enclosedIn;
    }

    private static String handleUndefinedVariable(String captured) {
        LOGGER.log(Level.WARNING, "Configuration import: Found unresolved variable {0}. Will default to empty string", captured);
        return "";
    }

    private static Optional<String> reveal(ConfigurationContext context, String captured) {
        return context.getSecretSources().stream().map(source -> (Optional)API.unchecked((CheckedFunction0 & Serializable)() -> source.reveal(captured)).apply()).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).findFirst();
    }

    private static class ConfigurationContextStrLookup
    extends StrLookup {
        private final ConfigurationContext context;

        public ConfigurationContextStrLookup(ConfigurationContext context) {
            this.context = context;
        }

        public String lookup(String key) {
            String[] split = key.split(SecretSourceResolver.defaultDelimiter, 2);
            return (String)Tuple.of((Object)split[0], (Object)Try.of((CheckedFunction0 & Serializable)() -> split[1]).toJavaOptional()).apply((toReveal, defaultValue) -> SecretSourceResolver.reveal(this.context, toReveal).map(Optional::of).orElse((Optional)defaultValue).orElseGet(() -> SecretSourceResolver.handleUndefinedVariable(key)));
        }
    }
}

