/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.ConfiguratorRegistry;
import io.jenkins.plugins.casc.RootElementConfigurator;
import io.jenkins.plugins.casc.SecretSource;
import io.jenkins.plugins.casc.VersionConverter;
import io.jenkins.plugins.casc.model.CNode;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.Stapler;

public class ConfigurationContext
implements ConfiguratorRegistry {
    private Deprecation deprecation = Deprecation.reject;
    private Restriction restriction = Restriction.reject;
    private Unknown unknown = Unknown.reject;
    private transient List<Listener> listeners = new ArrayList<Listener>();
    private final transient ConfiguratorRegistry registry;
    private Version version = Version.ONE;

    public ConfigurationContext(ConfiguratorRegistry registry) {
        this.registry = registry;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void warning(@NonNull CNode node, @NonNull String message) {
        for (Listener listener : this.listeners) {
            listener.warning(node, message);
        }
    }

    public Deprecation getDeprecated() {
        return this.deprecation;
    }

    public Restriction getRestricted() {
        return this.restriction;
    }

    public Unknown getUnknown() {
        return this.unknown;
    }

    public void setDeprecated(Deprecation deprecation) {
        this.deprecation = deprecation;
    }

    public void setRestricted(Restriction restriction) {
        this.restriction = restriction;
    }

    public void setUnknown(Unknown unknown) {
        this.unknown = unknown;
    }

    @Override
    @CheckForNull
    public RootElementConfigurator lookupRootElement(String name) {
        return this.registry.lookupRootElement(name);
    }

    @Override
    @NonNull
    public <T> Configurator<T> lookupOrFail(Type type) throws ConfiguratorException {
        return this.registry.lookupOrFail(type);
    }

    @Override
    @CheckForNull
    public <T> Configurator<T> lookup(Type type) {
        return this.registry.lookup(type);
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public List<SecretSource> getSecretSources() {
        return SecretSource.all();
    }

    static {
        Stapler.CONVERT_UTILS.register((Converter)new VersionConverter(), Version.class);
    }

    @FunctionalInterface
    public static interface Listener {
        public void warning(@NonNull CNode var1, @NonNull String var2);
    }

    static enum Deprecation {
        reject,
        warn;

    }

    static enum Restriction {
        reject,
        beta,
        warn;

    }

    static enum Unknown {
        reject,
        warn;

    }

    static enum Version {
        ONE("1");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        public static Version of(String version) {
            switch (version) {
                case "1": {
                    return ONE;
                }
            }
            throw new IllegalArgumentException("unsupported version " + version);
        }

        public String value() {
            return this.value;
        }

        public boolean isAtLeast(Version version) {
            return this.ordinal() >= version.ordinal();
        }
    }
}

