/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.ManagementLink;
import hudson.remoting.Which;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.FormValidation;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.CasCGlobalConfig;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.ObsoleteConfigurationMonitor;
import io.jenkins.plugins.casc.RootElementConfigurator;
import io.jenkins.plugins.casc.SecretSource;
import io.jenkins.plugins.casc.impl.DefaultConfiguratorRegistry;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.model.Scalar;
import io.jenkins.plugins.casc.model.Sequence;
import io.jenkins.plugins.casc.model.Source;
import io.jenkins.plugins.casc.snakeyaml.DumperOptions;
import io.jenkins.plugins.casc.snakeyaml.Yaml;
import io.jenkins.plugins.casc.snakeyaml.emitter.Emitable;
import io.jenkins.plugins.casc.snakeyaml.emitter.Emitter;
import io.jenkins.plugins.casc.snakeyaml.error.YAMLException;
import io.jenkins.plugins.casc.snakeyaml.nodes.MappingNode;
import io.jenkins.plugins.casc.snakeyaml.nodes.Node;
import io.jenkins.plugins.casc.snakeyaml.nodes.NodeTuple;
import io.jenkins.plugins.casc.snakeyaml.nodes.ScalarNode;
import io.jenkins.plugins.casc.snakeyaml.nodes.SequenceNode;
import io.jenkins.plugins.casc.snakeyaml.nodes.Tag;
import io.jenkins.plugins.casc.snakeyaml.resolver.Resolver;
import io.jenkins.plugins.casc.snakeyaml.serializer.Serializer;
import io.jenkins.plugins.casc.yaml.YamlSource;
import io.jenkins.plugins.casc.yaml.YamlUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.lang.Klass;
import org.kohsuke.stapler.verb.POST;

@Extension
@Restricted(value={NoExternalUse.class})
public class ConfigurationAsCode
extends ManagementLink {
    public static final String CASC_JENKINS_CONFIG_PROPERTY = "casc.jenkins.config";
    public static final String CASC_JENKINS_CONFIG_ENV = "CASC_JENKINS_CONFIG";
    public static final String DEFAULT_JENKINS_YAML_PATH = "jenkins.yaml";
    public static final String YAML_FILES_PATTERN = "glob:**.{yml,yaml,YAML,YML}";
    private static final Logger LOGGER = Logger.getLogger(ConfigurationAsCode.class.getName());
    @Inject
    private DefaultConfiguratorRegistry registry;
    private long lastTimeLoaded;
    private List<String> sources = Collections.emptyList();

    @CheckForNull
    public String getIconFileName() {
        return "/plugin/configuration-as-code/img/logo-head.svg";
    }

    @CheckForNull
    public String getDisplayName() {
        return "Configuration as Code";
    }

    @CheckForNull
    public String getUrlName() {
        return "configuration-as-code";
    }

    public String getDescription() {
        return "Reload your configuration or update configuration source";
    }

    public Date getLastTimeLoaded() {
        return new Date(this.lastTimeLoaded);
    }

    public List<String> getSources() {
        return this.sources;
    }

    @RequirePOST
    public void doReload(StaplerRequest request, StaplerResponse response) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            response.sendError(403);
            return;
        }
        this.configure();
        response.sendRedirect("");
    }

    @RequirePOST
    public void doReplace(StaplerRequest request, StaplerResponse response) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            response.sendError(403);
            return;
        }
        String newSource = request.getParameter("_.newSource");
        String normalizedSource = Util.fixEmptyAndTrim((String)newSource);
        File file = new File(Util.fixNull((String)normalizedSource));
        if (file.exists() || ConfigurationAsCode.isSupportedURI(normalizedSource)) {
            List<String> candidatePaths = Collections.singletonList(normalizedSource);
            List<YamlSource> candidates = this.getConfigFromSources(candidatePaths);
            if (this.canApplyFrom(candidates)) {
                this.sources = candidatePaths;
                this.configureWith(this.getConfigFromSources(this.getSources()));
                CasCGlobalConfig config = (CasCGlobalConfig)((Object)GlobalConfiguration.all().get(CasCGlobalConfig.class));
                if (config != null) {
                    config.setConfigurationPath(normalizedSource);
                    config.save();
                }
                LOGGER.log(Level.FINE, "Replace configuration with: " + normalizedSource);
            } else {
                LOGGER.log(Level.INFO, "Provided sources could not be applied");
            }
        } else {
            LOGGER.log(Level.FINE, "No such source exists, applying default");
            this.configure();
        }
        response.sendRedirect("");
    }

    private boolean canApplyFrom(List<YamlSource> yamlSources) {
        try {
            this.checkWith(yamlSources);
            return true;
        }
        catch (ConfiguratorException configuratorException) {
            return false;
        }
    }

    @POST
    public FormValidation doCheckNewSource(@QueryParameter String newSource) {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        String normalizedSource = Util.fixEmptyAndTrim((String)newSource);
        File file = new File(Util.fixNull((String)normalizedSource));
        if (normalizedSource == null) {
            return FormValidation.ok();
        }
        if (!file.exists() && !ConfigurationAsCode.isSupportedURI(normalizedSource)) {
            return FormValidation.error((String)"Configuration cannot be applied. File or URL cannot be parsed or do not exist.");
        }
        try {
            Map<Source, String> issues = this.collectIssues(normalizedSource);
            JSONArray errors = this.collectProblems(issues, "error");
            if (!errors.isEmpty()) {
                return FormValidation.error((String)errors.toString());
            }
            JSONArray warnings = this.collectProblems(issues, "warning");
            if (!warnings.isEmpty()) {
                return FormValidation.warning((String)warnings.toString());
            }
            return FormValidation.okWithMarkup((String)"The configuration can be applied");
        }
        catch (ConfiguratorException | IllegalArgumentException e) {
            return FormValidation.error((Throwable)e, (String)(e.getCause() == null ? e.getMessage() : e.getCause().getMessage()));
        }
    }

    private Map<Source, String> collectIssues(String configurationPath) throws ConfiguratorException {
        List<String> sources = Collections.singletonList(configurationPath);
        List<YamlSource> yamlSource = this.getConfigFromSources(sources);
        return this.checkWith(yamlSource);
    }

    private JSONArray collectProblems(Map<Source, String> issues, String severity) {
        JSONArray problems = new JSONArray();
        issues.entrySet().stream().map(e -> new JSONObject().accumulate("line", ((Source)e.getKey()).line).accumulate(severity, e.getValue())).forEach(arg_0 -> ((JSONArray)problems).add(arg_0));
        return problems;
    }

    private void appendSources(List<YamlSource> sources, String source) throws ConfiguratorException {
        if (ConfigurationAsCode.isSupportedURI(source)) {
            sources.add(YamlSource.of(source));
        } else {
            sources.addAll(this.configs(source).stream().map(YamlSource::of).collect(Collectors.toList()));
        }
    }

    private List<YamlSource> getConfigFromSources(List<String> newSources) throws ConfiguratorException {
        ArrayList<YamlSource> sources = new ArrayList<YamlSource>();
        for (String p : newSources) {
            this.appendSources(sources, p);
        }
        return sources;
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED, before=InitMilestone.JOB_LOADED)
    public static void init() throws Exception {
        ConfigurationAsCode.get().configure();
    }

    public void configure() throws ConfiguratorException {
        this.configureWith(this.getStandardConfigSources());
    }

    private List<YamlSource> getStandardConfigSources() throws ConfiguratorException {
        ArrayList<YamlSource> configs = new ArrayList<YamlSource>();
        for (String p : this.getStandardConfig()) {
            this.appendSources(configs, p);
            this.sources = Collections.singletonList(p);
        }
        return configs;
    }

    private List<String> getStandardConfig() {
        String fullPath;
        List<String> configParameters = this.getBundledCasCURIs();
        CasCGlobalConfig casc = (CasCGlobalConfig)((Object)GlobalConfiguration.all().get(CasCGlobalConfig.class));
        String cascPath = casc != null ? casc.getConfigurationPath() : null;
        String configParameter = System.getProperty(CASC_JENKINS_CONFIG_PROPERTY, System.getenv(CASC_JENKINS_CONFIG_ENV));
        if (StringUtils.isNotBlank((String)cascPath) && StringUtils.isBlank((String)configParameter)) {
            configParameter = cascPath;
        }
        if (configParameter == null && Files.exists(Paths.get(fullPath = Jenkins.getInstance().getRootDir() + File.separator + DEFAULT_JENKINS_YAML_PATH, new String[0]), new LinkOption[0])) {
            configParameter = fullPath;
        }
        if (configParameter != null) {
            configParameters.add(configParameter);
        }
        if (configParameters.isEmpty()) {
            LOGGER.log(Level.FINE, "No configuration set nor default config file");
        }
        return configParameters;
    }

    public List<String> getBundledCasCURIs() {
        String cascFile = "/WEB-INF/jenkins.yaml";
        String cascDirectory = "/WEB-INF/jenkins.yaml.d/";
        ArrayList<String> res = new ArrayList<String>();
        ServletContext servletContext = Jenkins.getInstance().servletContext;
        try {
            URL bundled = servletContext.getResource("/WEB-INF/jenkins.yaml");
            if (bundled != null) {
                res.add(bundled.toString());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load /WEB-INF/jenkins.yaml", e);
        }
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(YAML_FILES_PATTERN);
        Set resources = servletContext.getResourcePaths("/WEB-INF/jenkins.yaml.d/");
        if (resources != null) {
            for (String cascItem : new TreeSet(resources)) {
                try {
                    URL bundled = servletContext.getResource(cascItem);
                    if (bundled == null || !matcher.matches(new File(bundled.getPath()).toPath())) continue;
                    res.add(bundled.toString());
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to execute " + res, e);
                }
            }
        }
        return res;
    }

    @RequirePOST
    public void doCheck(StaplerRequest req, StaplerResponse res) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            res.sendError(403);
            return;
        }
        Map<Source, String> issues = this.checkWith(YamlSource.of((HttpServletRequest)req));
        res.setContentType("application/json");
        JSONArray warnings = new JSONArray();
        issues.entrySet().stream().map(e -> new JSONObject().accumulate("line", ((Source)e.getKey()).line).accumulate("warning", e.getValue())).forEach(arg_0 -> ((JSONArray)warnings).add(arg_0));
        warnings.write((Writer)res.getWriter());
    }

    @RequirePOST
    public void doApply(StaplerRequest req, StaplerResponse res) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            res.sendError(403);
            return;
        }
        this.configureWith(YamlSource.of((HttpServletRequest)req));
    }

    @RequirePOST
    public void doExport(StaplerRequest req, StaplerResponse res) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            res.sendError(403);
            return;
        }
        res.setContentType("application/x-yaml; charset=utf-8");
        res.addHeader("Content-Disposition", "attachment; filename=jenkins.yaml");
        this.export((OutputStream)res.getOutputStream());
    }

    @RequirePOST
    public void doViewExport(StaplerRequest req, StaplerResponse res) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            res.sendError(403);
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.export(out);
        req.setAttribute("export", (Object)out.toString(StandardCharsets.UTF_8.name()));
        req.getView((Object)this, "viewExport.jelly").forward((ServletRequest)req, (ServletResponse)res);
    }

    public void doReference(StaplerRequest req, StaplerResponse res) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            res.sendError(403);
            return;
        }
        req.getView((Object)this, "reference.jelly").forward((ServletRequest)req, (ServletResponse)res);
    }

    public void doSchema(StaplerRequest req, StaplerResponse res) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            res.sendError(403);
            return;
        }
        req.getView((Object)this, "schema.jelly").forward((ServletRequest)req, (ServletResponse)res);
    }

    @Restricted(value={NoExternalUse.class})
    public void export(OutputStream out) throws Exception {
        ArrayList<NodeTuple> tuples = new ArrayList<NodeTuple>();
        ConfigurationContext context = new ConfigurationContext(this.registry);
        for (RootElementConfigurator root : RootElementConfigurator.all()) {
            CNode config = root.describe(root.getTargetComponent(context), context);
            Node valueNode = this.toYaml(config);
            if (valueNode == null) continue;
            tuples.add(new NodeTuple((Node)new ScalarNode(Tag.STR, root.getName(), null, null, DumperOptions.ScalarStyle.PLAIN), valueNode));
        }
        MappingNode root = new MappingNode(Tag.MAP, tuples, DumperOptions.FlowStyle.BLOCK);
        try (OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            ConfigurationAsCode.serializeYamlNode((Node)root, writer);
        }
        catch (IOException e) {
            throw new YAMLException((Throwable)e);
        }
    }

    @Restricted(value={NoExternalUse.class})
    @VisibleForTesting
    public static void serializeYamlNode(Node root, Writer writer) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        options.setSplitLines(true);
        options.setPrettyFlow(true);
        Serializer serializer = new Serializer((Emitable)new Emitter(writer, options), new Resolver(), options, null);
        serializer.open();
        serializer.serialize(root);
        serializer.close();
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    @VisibleForTesting
    public Node toYaml(CNode config) throws ConfiguratorException {
        if (config == null) {
            return null;
        }
        switch (config.getType()) {
            case MAPPING: {
                Mapping mapping = config.asMapping();
                ArrayList<NodeTuple> tuples = new ArrayList<NodeTuple>();
                ArrayList entries = new ArrayList(mapping.entrySet());
                entries.sort(Comparator.comparing(Map.Entry::getKey));
                for (Map.Entry entry : entries) {
                    Node valueNode = this.toYaml((CNode)entry.getValue());
                    if (valueNode == null) continue;
                    tuples.add(new NodeTuple((Node)new ScalarNode(Tag.STR, (String)entry.getKey(), null, null, DumperOptions.ScalarStyle.PLAIN), valueNode));
                }
                if (tuples.isEmpty()) {
                    return null;
                }
                return new MappingNode(Tag.MAP, tuples, DumperOptions.FlowStyle.BLOCK);
            }
            case SEQUENCE: {
                Sequence sequence = config.asSequence();
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (CNode cNode : sequence) {
                    Node valueNode = this.toYaml(cNode);
                    if (valueNode == null) continue;
                    arrayList.add(valueNode);
                }
                if (arrayList.isEmpty()) {
                    return null;
                }
                return new SequenceNode(Tag.SEQ, arrayList, DumperOptions.FlowStyle.BLOCK);
            }
        }
        Scalar scalar = config.asScalar();
        String value = scalar.getValue();
        if (value == null || value.length() == 0) {
            return null;
        }
        DumperOptions.ScalarStyle style = scalar.getFormat().equals((Object)Scalar.Format.MULTILINESTRING) && !scalar.isRaw() ? DumperOptions.ScalarStyle.LITERAL : (scalar.isRaw() ? DumperOptions.ScalarStyle.PLAIN : DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        return new ScalarNode(this.getTag(scalar.getFormat()), value, null, null, style);
    }

    private Tag getTag(Scalar.Format format) {
        switch (format) {
            case NUMBER: {
                return Tag.INT;
            }
            case FLOATING: {
                return Tag.FLOAT;
            }
            case BOOLEAN: {
                return Tag.BOOL;
            }
        }
        return Tag.STR;
    }

    public void configure(String ... configParameters) throws ConfiguratorException {
        this.configure(Arrays.asList(configParameters));
    }

    public void configure(Collection<String> configParameters) throws ConfiguratorException {
        ArrayList<YamlSource> configs = new ArrayList<YamlSource>();
        for (String p : configParameters) {
            this.appendSources(configs, p);
            this.sources = Collections.singletonList(p);
        }
        this.configureWith(configs);
        this.lastTimeLoaded = System.currentTimeMillis();
    }

    public static boolean isSupportedURI(String configurationParameter) {
        URI uri;
        if (configurationParameter == null) {
            return false;
        }
        List<String> supportedProtocols = Arrays.asList("https", "http", "file");
        try {
            uri = new URI(configurationParameter);
        }
        catch (URISyntaxException ex) {
            return false;
        }
        if (uri.getScheme() == null) {
            return false;
        }
        return supportedProtocols.contains(uri.getScheme());
    }

    @Restricted(value={NoExternalUse.class})
    public void configureWith(YamlSource source) throws ConfiguratorException {
        List<YamlSource> sources = this.getStandardConfigSources();
        sources.add(source);
        this.configureWith(sources);
    }

    private void configureWith(List<YamlSource> sources) throws ConfiguratorException {
        this.lastTimeLoaded = System.currentTimeMillis();
        this.configureWith(YamlUtils.loadFrom(sources));
    }

    @Restricted(value={NoExternalUse.class})
    public Map<Source, String> checkWith(YamlSource source) throws ConfiguratorException {
        List<YamlSource> sources = this.getStandardConfigSources();
        sources.add(source);
        return this.checkWith(sources);
    }

    private Map<Source, String> checkWith(List<YamlSource> sources) throws ConfiguratorException {
        if (sources.isEmpty()) {
            return null;
        }
        return this.checkWith(YamlUtils.loadFrom(sources));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Path> configs(String path) throws ConfiguratorException {
        Path root = Paths.get(path, new String[0]);
        if (!Files.exists(root, new LinkOption[0])) {
            throw new ConfiguratorException("Invalid configuration: '" + path + "' isn't a valid path.");
        }
        if (Files.isRegularFile(root, new LinkOption[0]) && Files.isReadable(root)) {
            return Collections.singletonList(root);
        }
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(YAML_FILES_PATTERN);
        try (Stream<Path> stream = Files.find(Paths.get(path, new String[0]), Integer.MAX_VALUE, (next, attrs) -> !attrs.isDirectory() && !ConfigurationAsCode.isHidden(next) && matcher.matches((Path)next), new FileVisitOption[0]);){
            List<Path> list = stream.sorted().collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException("failed config scan for " + path, e);
        }
    }

    private static boolean isHidden(Path path) {
        return IntStream.range(0, path.getNameCount()).mapToObj(path::getName).anyMatch(subPath -> subPath.toString().startsWith("."));
    }

    private static Stream<? extends Map.Entry<String, Object>> entries(Reader config) {
        return ((Map)new Yaml().loadAs(config, Map.class)).entrySet().stream();
    }

    private static void invokeWith(Mapping entries, ConfiguratorOperation function) throws ConfiguratorException {
        block2: for (RootElementConfigurator configurator : RootElementConfigurator.all()) {
            Iterator it = entries.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!((String)entry.getKey()).equalsIgnoreCase(configurator.getName())) continue;
                try {
                    function.apply(configurator, (CNode)entry.getValue());
                    it.remove();
                    continue block2;
                }
                catch (ConfiguratorException e) {
                    throw new ConfiguratorException(configurator, String.format("error configuring '%s' with %s configurator", entry.getKey(), configurator.getClass()), e);
                }
            }
        }
        if (!entries.isEmpty()) {
            Map.Entry next = entries.entrySet().iterator().next();
            throw new ConfiguratorException(String.format("No configurator for root element <%s>", next.getKey()));
        }
    }

    private void configureWith(Mapping entries) throws ConfiguratorException {
        Mapping clone = entries.clone();
        this.checkWith(clone);
        ObsoleteConfigurationMonitor monitor = ObsoleteConfigurationMonitor.get();
        monitor.reset();
        ConfigurationContext context = new ConfigurationContext(this.registry);
        context.addListener(monitor::record);
        context.getSecretSources().forEach(SecretSource::init);
        try (ACLContext acl = ACL.as((Authentication)ACL.SYSTEM);){
            ConfigurationAsCode.invokeWith(entries, (configurator, config) -> configurator.configure(config, context));
        }
    }

    public Map<Source, String> checkWith(Mapping entries) throws ConfiguratorException {
        HashMap<Source, String> issues = new HashMap<Source, String>();
        ConfigurationContext context = new ConfigurationContext(this.registry);
        context.addListener((node, message) -> issues.put(node.getSource(), message));
        ConfigurationAsCode.invokeWith(entries, (configurator, config) -> configurator.check(config, context));
        return issues;
    }

    public static ConfigurationAsCode get() {
        return (ConfigurationAsCode)((Object)Jenkins.getInstance().getExtensionList(ConfigurationAsCode.class).get(0));
    }

    public Collection<?> getRootConfigurators() {
        return new LinkedHashSet<RootElementConfigurator>(RootElementConfigurator.all());
    }

    public Collection<?> getConfigurators() {
        List<RootElementConfigurator> roots = RootElementConfigurator.all();
        ConfigurationContext context = new ConfigurationContext(this.registry);
        LinkedHashSet<Object> elements = new LinkedHashSet<Object>(roots);
        for (RootElementConfigurator root : roots) {
            this.listElements(elements, root.describe(), context);
        }
        return elements;
    }

    private void listElements(Set<Object> elements, Set<Attribute<?, ?>> attributes, ConfigurationContext context) {
        attributes.stream().map(Attribute::getType).map(context::lookup).filter(Objects::nonNull).map(c -> c.getConfigurators(context)).flatMap(Collection::stream).forEach(configurator -> {
            if (elements.add(configurator)) {
                this.listElements(elements, configurator.describe(), context);
            }
        });
    }

    @NonNull
    public String getHtmlHelp(Class type, String attribute) throws IOException {
        URL resource = Klass.java((Class)type).getResource("help-" + attribute + ".html");
        if (resource != null) {
            return IOUtils.toString((InputStream)resource.openStream());
        }
        return "";
    }

    @CheckForNull
    public String getExtensionSource(Configurator c) throws IOException {
        Class e = c.getImplementedAPI();
        String jar = Which.jarFile((Class)e).getName();
        if (jar.startsWith("jenkins-core-")) {
            return "jenkins-core";
        }
        return jar.substring(0, jar.lastIndexOf(46));
    }

    @Restricted(value={NoExternalUse.class})
    public static String printThrowable(@NonNull Throwable t) {
        String s = Functions.printThrowable((Throwable)t).split("at io.jenkins.plugins.casc.ConfigurationAsCode.export")[0].replaceAll("\t", "  ");
        return s.substring(0, s.lastIndexOf(")") + 1);
    }

    @FunctionalInterface
    private static interface ConfiguratorOperation {
        public Object apply(RootElementConfigurator var1, CNode var2) throws ConfiguratorException;
    }
}

