/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.misc;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import io.jenkins.plugins.casc.ConfigurationAsCode;
import io.jenkins.plugins.casc.ConfiguratorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.logging.Level;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LoggerRule;
import org.jvnet.hudson.test.RestartableJenkinsRule;

public abstract class RoundTripAbstractTest {
    @Rule
    public RestartableJenkinsRule r = new RestartableJenkinsRule();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public LoggerRule logging = new LoggerRule();

    protected abstract void assertConfiguredAsExpected(RestartableJenkinsRule var1, String var2);

    protected String configResource() {
        return "configuration-as-code.yaml";
    }

    protected abstract String stringInLogExpected();

    @Test
    public void roundTripTest() throws IOException {
        String resourcePath = this.configResource();
        String resourceContent = this.getResourceContent(resourcePath);
        Assert.assertNotNull((Object)resourcePath);
        Assert.assertNotNull((Object)resourceContent);
        this.r.then(step -> {
            this.configureWithResource(resourcePath);
            this.assertConfiguredAsExpected(this.r, resourceContent);
            String jenkinsConf = this.getResourceContent(resourcePath);
            this.assertConfigViaWebUI(jenkinsConf);
            this.applyConfigViaWebUI(jenkinsConf);
            this.assertConfiguredAsExpected(this.r, resourceContent);
            this.putConfigInHome(jenkinsConf);
            this.logging.record("io.jenkins.plugins.casc", Level.INFO).capture(5);
        });
        this.r.then(step -> {
            this.assertLogAsExpected(this.stringInLogExpected());
            this.assertConfiguredAsExpected(this.r, resourceContent);
        });
    }

    private void configureWithResource(String config) throws ConfiguratorException {
        ConfigurationAsCode.get().configure(new String[]{this.getClass().getResource(config).toExternalForm()});
    }

    private String getResourceContent(String resourcePath) throws IOException {
        return IOUtils.toString((InputStream)this.getClass().getResourceAsStream(resourcePath), (String)"UTF-8");
    }

    private void writeToFile(String text, String path) throws FileNotFoundException {
        File file = new File(path);
        try (PrintWriter out = new PrintWriter(file);){
            out.print(text);
        }
    }

    private void putConfigInHome(String config) throws IOException {
        File configFile = new File(this.r.home, "jenkins.yaml");
        this.writeToFile(config, configFile.getAbsolutePath());
        Assert.assertTrue((String)"jenkins.yaml should be created", (boolean)configFile.exists());
    }

    private void assertConfigViaWebUI(String jenkinsConfig) throws Exception {
        File f = this.tempFolder.newFile();
        this.writeToFile(jenkinsConfig, f.getAbsolutePath());
        JenkinsRule.WebClient client = this.r.j.createWebClient();
        WebRequest request = new WebRequest(client.createCrumbedUrl("configuration-as-code/checkNewSource"), HttpMethod.POST);
        NameValuePair param = new NameValuePair("newSource", f.toURI().toURL().toExternalForm());
        request.setRequestParameters(Collections.singletonList(param));
        WebResponse response = client.loadWebResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        String res = response.getContentAsString();
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.containsString((String)"The configuration can be applied"));
    }

    private void applyConfigViaWebUI(String jenkinsConfig) throws Exception {
        File f = this.tempFolder.newFile();
        this.writeToFile(jenkinsConfig, f.getAbsolutePath());
        JenkinsRule.WebClient client = this.r.j.createWebClient();
        WebRequest request = new WebRequest(client.createCrumbedUrl("configuration-as-code/replace"), HttpMethod.POST);
        NameValuePair param = new NameValuePair("_.newSource", f.toURI().toURL().toExternalForm());
        request.setRequestParameters(Collections.singletonList(param));
        request.setRequestParameters(Collections.singletonList(param));
        WebResponse response = client.loadWebResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        String res = response.getContentAsString();
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.containsString((String)f.toURI().toURL().toExternalForm()));
    }

    private void assertLogAsExpected(String uniqueText) {
        Assert.assertTrue((String)("The log should have '" + uniqueText + "'"), (boolean)this.logging.getMessages().stream().anyMatch(m -> m.contains(uniqueText)));
    }
}

