/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Source;
import java.util.stream.IntStream;

public final class Scalar
implements CNode,
CharSequence {
    private String value;
    private Format format;
    private boolean raw;
    private Source source;

    public Scalar(String value, Source source) {
        this(value);
        this.source = source;
    }

    public Scalar(String value) {
        this.value = value;
        this.format = value.contains("\n") ? Format.MULTILINESTRING : Format.STRING;
        this.raw = false;
    }

    public Scalar(Enum instance) {
        this.value = instance.name();
        this.format = Format.STRING;
        this.raw = true;
    }

    public Scalar(Boolean instance) {
        this.value = String.valueOf(instance);
        this.format = Format.BOOLEAN;
        this.raw = true;
    }

    public Scalar(Number instance) {
        this.value = String.valueOf(instance);
        this.raw = true;
        this.format = instance instanceof Float || instance instanceof Double ? Format.FLOATING : Format.NUMBER;
    }

    @Override
    public CNode.Type getType() {
        return CNode.Type.SCALAR;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean isRaw() {
        return this.raw;
    }

    @Override
    public Scalar asScalar() {
        return this;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    @NonNull
    public String toString() {
        return this.value;
    }

    @Override
    public IntStream chars() {
        return this.value.chars();
    }

    @Override
    public IntStream codePoints() {
        return this.value.codePoints();
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public CNode clone() {
        return new Scalar(this);
    }

    private Scalar(Scalar it) {
        this.value = it.value;
        this.format = it.format;
        this.raw = it.raw;
        this.source = it.source;
    }

    public static enum Format {
        STRING,
        MULTILINESTRING,
        BOOLEAN,
        NUMBER,
        FLOATING;

    }
}

