/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.secrets.vault;

import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import io.jenkins.plugins.casc.impl.secrets.vault.VaultAuthenticatorWithExpiration;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VaultUserPassAuthenticator
extends VaultAuthenticatorWithExpiration {
    private static final Logger LOGGER = Logger.getLogger(VaultUserPassAuthenticator.class.getName());
    private String user;
    private String pass;
    private String mountPath;

    public VaultUserPassAuthenticator(String user, String pass, String mountPath) {
        this.user = user;
        this.pass = pass;
        this.mountPath = mountPath;
    }

    @Override
    public void authenticate(Vault vault, VaultConfig config) throws VaultException {
        if (this.isTokenTTLExpired()) {
            this.currentAuthToken = vault.auth().loginByUserPass(this.user, this.pass, this.mountPath).getAuthClientToken();
            config.token(this.currentAuthToken).build();
            LOGGER.log(Level.FINE, "Login to Vault using AppRole/SecretID successful");
            this.getTTLExpiryOfCurrentToken(vault);
        } else {
            config.token(this.currentAuthToken).build();
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.user, this.pass, this.mountPath);
    }
}

