/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.secrets.vault;

import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import io.jenkins.plugins.casc.impl.secrets.vault.VaultAuthenticatorWithExpiration;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VaultAppRoleAuthenticator
extends VaultAuthenticatorWithExpiration {
    private static final Logger LOGGER = Logger.getLogger(VaultAppRoleAuthenticator.class.getName());
    private String approle;
    private String approleSecret;

    public VaultAppRoleAuthenticator(String approle, String approleSecret) {
        this.approle = approle;
        this.approleSecret = approleSecret;
    }

    @Override
    public void authenticate(Vault vault, VaultConfig config) throws VaultException {
        if (this.isTokenTTLExpired()) {
            this.currentAuthToken = vault.auth().loginByAppRole(this.approle, this.approleSecret).getAuthClientToken();
            config.token(this.currentAuthToken).build();
            LOGGER.log(Level.FINE, "Login to Vault using AppRole/SecretID successful");
            this.getTTLExpiryOfCurrentToken(vault);
        } else {
            config.token(this.currentAuthToken).build();
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.approle, this.approleSecret);
    }
}

