/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.configurators;

import com.google.common.base.CaseFormat;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Descriptor;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.RootElementConfigurator;
import io.jenkins.plugins.casc.model.Mapping;
import java.util.Optional;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class DescriptorConfigurator
extends BaseConfigurator<Descriptor>
implements RootElementConfigurator<Descriptor> {
    private final String name;
    private final Descriptor descriptor;
    private final Class target;

    public DescriptorConfigurator(Descriptor descriptor) {
        this.descriptor = descriptor;
        this.target = descriptor.getClass();
        this.name = this.resolveName(descriptor);
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public Class<Descriptor> getTarget() {
        return this.target;
    }

    @Override
    public Descriptor getTargetComponent(ConfigurationContext context) {
        return this.descriptor;
    }

    @Override
    protected Descriptor instance(Mapping mapping, ConfigurationContext context) {
        return this.descriptor;
    }

    private String resolveName(Descriptor descriptor) {
        return Optional.ofNullable(descriptor.getClass().getAnnotation(Symbol.class)).map(s -> s.value()[0]).orElseGet(() -> CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, descriptor.getKlass().toJavaClass().getSimpleName()));
    }
}

