/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.impl.configurators;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Descriptor;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationAsCode;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.RootElementConfigurator;
import io.jenkins.plugins.casc.impl.configurators.DescriptorConfigurator;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.model.Scalar;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class GlobalConfigurationCategoryConfigurator
extends BaseConfigurator<GlobalConfigurationCategory>
implements RootElementConfigurator<GlobalConfigurationCategory> {
    private static final Logger LOGGER = Logger.getLogger(GlobalConfigurationCategoryConfigurator.class.getName());
    private static final String CREDENTIALS_PROVIDER_MANAGER_CONFIGURATION = "com.cloudbees.plugins.credentials.CredentialsProviderManager$Configuration";
    private final GlobalConfigurationCategory category;

    public GlobalConfigurationCategoryConfigurator(GlobalConfigurationCategory category) {
        this.category = category;
    }

    @Override
    @NonNull
    public String getName() {
        Class<?> c = this.category.getClass();
        Symbol symbol = c.getAnnotation(Symbol.class);
        if (symbol != null) {
            return symbol.value()[0];
        }
        String name = c.getSimpleName();
        name = StringUtils.remove((String)name, (String)"Global");
        name = StringUtils.remove((String)name, (String)"Configuration");
        name = StringUtils.remove((String)name, (String)"Category");
        return name.toLowerCase();
    }

    @Override
    public Class getTarget() {
        return this.category.getClass();
    }

    @Override
    public GlobalConfigurationCategory getTargetComponent(ConfigurationContext context) {
        return this.category;
    }

    @Override
    protected GlobalConfigurationCategory instance(Mapping mapping, ConfigurationContext context) {
        return this.category;
    }

    @Override
    @NonNull
    public Set describe() {
        return Jenkins.getInstance().getExtensionList(Descriptor.class).stream().filter(d -> d.getCategory() == this.category).filter(d -> d.getGlobalConfigPage() != null).map(DescriptorConfigurator::new).filter(GlobalConfigurationCategoryConfigurator::reportDescriptorWithoutSetters).map(c -> new Attribute(c.getName(), c.getTarget()).setter(Attribute.Setter.NOP)).collect(Collectors.toSet());
    }

    public static boolean reportDescriptorWithoutSetters(Configurator c) {
        if (c.describe().isEmpty()) {
            LOGGER.fine(c.getTarget().getName() + " has a global view but CasC didn't detect any configurable attribute; see: https://jenkins.io/redirect/casc-requirements/");
        }
        return true;
    }

    @Override
    @CheckForNull
    public CNode describe(GlobalConfigurationCategory instance, ConfigurationContext context) {
        Mapping mapping = new Mapping();
        Jenkins.getInstance().getExtensionList(Descriptor.class).stream().filter(this::filterDescriptors).forEach(d -> this.describe((Descriptor)d, mapping, context));
        return mapping;
    }

    private void describe(Descriptor d, Mapping mapping, ConfigurationContext context) {
        DescriptorConfigurator c = new DescriptorConfigurator(d);
        try {
            CNode node = c.describe(d, context);
            if (node != null) {
                mapping.put(c.getName(), node);
            }
        }
        catch (Exception e) {
            Scalar scalar = new Scalar("FAILED TO EXPORT " + d.getClass().getName() + " : " + ConfigurationAsCode.printThrowable(e));
            mapping.put(c.getName(), scalar);
        }
    }

    private boolean filterDescriptors(Descriptor d) {
        if (d.clazz.getName().equals(CREDENTIALS_PROVIDER_MANAGER_CONFIGURATION)) {
            return false;
        }
        return d.getCategory() == this.category && d.getGlobalConfigPage() != null;
    }
}

