/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.model.Describable;
import hudson.model.Saveable;
import hudson.util.DescribableList;
import hudson.util.PersistedList;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.impl.attributes.DescribableAttribute;
import io.jenkins.plugins.casc.impl.attributes.DescribableListAttribute;
import io.jenkins.plugins.casc.impl.attributes.PersistedListAttribute;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.AccessRestriction;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.None;

public abstract class BaseConfigurator<T>
implements Configurator<T> {
    private static final Logger LOGGER = Logger.getLogger(BaseConfigurator.class.getName());

    @Override
    @NonNull
    public Set<Attribute<T, ?>> describe() {
        HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
        Set<String> exclusions = this.exclusions();
        for (Field field : this.getTarget().getFields()) {
            String name = field.getName();
            if (exclusions.contains(name) || !PersistedList.class.isAssignableFrom(field.getType())) continue;
            if (Modifier.isTransient(field.getModifiers())) {
                exclusions.add(name);
                continue;
            }
            Attribute<Object, Object> attribute = this.createAttribute(name, TypePair.of(field)).getter(field::get);
            attributes.put(name, attribute);
        }
        Class target = this.getTarget();
        for (Method method : target.getMethods()) {
            Attribute prevAttribute;
            TypePair type;
            String methodName = method.getName();
            if (method.getParameterCount() == 0 && methodName.startsWith("get") && PersistedList.class.isAssignableFrom(method.getReturnType())) {
                type = TypePair.ofReturnType(method);
            } else {
                if (method.getParameterCount() != 1 || !methodName.startsWith("set")) continue;
                type = TypePair.ofParameter(method, 0);
            }
            String s = methodName.substring(3);
            String name = StringUtils.uncapitalize((String)s);
            if (exclusions.contains(name) || !this.hasGetter(target, s)) continue;
            LOGGER.log(Level.FINER, "Processing {0} property", name);
            Attribute attribute = this.createAttribute(name, type);
            if (attribute == null) continue;
            attribute.deprecated(method.getAnnotation(Deprecated.class) != null);
            Restricted r = method.getAnnotation(Restricted.class);
            if (r != null) {
                attribute.restrictions(r.value());
            }
            if ((prevAttribute = (Attribute)attributes.get(name)) != null && !prevAttribute.type.isAssignableFrom(attribute.type)) continue;
            attributes.put(name, attribute);
        }
        return new HashSet(attributes.values());
    }

    private boolean hasGetter(Class<T> c, String s) {
        List<String> candidates = Arrays.asList("get" + s, "is" + s);
        for (Method m : c.getMethods()) {
            if (m.getParameterCount() != 0 || !candidates.contains(m.getName())) continue;
            return true;
        }
        return false;
    }

    protected Set<String> exclusions() {
        return Collections.emptySet();
    }

    protected Attribute createAttribute(String name, TypePair type) {
        Attribute attribute;
        Class c;
        boolean multiple = type.rawType.isArray() || Collection.class.isAssignableFrom(type.rawType);
        Class clazz = c = multiple ? this.getComponentType(type) : type.rawType;
        if (c == null) {
            throw new IllegalStateException("Unable to detect type of attribute " + this.getTarget() + '#' + name);
        }
        if (DescribableList.class.isAssignableFrom(type.rawType)) {
            return new DescribableListAttribute(name, c);
        }
        if (PersistedList.class.isAssignableFrom(type.rawType)) {
            return new PersistedListAttribute(name, c);
        }
        if (!c.isPrimitive() && !c.isEnum() && Modifier.isAbstract(c.getModifiers())) {
            if (!Describable.class.isAssignableFrom(c)) {
                LOGGER.warning("Can't handle " + this.getTarget() + "#" + name + ": type is abstract but not Describable.");
                return null;
            }
            attribute = new DescribableAttribute(name, (Class<? extends Describable>)c);
        } else {
            attribute = new Attribute(name, c);
        }
        attribute.multiple(multiple);
        return attribute;
    }

    private Class getComponentType(TypePair type) {
        Type superclass;
        Class c = null;
        Type t = type.type;
        Class raw = type.rawType;
        while (t instanceof Class) {
            superclass = ((Class)t).getGenericSuperclass();
            if (superclass == null) {
                t = raw;
                break;
            }
            t = superclass;
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType at = (GenericArrayType)t;
            t = at.getGenericComponentType();
        }
        while (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            if (!((t = pt.getActualTypeArguments()[0]) instanceof WildcardType) || (t = ((WildcardType)t).getUpperBounds()[0]) != Object.class) continue;
            t = pt.getRawType();
        }
        while (c == null) {
            if (t instanceof Class) {
                c = (Class)t;
                continue;
            }
            if (t instanceof TypeVariable) {
                superclass = this.getTarget().getGenericSuperclass();
                if (superclass instanceof ParameterizedType) {
                    ParameterizedType psc = (ParameterizedType)superclass;
                    t = psc.getActualTypeArguments()[0];
                    continue;
                }
                c = (Class)((TypeVariable)t).getBounds()[0];
                TypeVariable typeVariable = (TypeVariable)t;
                continue;
            }
            return null;
        }
        if (c.isArray()) {
            c = c.getComponentType();
        }
        return c;
    }

    protected abstract T instance(Mapping var1, ConfigurationContext var2) throws ConfiguratorException;

    @Override
    @NonNull
    public T configure(CNode c, ConfigurationContext context) throws ConfiguratorException {
        T instance;
        block15: {
            Mapping mapping = c != null ? c.asMapping() : Mapping.EMPTY;
            instance = this.instance(mapping, context);
            if (instance instanceof Saveable) {
                try (BulkChange bc = new BulkChange((Saveable)instance);){
                    this.configure(mapping, instance, false, context);
                    bc.commit();
                    break block15;
                }
                catch (IOException e) {
                    throw new ConfiguratorException("Failed to save " + instance, e);
                }
            }
            this.configure(mapping, instance, false, context);
        }
        return instance;
    }

    @Override
    public T check(CNode c, ConfigurationContext context) throws ConfiguratorException {
        Mapping mapping = c != null ? c.asMapping() : Mapping.EMPTY;
        T instance = this.instance(mapping, context);
        this.configure(mapping, instance, true, context);
        return instance;
    }

    protected void configure(Mapping config, T instance, boolean dryrun, ConfigurationContext context) throws ConfiguratorException {
        Set<Attribute<T, ?>> attributes = this.describe();
        for (Attribute<T, ?> attribute : attributes) {
            Object valueToSet;
            String name = attribute.getName();
            CNode sub = this.removeIgnoreCase(config, name);
            if (sub == null) {
                for (String alias : attribute.aliases) {
                    sub = this.removeIgnoreCase(config, alias);
                    if (sub == null) continue;
                    context.warning(sub, "'" + alias + "' is an obsolete attribute name, please use '" + name + "'");
                    break;
                }
            }
            if (sub == null) continue;
            if (attribute.isDeprecated()) {
                context.warning(config, "'" + attribute.getName() + "' is deprecated");
                if (context.getDeprecated() == ConfigurationContext.Deprecation.reject) {
                    throw new ConfiguratorException("'" + attribute.getName() + "' is deprecated");
                }
            }
            for (Class<AccessRestriction> r : attribute.getRestrictions()) {
                if (r == None.class || r == Beta.class && context.getRestricted() == ConfigurationContext.Restriction.beta) continue;
                context.warning(config, "'" + attribute.getName() + "' is restricted: " + r.getSimpleName());
                if (context.getRestricted() != ConfigurationContext.Restriction.reject) continue;
                throw new ConfiguratorException("'" + attribute.getName() + "' is restricted: " + r.getSimpleName());
            }
            Class k = attribute.getType();
            Configurator configurator = context.lookupOrFail(k);
            if (attribute.isMultiple()) {
                ArrayList values = new ArrayList();
                for (CNode o : sub.asSequence()) {
                    Object value = dryrun ? configurator.check(o, context) : configurator.configure(o, context);
                    values.add(value);
                }
                valueToSet = values;
            } else {
                Object t = valueToSet = dryrun ? configurator.check(sub, context) : configurator.configure(sub, context);
            }
            if (dryrun) continue;
            try {
                attribute.setValue(instance, valueToSet);
            }
            catch (Exception ex) {
                throw new ConfiguratorException(configurator, "Failed to set attribute " + attribute, ex);
            }
        }
        this.handleUnknown(config, context);
    }

    protected final void handleUnknown(Mapping config, ConfigurationContext context) throws ConfiguratorException {
        if (!config.isEmpty()) {
            String invalid = StringUtils.join(config.keySet(), (char)',');
            String message = "Invalid configuration elements for type " + this.getTarget() + " : " + invalid + ".\nAvailable attributes : " + StringUtils.join((Collection)this.getAttributes().stream().map(Attribute::getName).collect(Collectors.toList()), (String)", ");
            context.warning(config, message);
            switch (context.getUnknown()) {
                case reject: {
                    throw new ConfiguratorException(message);
                }
                case warn: {
                    LOGGER.warning(message);
                }
            }
        }
    }

    @NonNull
    protected Mapping compare(T instance, T reference, ConfigurationContext context) throws Exception {
        Mapping mapping = new Mapping();
        for (Attribute attribute : this.getAttributes()) {
            if (attribute.equals(instance, reference)) continue;
            mapping.put(attribute.getName(), attribute.describe(instance, context));
        }
        return mapping;
    }

    private CNode removeIgnoreCase(Mapping config, String name) {
        for (String k : config.keySet()) {
            if (!name.equalsIgnoreCase(k)) continue;
            return (CNode)config.remove(k);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseConfigurator) {
            return this.getTarget() == ((BaseConfigurator)obj).getTarget();
        }
        return false;
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public static final class TypePair {
        final Type type;
        final Class rawType;

        public TypePair(Type type, Class rawType) {
            this.rawType = rawType;
            this.type = type;
        }

        static TypePair ofReturnType(Method method) {
            return new TypePair(method.getGenericReturnType(), method.getReturnType());
        }

        static TypePair ofParameter(Method method, int index) {
            assert (method.getParameterCount() > index);
            return new TypePair(method.getGenericParameterTypes()[index], method.getParameterTypes()[index]);
        }

        public static TypePair of(Parameter parameter) {
            return new TypePair(parameter.getParameterizedType(), parameter.getType());
        }

        public static TypePair of(Field field) {
            return new TypePair(field.getGenericType(), field.getType());
        }
    }
}

