/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.core;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ProxyConfiguration;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.model.Mapping;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class ProxyConfigurator
extends BaseConfigurator<ProxyConfiguration> {
    @Override
    public Class<ProxyConfiguration> getTarget() {
        return ProxyConfiguration.class;
    }

    @Override
    protected void configure(Mapping config, ProxyConfiguration instance, boolean dryrun, ConfigurationContext context) throws ConfiguratorException {
        super.configure(config, instance, dryrun, context);
    }

    @Override
    protected ProxyConfiguration instance(Mapping mapping, ConfigurationContext context) throws ConfiguratorException {
        Set<String> keys = mapping.keySet();
        return new ProxyConfiguration(mapping.getScalarValue("name"), Integer.parseInt(mapping.getScalarValue("port")), this.getOptionalParam(mapping, keys, "userName"), this.getOptionalParam(mapping, keys, "password"), this.getOptionalParam(mapping, keys, "noProxyHost"), this.getOptionalParam(mapping, keys, "testUrl"));
    }

    private String getOptionalParam(Mapping mapping, Set<String> keys, String key) throws ConfiguratorException {
        return keys.contains(key) ? mapping.getScalarValue(key) : null;
    }

    @Override
    @NonNull
    public Set<Attribute<ProxyConfiguration, ?>> describe() {
        return new HashSet(Arrays.asList(new Attribute<ProxyConfiguration, String>("name", String.class).getter(config -> config.name).setter(Attribute.noop()), new Attribute<ProxyConfiguration, Integer>("port", Integer.class).getter(config -> config.port).setter(Attribute.noop()), new Attribute<ProxyConfiguration, String>("userName", String.class).getter(ProxyConfiguration::getUserName).setter(Attribute.noop()), new Attribute<ProxyConfiguration, String>("password", String.class).getter(ProxyConfiguration::getEncryptedPassword).setter(Attribute.noop()), new Attribute<ProxyConfiguration, String>("noProxyHost", String.class).getter(config -> config.noProxyHost).setter(Attribute.noop()), new Attribute<ProxyConfiguration, String>("testUrl", String.class).getter(ProxyConfiguration::getTestUrl).setter(Attribute.noop())));
    }
}

